/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Constraint;
import bossa.syntax.Expression;
import bossa.syntax.Function;
import bossa.syntax.MonoSymbol;
import bossa.syntax.Monotype;
import bossa.syntax.PrimitiveType;
import bossa.syntax.ReturnStmt;
import bossa.syntax.Statement;
import bossa.util.Located;
import bossa.util.User;
import bossa.util.Util;
import gnu.expr.LambdaExp;
import java.util.List;
import mlsub.typing.FunType;
import mlsub.typing.Polytype;
import nice.tools.code.Gen;
import nice.tools.code.Types;

public class FunExp
extends Expression
implements Function {
    private boolean alwaysReturns;
    private Polytype inferredReturnType;
    MonoSymbol[] formals;
    Constraint constraint;
    mlsub.typing.Constraint cst;
    Statement body;
    boolean mightEscape = true;

    public FunExp(Constraint cst, List formals, Statement body) {
        this.formals = formals.toArray(new MonoSymbol[formals.size()]);
        this.constraint = cst;
        this.body = body;
    }

    FunExp(Constraint cst, MonoSymbol[] formals, Statement body) {
        this.formals = formals;
        this.constraint = cst;
        this.body = body;
        this.setLocation(body.location());
    }

    public mlsub.typing.Monotype getExpectedType() {
        return null;
    }

    public void checkReturnedType(Polytype returned) throws Function.ReturnTypeError {
        if (this.inferredReturnType == null) {
            this.inferredReturnType = returned;
        } else {
            Polytype old = this.inferredReturnType;
            this.inferredReturnType = Polytype.union(this.inferredReturnType, returned);
            if (!this.inferredReturnType.trySimplify()) {
                throw new Function.IncompatibleReturnType(old);
            }
        }
    }

    void setAlwaysReturns(boolean value) {
        this.alwaysReturns = value;
    }

    void computeType() {
        if (this.inferredReturnType == null) {
            this.inferredReturnType = this.alwaysReturns ? Polytype.bottom() : PrimitiveType.voidPolytype;
        } else if (!this.alwaysReturns && !nice.tools.typing.Types.isVoid(this.inferredReturnType)) {
            throw User.error((Located)this, "Missing return statement");
        }
        FunType t = new FunType(MonoSymbol.getMonotype(this.formals), this.inferredReturnType.getMonotype());
        this.type = new Polytype(mlsub.typing.Constraint.and(this.cst, this.inferredReturnType.getConstraint()), Monotype.sure(t));
    }

    Polytype inferredReturnType() {
        this.getType();
        return this.inferredReturnType;
    }

    public gnu.expr.Expression compile() {
        LambdaExp res = Gen.createMethod(null, Types.javaType(MonoSymbol.getMonotype(this.formals)), Types.javaType(this.inferredReturnType()), this.formals, false);
        Gen.setMethodBody(res, this.body.generateCode());
        return res;
    }

    public String toString() {
        return (this.constraint == null ? mlsub.typing.Constraint.toString(this.cst) : this.constraint.toString()) + "(" + Util.map("", ", ", "", this.formals) + ") => " + (this.body instanceof ReturnStmt ? ((ReturnStmt)this.body).value.toString() : this.body.toString());
    }
}

