/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.AtomicConstraint;
import bossa.syntax.Node;
import bossa.util.Internal;
import bossa.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mlsub.typing.MonotypeVar;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;

public class Constraint
extends Node {
    public static final Constraint True = new Constraint(new ArrayList(0), new ArrayList(0));
    private List binders;
    private List atomics;

    public Constraint(List binders, List atomics) {
        super(3);
        this.construct(binders, atomics);
    }

    public Constraint(TypeSymbol[] binders, List atomics) {
        super(3);
        this.construct(this.arrayToList(binders), atomics);
    }

    static Constraint create(TypeSymbol[] binders) {
        if (binders == null) {
            return True;
        }
        return new Constraint(binders, null);
    }

    private List arrayToList(Object[] a) {
        if (a == null || a.length == 0) {
            return null;
        }
        ArrayList<Object> res = new ArrayList<Object>(a.length);
        for (int i = 0; i < a.length; ++i) {
            res.add(a[i]);
        }
        return res;
    }

    private void construct(List binders, List atomics) {
        if (binders == null) {
            binders = Collections.EMPTY_LIST;
        } else {
            this.addTypeSymbols(binders);
        }
        this.binders = binders;
        this.atomics = atomics == null ? Collections.EMPTY_LIST : atomics;
    }

    Constraint shallowClone() {
        return new Constraint(this.cloneList(this.binders), this.cloneList(this.atomics));
    }

    private List cloneList(List l) {
        if (l instanceof ArrayList) {
            return (List)((ArrayList)l).clone();
        }
        return (List)((LinkedList)l).clone();
    }

    mlsub.typing.Constraint resolveToLowlevel() {
        TypeSymbol[] newBinders = null;
        if (this.binders.size() > 0) {
            newBinders = new TypeSymbol[this.binders.size()];
            int n = 0;
            Iterator i = this.binders.iterator();
            while (i.hasNext()) {
                newBinders[n++] = (TypeSymbol)i.next();
            }
        }
        return mlsub.typing.Constraint.create(newBinders, AtomicConstraint.resolve(this.typeScope, this.atomics));
    }

    public String toString() {
        if (this.atomics.size() == 0) {
            return Util.map("<", ", ", "> ", this.binders);
        }
        if (this.binders.size() == 0) {
            return Util.map("<", ", ", "> ", this.atomics);
        }
        StringBuffer res = new StringBuffer("<");
        boolean first = true;
        Constraint c = this.shallowClone();
        Iterator i = c.binders.iterator();
        block0: while (i.hasNext()) {
            TypeSymbol s = (TypeSymbol)i.next();
            if (!(s instanceof TypeConstructor)) {
                MonotypeVar mv = (MonotypeVar)s;
                Iterator j = c.atomics.iterator();
                while (j.hasNext()) {
                    AtomicConstraint atom = (AtomicConstraint)j.next();
                    if (!atom.isSureConstraintFor(mv)) continue;
                    if (first) {
                        first = false;
                    } else {
                        res.append(',');
                    }
                    res.append('!').append(s);
                    j.remove();
                    i.remove();
                    continue block0;
                }
                continue;
            }
            TypeConstructor tc = (TypeConstructor)s;
            boolean ok = false;
            Iterator j = c.atomics.iterator();
            while (j.hasNext()) {
                AtomicConstraint atom = (AtomicConstraint)j.next();
                String parent = atom.getParentFor(tc);
                if (parent == null) continue;
                if (first) {
                    first = false;
                } else {
                    res.append(',');
                }
                res.append(parent).append(' ').append(tc);
                j.remove();
                i.remove();
                ok = true;
                break;
            }
            if (ok) continue;
            Internal.error("Unable to print the constraint in a parsable form because of " + tc);
        }
        res.append(Util.map(res.length() > 1 ? ", " : "", ", ", "", c.binders));
        res.append(Util.map(" | ", ", ", "", c.atomics)).append("> ");
        return res.toString();
    }

    void addFirstBinder(TypeSymbol s) {
        if (this.binders == Collections.EMPTY_LIST) {
            this.binders = new ArrayList(4);
        }
        this.binders.add(0, s);
        this.addTypeSymbol(s);
    }

    void addBinder(TypeSymbol s) {
        if (this.binders == Collections.EMPTY_LIST) {
            this.binders = new ArrayList(4);
        }
        if (!this.binders.contains(s)) {
            this.binders.add(s);
            this.addTypeSymbol(s);
        }
    }

    void addBinders(TypeSymbol[] bs) {
        if (bs == null) {
            return;
        }
        for (int i = 0; i < bs.length; ++i) {
            this.addBinder(bs[i]);
        }
    }

    void addAtom(AtomicConstraint atom) {
        this.atomics.add(atom);
    }

    void addAtoms(List l) {
        this.atomics.addAll(l);
    }

    List getBinders() {
        return this.binders;
    }

    List getAtoms() {
        return this.atomics;
    }

    TypeSymbol[] getBinderArray() {
        return this.binders.toArray(new TypeSymbol[this.binders.size()]);
    }
}

