/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.ClassDefinition;
import bossa.syntax.Definition;
import bossa.syntax.LocatedString;
import bossa.syntax.TypeConstructors;
import bossa.syntax.TypeIdent;
import bossa.util.Located;
import bossa.util.User;
import java.io.PrintWriter;
import mlsub.typing.Interface;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;

public class AbstractInterfaceImplementation
extends Definition {
    final LocatedString className;
    final LocatedString interfaceName;
    final boolean _finally;
    final boolean _interface;
    TypeConstructor classTC;
    Interface interfaceITF;

    public AbstractInterfaceImplementation(LocatedString className, LocatedString interfaceName, boolean _finally, boolean _interface) {
        super(className, 4);
        this.className = className;
        this.interfaceName = interfaceName;
        this._finally = _finally;
        this._interface = _interface;
    }

    public void resolve() {
        this.classTC = new TypeIdent(this.className).resolveToTC(this.typeScope);
        if (TypeConstructors.isInterface(this.classTC)) {
            if (!this._interface) {
                User.error((Located)this, "" + this.classTC + " is not a class");
            }
        } else if (this._interface) {
            User.error((Located)this, "" + this.classTC + " is not an interface");
        }
        TypeIdent ident = new TypeIdent(new LocatedString(this.module.getName() + '.' + this.interfaceName.content, this.interfaceName.location()));
        this.interfaceITF = ident.resolveToItf(this.typeScope);
        ClassDefinition def = ClassDefinition.get(this.classTC);
        if (def != null) {
            def.addInterfaceImplementation(this.interfaceITF);
        }
        this.createContext();
    }

    private void createContext() {
        try {
            Typing.assertImp(this.classTC, this.interfaceITF, true);
            if (this._finally) {
                Typing.assertAbs(this.classTC, this.interfaceITF);
            }
        }
        catch (TypingEx ex) {
            User.error((Located)this, "Class " + this.classTC + " cannot implement " + this.interfaceITF + ": they do not have the same number or kind of type parameters");
        }
    }

    public void printInterface(PrintWriter w) {
        if (this._interface) {
            w.print("interface ");
        } else {
            w.print("class ");
        }
        w.print(this.classTC);
        w.print(" implements ");
        w.print(this.interfaceName);
        w.println(";");
    }

    public void compile() {
    }
}

