/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.ClassDefinition;
import bossa.syntax.CustomConstructor;
import bossa.syntax.DefaultMethodImplementation;
import bossa.syntax.Definition;
import bossa.syntax.EnumDefinition;
import bossa.syntax.GlobalVarDeclaration;
import bossa.syntax.MethodBodyDefinition;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.Module;
import bossa.syntax.Node;
import bossa.util.UserError;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AST
extends Node {
    private Module module;
    private ClassDefinition[] classes;
    private MethodDeclaration[] methods;
    private MethodBodyDefinition[] methodImplementations;
    private GlobalVarDeclaration[] globals;
    private CustomConstructor[] customConstructors;

    public AST(Module module, List defs) {
        super(defs, 1);
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.module = module;
        this.findElements();
    }

    public List definitions() {
        return this.children;
    }

    private void findElements() {
        ArrayList classes = new ArrayList(this.children.size());
        ArrayList methods = new ArrayList(this.children.size());
        ArrayList globals = new ArrayList(10);
        ArrayList customConstructors = new ArrayList(10);
        ArrayList methodImplementations = new ArrayList(10);
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            Object node = i.next();
            if (node instanceof ClassDefinition) {
                classes.add(node);
                continue;
            }
            if (node instanceof CustomConstructor) {
                customConstructors.add(node);
                methods.add(node);
                continue;
            }
            if (node instanceof MethodDeclaration) {
                methods.add(node);
                continue;
            }
            if (node instanceof MethodBodyDefinition) {
                methodImplementations.add(node);
                continue;
            }
            if (node instanceof EnumDefinition) {
                classes.add(((EnumDefinition)node).classDef);
                continue;
            }
            if (node instanceof GlobalVarDeclaration) {
                globals.add(node);
                continue;
            }
            if (!(node instanceof DefaultMethodImplementation)) continue;
            methods.add(((DefaultMethodImplementation)node).getDeclaration());
        }
        this.classes = classes.toArray(new ClassDefinition[classes.size()]);
        this.methods = methods.toArray(new MethodDeclaration[methods.size()]);
        this.globals = globals.toArray(new GlobalVarDeclaration[globals.size()]);
        this.customConstructors = customConstructors.toArray(new CustomConstructor[customConstructors.size()]);
        this.methodImplementations = methodImplementations.toArray(new MethodBodyDefinition[methodImplementations.size()]);
    }

    public void buildScope() {
        this.buildScope(this.module);
    }

    private void resolve(Node n) {
        try {
            n.doResolve();
        }
        catch (UserError ex) {
            this.module.compilation().error(ex);
        }
    }

    public void resolveScoping() {
        int i;
        Node.setModule(this.module);
        for (i = 0; i < this.customConstructors.length; ++i) {
            this.resolve(this.customConstructors[i]);
        }
        for (i = 0; i < this.classes.length; ++i) {
            this.resolve(this.classes[i]);
        }
        Iterator i2 = this.children.iterator();
        while (i2.hasNext()) {
            Node n = (Node)i2.next();
            this.resolve(n);
        }
        this.module.compilation().exitIfErrors();
    }

    public void typedResolve() {
        int i;
        Node.setModule(this.module);
        for (i = 0; i < this.methods.length; ++i) {
            try {
                this.methods[i].typedResolve();
                continue;
            }
            catch (UserError ex) {
                this.module.compilation().error(ex);
            }
        }
        for (i = 0; i < this.methodImplementations.length; ++i) {
            try {
                this.methodImplementations[i].lateBuildScope();
                continue;
            }
            catch (UserError ex) {
                this.module.compilation().error(ex);
            }
        }
        this.module.compilation().exitIfErrors();
    }

    public void localResolve() {
        Node.setModule(this.module);
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            Definition d = (Definition)i.next();
            try {
                d.resolveBody();
            }
            catch (UserError ex) {
                this.module.compilation().error(ex);
            }
        }
        this.module.compilation().exitIfErrors();
        for (int i2 = 0; i2 < this.classes.length; ++i2) {
            this.classes[i2].precompile();
        }
    }

    public void typechecking(boolean compiling) {
        int i;
        Node.setModule(this.module);
        for (i = 0; i < this.classes.length; ++i) {
            this.classes[i].typecheckClass();
        }
        if (!compiling) {
            for (i = 0; i < this.methods.length; ++i) {
                this.methods[i].typecheckCompiled();
            }
            return;
        }
        this.doTypecheck();
        this.module.compilation().exitIfErrors();
    }

    public void printInterface(PrintWriter s) {
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            ((Definition)i.next()).printInterface(s);
        }
    }

    public void compile(boolean generateCode) {
        if (!generateCode) {
            for (int i = 0; i < this.classes.length; ++i) {
                this.classes[i].recompile();
            }
        } else {
            for (int i = 0; i < this.globals.length; ++i) {
                this.globals[i].compile();
            }
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                ((Definition)i.next()).compile();
            }
        }
    }

    public String toString() {
        return "Abstract Syntax Tree (" + this.numberOfDeclarations() + " declarations)";
    }

    public int numberOfDeclarations() {
        return this.children.size();
    }
}

