/*
 * Decompiled with CFR 0.152.
 */
package bossa.modules;

import bossa.modules.CompiledContent;
import bossa.modules.DirectoryCompiledContent;
import bossa.modules.Package;
import bossa.modules.SourceContent;
import bossa.parser.Loader;
import bossa.syntax.LocatedString;
import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import bossa.util.UserError;
import gnu.bytecode.ClassType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import nice.tools.util.System;

class Content {
    boolean sourceRead;
    long lastModification;
    long lastCompilation;
    private Package pkg;
    private SourceContent source;
    private CompiledContent compiled;

    Content(Package pkg, SourceContent source, CompiledContent compiled) {
        this.pkg = pkg;
        this.source = source;
        this.compiled = compiled;
        if (source == null && compiled == null) {
            User.error((Located)pkg, "Package " + pkg.getName() + " is not available." + "\nThe source  path is: " + this.str(pkg.compilation.sourcePath) + "\nThe package path is: " + this.str(pkg.compilation.packagePath));
        }
        if (compiled != null) {
            this.lastCompilation = compiled.lastCompilation;
        }
        if (source != null) {
            this.lastModification = source.lastModification;
        }
    }

    private String str(String s) {
        return s == null ? "<empty>" : s;
    }

    List getImports(Set opens) {
        Unit[] readers = this.source != null && (this.compiled == null || this.lastModification > this.lastCompilation) ? this.source.getDefinitions() : this.compiled.getDefinitions();
        LinkedList imports = new LinkedList();
        for (int i = 0; i < readers.length; ++i) {
            this.read(readers[i], imports, opens);
        }
        return imports;
    }

    void getDefinitions(List definitions, boolean shouldReload, boolean storeDocStrings) {
        Unit[] readers = this.getReaders(shouldReload);
        for (int i = 0; i < readers.length; ++i) {
            try {
                this.read(readers[i], definitions, storeDocStrings);
                continue;
            }
            catch (UserError ex) {
                this.pkg.compilation.error(ex);
            }
        }
        this.pkg.compilation.exitIfErrors();
    }

    private void read(Unit unit, List imports, Set opens) {
        Location.setCurrentFile(unit.file);
        LocatedString pkgName = Loader.readImports(unit.reader, imports, opens);
        if (pkgName != null && !pkgName.equals(this.pkg.name)) {
            User.error((Located)pkgName, this.source + " declares it belongs to package " + pkgName + ", but it was found in package " + this.pkg.name);
        }
    }

    private void read(Unit unit, List definitions, boolean storeDocStrings) {
        Location.setCurrentFile(unit.file);
        Loader.open(unit.reader, definitions, storeDocStrings);
    }

    Unit[] getReaders(boolean shouldReload) {
        shouldReload |= this.compiled == null;
        if (this.lastModification > this.lastCompilation) {
            if (Debug.modules && !shouldReload) {
                Debug.println(this.pkg + " compiled: " + System.date(this.lastCompilation));
                Debug.println(this.pkg + " modified: " + System.date(this.lastModification));
                Debug.println("Recompiling " + this.pkg);
            }
            shouldReload = true;
        }
        if (shouldReload && this.source != null) {
            this.sourceRead = true;
            return this.source.getDefinitions();
        }
        if (this.lastModification > this.lastCompilation) {
            User.error((Located)this.pkg, this.pkg.getName() + " must be compiled, but no source code is available.\nThe source path is: " + this.pkg.compilation.sourcePath);
        }
        if (Debug.modules) {
            Debug.println("Loading compiled version of " + this.pkg);
        }
        return this.compiled.getDefinitions();
    }

    public String getName() {
        if (this.sourceRead) {
            return this.source.getName();
        }
        if (this.compiled != null) {
            return this.compiled.getName();
        }
        return "";
    }

    public String toString() {
        return "Source  : " + (this.source == null ? "none" : this.source.getName()) + "\nCompiled: " + (this.compiled == null ? "none" : this.compiled.getName());
    }

    void someImportModified(long date) {
        if (this.lastModification < date) {
            this.lastModification = date;
        }
    }

    ClassType getBytecode() {
        if (this.sourceRead) {
            return null;
        }
        return this.compiled.bytecode;
    }

    ClassType getDispatch() {
        if (this.sourceRead) {
            return null;
        }
        return this.compiled.dispatch;
    }

    ClassType readClass(String name) {
        if (this.sourceRead) {
            return null;
        }
        return this.compiled.readClass(name);
    }

    File getOutputDirectory() {
        String destDir = this.pkg.compilation.destinationDir;
        if (destDir == null) {
            if (this.source != null) {
                return this.source.getOutputDirectory();
            }
            destDir = ".";
        }
        File res = new File(destDir, this.pkg.getName().replace('.', File.separatorChar));
        res.mkdirs();
        return res;
    }

    Stream[] getClasses(boolean linkPerformed) {
        Stream[] res;
        if (!this.sourceRead) {
            res = this.compiled.getClasses(!linkPerformed);
            if (linkPerformed) {
                File dispatchFile = new File(this.getOutputDirectory(), "dispatch.class");
                try {
                    res[res.length - 1] = new Stream(new FileInputStream(dispatchFile), "dispatch.class");
                }
                catch (FileNotFoundException e) {
                    Internal.error(this.pkg + ": dispatch class could not be added to archive" + "\nI expected it to be in " + dispatchFile);
                }
            }
        } else {
            res = DirectoryCompiledContent.getClasses(this.getOutputDirectory(), true);
        }
        return res;
    }

    protected static class Stream {
        InputStream stream;
        String name;

        Stream(InputStream stream, String name) {
            this.stream = stream;
            this.name = name;
        }
    }

    protected static class Unit {
        BufferedReader reader;
        String name;
        File file;

        protected Unit(BufferedReader reader, File file) {
            this.reader = reader;
            this.file = file;
        }

        protected Unit(BufferedReader reader, String name) {
            this.reader = reader;
            this.name = name;
        }
    }
}

