/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.testsuite.output;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import nice.tools.testsuite.TestCase;
import nice.tools.testsuite.TestSuite;
import nice.tools.testsuite.output.Output;
import nice.tools.testsuite.output.OutputWriter;

public abstract class AbstractOutput
implements Output {
    private OutputWriter _writer;

    public AbstractOutput(Writer out) {
        this._writer = new OutputWriter(out);
    }

    private void write(String str) {
        try {
            this._writer.write(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void mark() {
        this._writer.mark();
    }

    protected void reset() {
        this._writer.reset();
    }

    public void close() {
        try {
            this._writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void flush() {
        try {
            this._writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void log(String statement) {
        this.log(null, statement);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void log(String prefix, String statement) {
        if (statement.length() == 0) {
            this.write(this.getIndent());
            this.write((prefix == null ? "" : "[" + prefix + "] ") + statement + this.getLineBreak());
            return;
        }
        BufferedReader reader = null;
        String line = "";
        reader = new BufferedReader(new StringReader(statement));
        while ((line = reader.readLine()) != null) {
            this.write(this.getIndent());
            this.write((prefix == null ? "" : "[" + prefix + "] ") + line + this.getLineBreak());
        }
        Object var7_5 = null;
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return;
        {
            catch (IOException e) {
                e.printStackTrace();
                Object var7_6 = null;
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    public void logAndFlush(String statement) {
        this.log(null, statement);
        this.flush();
    }

    public void logAndFlush(String prefix, String statement) {
        this.log(prefix, statement);
        this.flush();
    }

    protected String getLineBreak() {
        return "\n";
    }

    protected String getIndent() {
        return "";
    }

    public abstract void endTestCase(boolean var1);

    public abstract void startTestCase(TestCase var1);

    public abstract void endTestSuite();

    public abstract void startTestSuite(TestSuite var1);

    public abstract void endApplication();

    public abstract void startApplication();
}

