/*
 * Decompiled with CFR 0.152.
 */
package nice.lang.inline;

import bossa.util.User;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.Procedure1;
import nice.lang.inline.Tools;

public class UnaryNumOp
extends Procedure1
implements Inlineable {
    private static final int error = 0;
    private static final int Neg = 1;
    private static final int Comp = 2;
    private final PrimType type;
    private final int kind;

    public static Procedure1 create(String param) {
        PrimType type = Tools.numericType(param.charAt(0));
        if (type == null) {
            User.error("Unknown type in inlined numeric operator: " + param);
        }
        param = param.substring(1);
        int kind = 0;
        if ("Neg".equals(param)) {
            kind = 1;
        } else if ("Comp".equals(param)) {
            kind = 2;
        } else {
            User.error("Unknown inlined unary numeric operator " + param);
        }
        return new UnaryNumOp(kind, type);
    }

    private UnaryNumOp(int kind, PrimType type) {
        this.kind = kind;
        this.type = type;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        CodeAttr code = comp.getCode();
        StackTarget stack = new StackTarget(this.type);
        args[0].compile(comp, stack);
        if (this.kind == 1) {
            code.emitNeg();
        } else if (this.kind == 2) {
            if (this.type == Type.long_type) {
                code.emitPushLong(-1L);
            } else {
                code.emitPushInt(-1);
            }
            code.emitXOr();
        } else {
            throw new Error();
        }
        target.compileFromStack(comp, this.type);
    }

    public Type getReturnType(Expression[] args) {
        return this.type;
    }

    public Object apply1(Object arg) {
        throw new Error("Not implemented");
    }
}

