/*
 * Decompiled with CFR 0.152.
 */
package nice.lang.inline;

import bossa.util.User;
import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.Procedure3;
import gnu.mapping.Values;
import java.lang.reflect.Array;
import nice.lang.inline.Tools;

public class ArraySetOp
extends Procedure3
implements Inlineable {
    private final Type type;
    private static Method reflectSet = ClassType.make("java.lang.reflect.Array").getDeclaredMethod("set", 3);

    public static ArraySetOp create(String param) {
        Type type = Tools.type(param.charAt(0));
        if (type == null) {
            User.error("Unknown type in array write acces operator: " + param);
        }
        return new ArraySetOp(type);
    }

    public ArraySetOp(Type type) {
        this.type = type;
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        CodeAttr code = comp.getCode();
        boolean needReturn = !(target instanceof IgnoreTarget);
        args[0].compile(comp, Target.pushObject);
        boolean bytecodeArray = Tools.monomorphicArray(code.topType());
        args[1].compile(comp, Tools.intTarget);
        Type componentType = this.getComponentType(args[0].getType());
        args[2].compile(comp, componentType);
        if (needReturn) {
            code.emitDup(componentType.getSize() > 4 ? 2 : 1, 2);
        }
        if (bytecodeArray) {
            code.emitArrayStore(componentType);
        } else {
            code.emitInvokeStatic(reflectSet);
        }
        if (needReturn) {
            target.compileFromStack(comp, componentType);
        }
    }

    public Type getReturnType(Expression[] args) {
        return this.getComponentType(args[0].getType());
    }

    private Type getComponentType(Type array) {
        if (this.type == Type.pointer_type && array instanceof ArrayType) {
            return ((ArrayType)array).getComponentType();
        }
        return this.type;
    }

    public Object apply3(Object arg1, Object arg2, Object arg3) {
        Array.set(arg1, ((Number)arg2).intValue(), this.type.coerceFromObject(arg3));
        return Values.empty;
    }
}

