/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing.lowlevel;

import java.util.Vector;
import mlsub.typing.lowlevel.BitMatrix;
import mlsub.typing.lowlevel.BitVector;
import mlsub.typing.lowlevel.Domain;
import mlsub.typing.lowlevel.K0;
import mlsub.typing.lowlevel.LowlevelUnsatisfiable;
import mlsub.typing.lowlevel.S;
import mlsub.typing.lowlevel.Separator;

final class DomainVector
extends Vector {
    int offset;
    int width;

    public DomainVector(int offset, int width) {
        this.offset = offset;
        this.width = width;
    }

    public DomainVector(int offset, int width, int n) {
        super(n);
        this.setSize(n);
        int i = 0;
        while (i < n) {
            this.setElementAt(new Domain(width), i);
            ++i;
        }
        this.offset = offset;
        this.width = width;
    }

    public Domain getDomain(int x) {
        return (Domain)this.elementAt(x - this.offset);
    }

    private boolean isValidSoft(int x) {
        return x >= this.offset && x - this.offset < this.size() && this.getDomain(x) != null;
    }

    private boolean isGarbage(int x) {
        return x >= this.offset && x - this.offset < this.size() && this.getDomain(x) == null;
    }

    public void clear(int x) {
        this.setElementAt(null, x - this.offset);
    }

    public void reduce(int x, boolean unit, BitVector domain) throws LowlevelUnsatisfiable {
        S.assume(this.isValidSoft(x));
        Domain d = this.getDomain(x);
        d.reduce(unit, domain);
    }

    public void exclude(int x, BitVector domain) throws LowlevelUnsatisfiable {
        S.assume(this.isValidSoft(x));
        Domain d = this.getDomain(x);
        d.exclude(domain);
    }

    public void merge(int src, int dest) throws LowlevelUnsatisfiable {
        S.assume(this.isValidSoft(src));
        Domain srcDomain = this.getDomain(src);
        if (dest >= this.offset) {
            this.reduce(dest, srcDomain.containsUnit(), srcDomain);
        } else {
            S.assume(srcDomain.get(dest), src + " merged with " + dest);
        }
        this.clear(src);
    }

    public void exclude(int value) throws LowlevelUnsatisfiable {
        int i = 0;
        while (i < this.elementCount) {
            Domain d = (Domain)this.elementData[i];
            if (d != null) {
                d.exclude(value);
            }
            ++i;
        }
    }

    public void move(int src, int dest) {
        S.assume(this.isValidSoft(src));
        S.assume(this.isGarbage(dest));
        this.setElementAt(this.getDomain(src), dest - this.offset);
        this.clear(src);
    }

    public void extend() {
        this.addElement(new Domain(this.width));
    }

    public Object clone() {
        DomainVector result = (DomainVector)super.clone();
        int i = 0;
        while (i < this.elementCount) {
            Domain d = (Domain)this.elementData[i];
            if (d != null) {
                result.elementData[i] = (Domain)d.clone();
            }
            ++i;
        }
        return result;
    }

    private boolean gfpSweep(BitMatrix R, BitMatrix C, int[] strategy, int dS, int direction) throws LowlevelUnsatisfiable {
        boolean changed = false;
        BitVector ideal = new BitVector(this.width);
        boolean idealContainsUnit = false;
        int length = strategy.length;
        int s = dS > 0 ? 0 : length - 1;
        while (s >= 0 && s < length) {
            int x = strategy[s];
            Domain dx = this.getDomain(x);
            if (dx != null) {
                if (dx.isEmpty()) {
                    throw new LowlevelUnsatisfiable();
                }
                if (dx.needPropagation(direction)) {
                    changed = true;
                    ideal.clearAll();
                    idealContainsUnit = dx.containsUnit();
                    ideal.addProduct(R, dx);
                    int j = this.offset;
                    while (j < this.offset + this.elementCount) {
                        Domain dj = this.getDomain(j);
                        if (dj != null && C.get(x, j)) {
                            if (K0.debugK0) {
                                S.dbg.println("Reducing domain of " + j);
                                S.dbg.println("from " + dj);
                                S.dbg.println("with ideal of " + x + ": " + ideal);
                            }
                            dj.reduce(idealContainsUnit, ideal);
                        }
                        ++j;
                    }
                }
            }
            s += dS;
        }
        return changed;
    }

    public void gfp(BitMatrix R, BitMatrix Rt, BitMatrix C, BitMatrix Ct, int[] strategy) throws LowlevelUnsatisfiable {
        boolean changed;
        do {
            changed = this.gfpSweep(R, C, strategy, 1, 0);
        } while (changed = this.gfpSweep(Rt, Ct, strategy, -1, 1) || changed);
    }

    void initGfpCardinals() {
        int i = 0;
        while (i < this.elementCount) {
            Domain d = (Domain)this.elementData[i];
            if (d != null) {
                d.initGfpCardinals();
            }
            ++i;
        }
    }

    public int chooseDomain() {
        return this.chooseDomain(null);
    }

    public int chooseDomain(BitVector set) {
        int leastCard = Integer.MAX_VALUE;
        int least = Integer.MIN_VALUE;
        int i = 0;
        while (i < this.elementCount) {
            int card;
            Domain d;
            if ((set == null || set.get(i + this.offset)) && (d = (Domain)this.elementAt(i)) != null && (card = d.cardinal()) < leastCard && card > 1) {
                least = i + this.offset;
                leastCard = card;
            }
            ++i;
        }
        return least;
    }

    public String dump() {
        Separator sep = new Separator(", ");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.elementCount) {
            if (this.elementData[i] != null) {
                sb.append(sep).append("D(").append(i + this.offset).append(") = ").append(this.elementData[i]);
            }
            ++i;
        }
        return sb.toString();
    }
}

