/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import bossa.syntax.ClassDefinition;
import bossa.syntax.PrimitiveType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mlsub.typing.Constraint;
import mlsub.typing.Debug;
import mlsub.typing.FunTypeKind;
import mlsub.typing.InternalError;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeVar;
import mlsub.typing.TopMonotype;
import mlsub.typing.TupleKind;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import mlsub.typing.lowlevel.BitVector;
import mlsub.typing.lowlevel.Element;
import mlsub.typing.lowlevel.Engine;
import mlsub.typing.lowlevel.Kind;
import mlsub.typing.lowlevel.LowlevelSolutionHandler;
import mlsub.typing.lowlevel.Unsatisfiable;

public class Enumeration {
    private static List emptyList = new LinkedList();
    public static boolean linkDbg;

    public static List enumerate(Constraint cst, Element[] tags, boolean[] all) {
        ArrayList res = new ArrayList();
        try {
            int l = Typing.enter();
            try {
                Constraint.enter(cst);
                Enumeration.setFloatingKinds(tags, all, 0, res, true);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (Typing.leave() != l) {
                    throw new InternalError("Unmatched enter and leaves");
                }
                throw throwable;
            }
            if (Typing.leave() != l) {
                throw new InternalError("Unmatched enter and leaves");
            }
        }
        catch (TypingEx e) {
            return new LinkedList();
        }
        catch (Unsatisfiable e) {
            throw new InternalError("This shouldn't happen");
        }
        return res;
    }

    private static final void setFloatingKinds(Element[] tags, boolean[] all, int minFloating, List res, boolean doAll) throws Unsatisfiable {
        while (minFloating < tags.length && (all[minFloating] != doAll || Enumeration.isFixedKind(tags[minFloating].getKind()))) {
            ++minFloating;
        }
        if (minFloating < tags.length) {
            Element tag = tags[minFloating];
            if (tag.getKind() == TopMonotype.TopKind.instance) {
                tag = tags[minFloating] = new MonotypeVar("enumeration");
            } else {
                tag.setKind(null);
            }
            Iterator cs = Engine.listConstraints();
            while (cs.hasNext()) {
                Engine.Constraint c = (Engine.Constraint)cs.next();
                if (!c.hasConstants() || c == PrimitiveType.nullTC.getKind()) continue;
                if (linkDbg) {
                    Debug.println("Choosing kind " + c + " for " + tag);
                }
                if (tag instanceof MonotypeVar) {
                    Engine.forceKind(tag, c.associatedKind);
                } else {
                    Engine.forceKind(tag, c);
                }
                Enumeration.setFloatingKinds(tags, all, minFloating + 1, res, doAll);
                tag.setKind(null);
            }
        } else if (doAll) {
            try {
                Enumeration.setFloatingKinds(tags, all, 0, res, false);
            }
            catch (SolutionFound ex) {}
        } else {
            List solutions = Enumeration.enumerateTags(tags);
            res.addAll(solutions);
            if (solutions.size() > 0) {
                throw new SolutionFound();
            }
        }
    }

    private static boolean isFixedKind(Kind k) {
        return k != null && k != Engine.variablesConstraint && k != TopMonotype.TopKind.instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List enumerateTags(Element[] tags) {
        TagsList tuples;
        block10: {
            List list;
            tuples = new TagsList(tags.length);
            ArrayList<Engine.Constraint> kinds = new ArrayList<Engine.Constraint>(tags.length);
            ArrayList<BitVector> observers = new ArrayList<BitVector>(tags.length);
            Engine.enter();
            try {
                int i = 0;
                while (true) {
                    BitVector obs;
                    if (i >= tags.length) {
                        BitVector[] pObs;
                        Engine.Constraint[] pKinds = kinds.toArray(new Engine.Constraint[kinds.size()]);
                        if (!Enumeration.enumerateInConstraints(pKinds, pObs = observers.toArray(new BitVector[observers.size()]), tuples, tags)) break block10;
                        list = emptyList;
                        Object var13_14 = null;
                        break;
                    }
                    Engine.Constraint k = Engine.getConstraint(tags[i].getKind());
                    int idx = kinds.indexOf(k);
                    if (idx < 0) {
                        kinds.add(k);
                        obs = new BitVector();
                        observers.add(obs);
                    } else {
                        obs = (BitVector)observers.get(idx);
                    }
                    if (!(tags[i].getKind() instanceof FunTypeKind) && !(tags[i].getKind() instanceof TupleKind)) {
                        TypeConstructor constTC = tags[i] instanceof TypeConstructor ? (TypeConstructor)tags[i] : ((Monotype)tags[i]).head();
                        if (constTC == null) {
                            throw new InternalError(tags[i].getKind() + " is not a valid kind in enumerate");
                        }
                        TypeConstructor varTC = new TypeConstructor(constTC.variance);
                        varTC.enumerateTagIndex = i;
                        Typing.introduce(varTC);
                        obs.set(varTC.getId());
                        try {
                            k.leq(varTC, constTC);
                            k.reduceDomainToConcrete(varTC);
                        }
                        catch (Unsatisfiable e) {
                            List list2 = emptyList;
                            Object var13_13 = null;
                            Engine.backtrack();
                            return list2;
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                Engine.backtrack();
                throw throwable;
            }
            Engine.backtrack();
            return list;
        }
        Object var13_15 = null;
        Engine.backtrack();
        return tuples.tags;
    }

    private static boolean enumerateInConstraints(Engine.Constraint[] kinds, BitVector[] observers, final TagsList tuples, final Element[] tags) {
        int act = 0;
        while (act < kinds.length) {
            tuples.startAddition();
            final BitVector obs = observers[act];
            final Engine.Constraint kind = kinds[act];
            kind.enumerate(obs, new LowlevelSolutionHandler(){

                public void handle() {
                    int x = obs.getLowestSetBit();
                    while (x != Integer.MIN_VALUE) {
                        TypeConstructor var = (TypeConstructor)kind.getElement(x);
                        int index = var.enumerateTagIndex;
                        TypeConstructor sol = (TypeConstructor)kind.getElement(this.getSolutionOf(x));
                        if (!Enumeration.checkClassConstraint(tags[index], sol)) {
                            return;
                        }
                        x = obs.getNextBit(x);
                    }
                    tuples.startEntry();
                    int x2 = obs.getLowestSetBit();
                    while (x2 != Integer.MIN_VALUE) {
                        TypeConstructor var = (TypeConstructor)kind.getElement(x2);
                        TypeConstructor sol = (TypeConstructor)kind.getElement(this.getSolutionOf(x2));
                        tuples.set(var.enumerateTagIndex, sol);
                        x2 = obs.getNextBit(x2);
                    }
                }
            });
            if (tuples.endAddition()) {
                return true;
            }
            ++act;
        }
        return false;
    }

    private static boolean checkClassConstraint(Element var, TypeConstructor sol) {
        ClassDefinition def = ClassDefinition.get(sol);
        if (def == null) {
            return true;
        }
        Constraint constraint = def.getResolvedConstraint();
        if (constraint == Constraint.True) {
            return true;
        }
        if (!(var instanceof Monotype)) {
            return true;
        }
        Monotype m = (Monotype)var;
        MonotypeConstructor type = new MonotypeConstructor(sol, def.getTypeParameters());
        try {
            constraint.enter();
            Engine.leq(type, var);
            return true;
        }
        catch (TypingEx ex) {
            return false;
        }
        catch (Unsatisfiable ex) {
            return false;
        }
    }

    private static class TagsList {
        private int size;
        private int width;
        private boolean first;
        final List tags = new ArrayList();

        TagsList(int width) {
            this.width = width;
        }

        void startAddition() {
            this.size = this.tags.size();
            this.first = true;
        }

        boolean endAddition() {
            return this.first;
        }

        void startEntry() {
            if (this.first) {
                this.first = false;
                if (this.tags.size() == 0) {
                    this.tags.add(new TypeConstructor[this.width]);
                    this.size = 1;
                }
            } else {
                int i = 0;
                while (i < this.size) {
                    this.tags.add(((Object[])this.tags.get(i)).clone());
                    ++i;
                }
            }
        }

        void set(int index, TypeConstructor tag) {
            int i = 0;
            while (i < this.size) {
                ((TypeConstructor[])this.tags.get((int)i))[index] = tag;
                ++i;
            }
        }
    }

    private static class SolutionFound
    extends RuntimeException {
        private SolutionFound() {
        }
    }
}

