/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.mapping.OutPort;
import gnu.mapping.Printable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.util.Hashtable;

public class Char
implements Printable,
Externalizable {
    int value;
    static Char[] ascii;
    static Char temp;
    static Hashtable hashTable;
    static char[] charNameValues;
    static String[] charNames;

    public Char() {
    }

    private Char(char ch) {
        this.value = ch;
    }

    private Char(int ch) {
        this.value = ch;
    }

    public final char charValue() {
        return (char)this.value;
    }

    public final int intValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public static Char make(int ch) {
        Object entry;
        if (ch < 128) {
            return ascii[ch];
        }
        Char.temp.value = ch;
        if (hashTable == null) {
            hashTable = new Hashtable();
        }
        if ((entry = hashTable.get(temp)) != null) {
            return (Char)entry;
        }
        Char newChar = new Char(ch);
        hashTable.put(newChar, newChar);
        return newChar;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Char && ((Char)obj).intValue() == this.value;
    }

    public static int nameToChar(String name) {
        char ch;
        int i = charNames.length;
        while (--i >= 0) {
            if (!charNames[i].equals(name)) continue;
            return charNameValues[i];
        }
        int i2 = charNames.length;
        while (--i2 >= 0) {
            if (!charNames[i2].equalsIgnoreCase(name)) continue;
            return charNameValues[i2];
        }
        int len = name.length();
        if (len > 1 && name.charAt(0) == 'u') {
            int value = 0;
            int pos = 1;
            while (true) {
                if (pos == len) {
                    return value;
                }
                int dig = Character.digit(name.charAt(pos), 16);
                if (dig < 0) break;
                value = (value << 4) + dig;
                ++pos;
            }
        }
        if (len == 3 && name.charAt(1) == '-' && ((ch = name.charAt(0)) == 'c' || ch == 'C')) {
            ch = name.charAt(2);
            return ch & 0x1F;
        }
        return -1;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[Char '");
        if (this.value >= 32 && this.value < 127) {
            buf.append((char)this.value);
        } else {
            buf.append('\\');
            buf.append(Integer.toOctalString(this.value));
        }
        buf.append("']");
        return buf.toString();
    }

    public static String toScmReadableString(int ch) {
        StringBuffer sbuf = new StringBuffer(20);
        sbuf.append("#\\");
        int i = 0;
        while (i < charNameValues.length) {
            if ((char)ch == charNameValues[i]) {
                sbuf.append(charNames[i]);
                return sbuf.toString();
            }
            ++i;
        }
        if (ch < 8) {
            sbuf.append('0');
            sbuf.append(ch);
        } else if (ch < 32 || ch > 127) {
            sbuf.append(Integer.toString(ch, 8));
        } else {
            sbuf.append((char)ch);
        }
        return sbuf.toString();
    }

    public void print(PrintWriter ps) {
        boolean readable = ps instanceof OutPort && ((OutPort)ps).printReadable;
        char ch = this.charValue();
        if (readable) {
            ps.print(Char.toScmReadableString(ch));
        } else {
            ps.print(ch);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.value > 55296) {
            if (this.value > 65535) {
                out.writeChar((this.value - 65536 >> 10) + 55296);
                this.value = (this.value & 0x3FF) + 56320;
            } else if (this.value <= 56319) {
                out.writeChar(this.value);
                this.value = 0;
            }
        }
        out.writeChar(this.value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        char next;
        this.value = in.readChar();
        if (this.value >= 55296 && this.value < 56319 && (next = in.readChar()) >= '\udc00' && next <= '\udfff') {
            this.value = (this.value - 55296 << 10) + (next - 56320) + 65536;
        }
    }

    public Object readResolve() throws ObjectStreamException {
        return Char.make(this.value);
    }

    public static boolean $Eq(char c1, char c2) {
        return c1 == c2;
    }

    public static boolean $Ls(char c1, char c2) {
        return c1 < c2;
    }

    public static boolean $Gr(char c1, char c2) {
        return c1 > c2;
    }

    public static boolean $Ls$Eq(char c1, char c2) {
        return c1 <= c2;
    }

    public static boolean $Gr$Eq(char c1, char c2) {
        return c1 >= c2;
    }

    static {
        temp = new Char(0);
        ascii = new Char[128];
        int i = 128;
        while (--i >= 0) {
            Char.ascii[i] = new Char(i);
        }
        charNameValues = new char[]{' ', '\t', '\n', '\n', '\r', '\f', '\b', '\u001b', '\u007f', '\u007f', '\u0007', '\u0000'};
        charNames = new String[]{"space", "tab", "newline", "linefeed", "return", "page", "backspace", "esc", "del", "rubout", "bel", "nul"};
    }
}

