/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.bytecode.Type;
import gnu.mapping.CallContext;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.WrongArguments;
import gnu.mapping.WrongType;

public abstract class MethodProc
extends ProcedureN {
    protected Object argTypes;
    static final Type[] unknownArgTypes = new Type[]{Type.pointer_type};
    public static final int NO_MATCH = -1;
    public static final int NO_MATCH_TOO_FEW_ARGS = -983040;
    public static final int NO_MATCH_TOO_MANY_ARGS = -917504;
    public static final int NO_MATCH_AMBIGUOUS = -851968;
    public static final int NO_MATCH_BAD_TYPE = -786432;

    public int isApplicable(Type[] argTypes) {
        int argCount = argTypes.length;
        int num = this.numArgs();
        if (argCount < (num & 0xFFF) || num >= 0 && argCount > num >> 12) {
            return -1;
        }
        int result = 1;
        int i = argCount;
        while (--i >= 0) {
            Type ptype = this.getParameterType(i);
            int code = ptype.compare(argTypes[i]);
            if (code == -3) {
                return -1;
            }
            if (code >= 0) continue;
            result = 0;
        }
        return result;
    }

    public int numParameters() {
        int num = this.numArgs();
        int max = num >> 12;
        if (max >= 0) {
            return max;
        }
        int min = num & 0xFFF;
        return min + 1;
    }

    protected void resolveParameterTypes() {
        this.argTypes = unknownArgTypes;
    }

    public Type getParameterType(int index) {
        Type[] atypes;
        if (!(this.argTypes instanceof Type[])) {
            this.resolveParameterTypes();
        }
        if (index >= (atypes = (Type[])this.argTypes).length) {
            index = atypes.length - 1;
        }
        return atypes[index];
    }

    public abstract int match(CallContext var1, Object[] var2);

    public Object match(Object[] args) {
        CallContext ctx = new CallContext();
        return this.match(ctx, args) == 0 ? ctx : null;
    }

    public abstract Object applyV(CallContext var1) throws Throwable;

    public static RuntimeException matchFailAsException(int code, Procedure proc, Object[] args) {
        int arg = code;
        if ((code &= 0xFFFF0000) == -983040 || code == -917504) {
            return new WrongArguments(proc, args.length);
        }
        if (code != -786432) {
            arg = -1;
        }
        throw new WrongType(proc, arg, null);
    }

    public Object applyN(Object[] args) throws Throwable {
        Procedure.checkArgCount(this, args.length);
        CallContext vars = new CallContext();
        int err = this.match(vars, args);
        if (err != 0) {
            throw MethodProc.matchFailAsException(err, this, args);
        }
        return this.applyV(vars);
    }

    public static MethodProc mostSpecific(MethodProc proc1, MethodProc proc2) {
        int num2;
        int limit;
        boolean not1 = false;
        boolean not2 = false;
        int min1 = proc1.minArgs();
        int min2 = proc2.minArgs();
        int max1 = proc1.maxArgs();
        int max2 = proc2.maxArgs();
        int num1 = proc1.numParameters();
        int n = limit = num1 > (num2 = proc2.numParameters()) ? num1 : num2;
        if (max1 != max2) {
            if (max1 < 0) {
                not2 = true;
            }
            if (max2 < 0) {
                not1 = true;
            }
        }
        if (min1 < min2) {
            not2 = true;
        } else if (min1 > min2) {
            not1 = true;
        }
        int i = 0;
        while (i < limit) {
            Type t2;
            Type t1 = proc1.getParameterType(i);
            int comp = t1.compare(t2 = proc2.getParameterType(i));
            if (comp == -1) {
                not2 = true;
                if (not1) {
                    return null;
                }
            }
            if (comp == 1) {
                not1 = true;
                if (not2) {
                    return null;
                }
            }
            ++i;
        }
        return not2 ? proc1 : (not1 ? proc2 : null);
    }

    public static int mostSpecific(MethodProc[] procs, int length) {
        MethodProc best = null;
        if (length == 0) {
            return -1;
        }
        int result = 0;
        best = procs[0];
        int i = 1;
        while (i < length) {
            MethodProc method = procs[i];
            if ((best = MethodProc.mostSpecific(best, method)) == null) {
                return -1;
            }
            if (best == method) {
                result = i;
            }
            ++i;
        }
        return result;
    }
}

