/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Initializer;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.Target;

public class ProcInitializer
extends Initializer {
    LambdaExp proc;

    public ProcInitializer(LambdaExp lexp, Compilation comp) {
        this.field = lexp.allocFieldFor(comp);
        this.proc = lexp;
        LambdaExp heapLambda = lexp.getHeapLambda();
        if (heapLambda instanceof ModuleExp && comp.instanceField != null) {
            this.next = comp.clinitChain;
            comp.clinitChain = this;
        } else if (heapLambda instanceof ClassExp) {
            this.next = heapLambda.clinitChain;
            heapLambda.clinitChain = this;
        } else {
            this.next = heapLambda.initChain;
            heapLambda.initChain = this;
        }
    }

    public static void emitLoadModuleMethod(LambdaExp proc, Compilation comp) {
        CodeAttr code = comp.getCode();
        ClassType procClass = Compilation.getMethodProcType(comp.curClass);
        code.emitNew(procClass);
        code.emitDup(1);
        if (comp.method.getStaticFlag()) {
            code.emitGetStatic(comp.topLambda.getInstanceField());
        } else {
            code.emitPushThis();
        }
        code.emitPushInt(proc.getSelectorValue(comp));
        String name = proc.getName();
        if (name == null) {
            code.emitPushNull();
        } else {
            code.emitPushString(name);
        }
        code.emitPushInt(proc.min_args | proc.max_args << 12);
        Method initModuleMethod = procClass.getDeclaredMethod("<init>", 4);
        code.emitInvokeSpecial(initModuleMethod);
    }

    public void emit(Compilation comp) {
        CodeAttr code = comp.getCode();
        if (!this.field.getStaticFlag()) {
            code.emitPushThis();
        }
        ProcInitializer.emitLoadModuleMethod(this.proc, comp);
        if (this.proc.properties != null) {
            int len = this.proc.properties.length;
            int i = 0;
            while (i < len) {
                Object key = this.proc.properties[i];
                if (key != null) {
                    Object val = this.proc.properties[i + 1];
                    code.emitDup(1);
                    comp.compileConstant(key);
                    Target target = Target.pushObject;
                    if (val instanceof Expression) {
                        ((Expression)val).compile(comp, target);
                    } else {
                        comp.compileConstant(val, target);
                    }
                    Method m = Compilation.typeProcedure.getDeclaredMethod("setProperty", 2);
                    code.emitInvokeVirtual(m);
                }
                i += 2;
            }
        }
        if (this.field.getStaticFlag()) {
            code.emitPutStatic(this.field);
        } else {
            code.emitPutField(this.field);
        }
    }
}

