/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ClassType;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.Literal;
import gnu.expr.ModuleBody;
import gnu.expr.QuoteExp;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ModuleExp
extends LambdaExp {
    public boolean mustCompile;
    public static boolean debugPrintExpr = false;
    public static final int EXPORT_SPECIFIED = 2048;
    public static final int STATIC_SPECIFIED = 4096;
    public static final int NONSTATIC_SPECIFIED = 8192;
    public static final int SUPERTYPE_SPECIFIED = 16384;
    public static String dumpZipPrefix;
    public static int dumpZipCounter;
    ClassType superType;
    ClassType[] interfaces;

    public String getJavaName() {
        return this.name == null ? "lambda" : Compilation.mangleName(this.name);
    }

    public Object eval(Environment env) throws Throwable {
        try {
            Class clas = this.evalToClass();
            Object inst = clas.newInstance();
            Procedure proc = (Procedure)inst;
            if (proc.getName() == null) {
                proc.setName(this.name);
            }
            return inst;
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("class not instantiable: in lambda eval");
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("class illegal access: in lambda eval");
        }
    }

    public Class evalToClass() {
        try {
            String class_name = this.getJavaName();
            Compilation comp = new Compilation(this, class_name, null, true);
            byte[][] classes = new byte[comp.numClasses][];
            String[] classNames = new String[comp.numClasses];
            int iClass = 0;
            while (iClass < comp.numClasses) {
                ClassType clas = comp.classes[iClass];
                classNames[iClass] = clas.getName();
                classes[iClass] = clas.writeToArray();
                ++iClass;
            }
            if (dumpZipPrefix != null) {
                StringBuffer zipname = new StringBuffer(dumpZipPrefix);
                if (dumpZipCounter >= 0) {
                    zipname.append(++dumpZipCounter);
                }
                zipname.append(".zip");
                FileOutputStream zfout = new FileOutputStream(zipname.toString());
                ZipOutputStream zout = new ZipOutputStream(zfout);
                int iClass2 = 0;
                while (iClass2 < comp.numClasses) {
                    String clname = classNames[iClass2].replace('.', '/') + ".class";
                    ZipEntry zent = new ZipEntry(clname);
                    zent.setSize(classes[iClass2].length);
                    CRC32 crc = new CRC32();
                    crc.update(classes[iClass2]);
                    zent.setCrc(crc.getValue());
                    zent.setMethod(0);
                    zout.putNextEntry(zent);
                    zout.write(classes[iClass2]);
                    ++iClass2;
                }
                zout.close();
            }
            ArrayClassLoader loader = new ArrayClassLoader(classNames, classes);
            Class clas = loader.loadClass(class_name, true);
            Literal init = comp.literalsChain;
            while (init != null) {
                try {
                    clas.getDeclaredField(init.field.getName()).set(null, init.value);
                }
                catch (NoSuchFieldException ex) {
                    throw new Error("internal error - " + ex);
                }
                init = init.next;
            }
            return clas;
        }
        catch (IOException ex) {
            ex.printStackTrace(OutPort.errDefault());
            throw new RuntimeException("I/O error in lambda eval: " + ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("class not found in lambda eval");
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("class illegal access: in lambda eval");
        }
    }

    public final Object evalModule(Environment env) throws Throwable {
        CallContext ctx = new CallContext();
        ctx.values = Values.noArgs;
        this.evalModule(env, ctx);
        return Values.make(ctx.vstack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void evalModule(Environment env, CallContext ctx) throws Throwable {
        Environment orig_env = Environment.getCurrent();
        try {
            if (env != orig_env) {
                Environment.setCurrent(env);
            }
            if (debugPrintExpr) {
                OutPort dout = OutPort.outDefault();
                dout.println("[Evaluating module \"" + this.getName() + "\" mustCompile=" + this.mustCompile + ':');
                this.print(dout);
                dout.println(']');
                dout.flush();
            }
            if (!this.mustCompile) {
                this.body.eval(env, ctx);
            } else {
                ModuleBody mod = (ModuleBody)this.eval(env);
                ctx.proc = mod;
            }
            ctx.runUntilDone();
            Object var6_5 = null;
            if (env == orig_env) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (env == orig_env) throw throwable;
            Environment.setCurrent(orig_env);
            throw throwable;
        }
        Environment.setCurrent(orig_env);
    }

    public final ClassType getSuperType() {
        return this.superType;
    }

    public final void setSuperType(ClassType s) {
        this.superType = s;
    }

    public final ClassType[] getInterfaces() {
        return this.interfaces;
    }

    public final void setInterfaces(ClassType[] s) {
        this.interfaces = s;
    }

    public final boolean isStatic() {
        return this.getFlag(4096) || Compilation.moduleStatic > 0 && !this.getFlag(16384) && !this.getFlag(8192);
    }

    void allocFields(Compilation comp) {
        Declaration decl = this.firstDecl();
        while (decl != null) {
            if ((!decl.isSimple() || decl.isPublic()) && decl.field == null) {
                Expression value = decl.getValue();
                if (value instanceof LambdaExp && !(value instanceof ClassExp)) {
                    ((LambdaExp)value).allocFieldFor(comp);
                } else {
                    if (!(value instanceof QuoteExp) || !decl.getFlag(16384) || comp.immediate) {
                        value = null;
                    }
                    decl.makeField(comp, value);
                }
            }
            decl = decl.nextDecl();
        }
    }

    public void compileToFiles(String topname, String directory, String prefix) throws IOException {
        if (directory == null || directory.length() == 0) {
            directory = "";
        } else if (directory.charAt(directory.length() - 1) != File.separatorChar) {
            directory = directory + File.separatorChar;
        }
        String name = this.getName();
        if (name != null) {
            int index;
            topname = name;
            if (prefix == null && (index = name.lastIndexOf(46)) >= 0) {
                prefix = name.substring(0, index + 1);
            }
        }
        if (debugPrintExpr) {
            OutPort dout = OutPort.outDefault();
            dout.println("[Compiling module-name:" + this.getName() + " top:" + topname + " prefix=" + prefix + " :");
            this.print(dout);
            dout.println(']');
            dout.flush();
        }
        Compilation comp = new Compilation(this, topname, prefix, false);
        int iClass = 0;
        while (iClass < comp.numClasses) {
            ClassType clas = comp.classes[iClass];
            String out_name = directory + clas.getName().replace('.', File.separatorChar) + ".class";
            String parent = new File(out_name).getParent();
            if (parent != null) {
                new File(parent).mkdirs();
            }
            clas.writeToFile(out_name);
            ++iClass;
        }
    }

    public void compileToArchive(String fname) throws IOException {
        boolean makeJar = false;
        if (fname.endsWith(".zip")) {
            makeJar = false;
        } else if (fname.endsWith(".jar")) {
            makeJar = true;
        } else {
            fname = fname + ".zip";
            makeJar = false;
        }
        Compilation comp = new Compilation(this, LambdaExp.fileFunctionName, null, false);
        File zar_file = new File(fname);
        if (zar_file.exists()) {
            zar_file.delete();
        }
        ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(zar_file));
        zout.setMethod(0);
        byte[][] classes = new byte[comp.numClasses][];
        CRC32 zcrc = new CRC32();
        int iClass = 0;
        while (iClass < comp.numClasses) {
            ClassType clas = comp.classes[iClass];
            classes[iClass] = clas.writeToArray();
            ZipEntry zent = new ZipEntry(clas.getName().replace('.', '/') + ".class");
            zent.setSize(classes[iClass].length);
            zcrc.reset();
            zcrc.update(classes[iClass], 0, classes[iClass].length);
            zent.setCrc(zcrc.getValue());
            zout.putNextEntry(zent);
            zout.write(classes[iClass]);
            ++iClass;
        }
        zout.close();
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkModuleExp(this);
    }

    public void print(OutPort out) {
        out.startLogicalBlock("(Module/", ")", 2);
        if (this.name != null) {
            out.print(this.name);
            out.print('/');
        }
        out.print(this.id);
        out.print('/');
        out.writeSpaceFill();
        out.startLogicalBlock("(", false, ")");
        Declaration decl = this.firstDecl();
        while (decl != null) {
            out.print(decl);
            out.writeSpaceFill();
            decl = decl.nextDecl();
        }
        out.endLogicalBlock(")");
        out.writeSpaceLinear();
        if (this.body == null) {
            out.print("<null body>");
        } else {
            this.body.print(out);
        }
        out.endLogicalBlock(")");
    }
}

