/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ObjectExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.SynchronizedExp;
import gnu.expr.TryExp;

public class FindTailCalls
extends ExpWalker {
    boolean inTailContext = true;

    public static void findTailCalls(Expression exp) {
        FindTailCalls walker = new FindTailCalls();
        exp.walk(walker);
    }

    protected Expression walkApplyExp(ApplyExp exp) {
        if (this.inTailContext) {
            exp.setTailCall(true);
        }
        exp.context = this.currentLambda;
        boolean save = this.inTailContext;
        LambdaExp lexp = null;
        try {
            this.inTailContext = false;
            if (exp.func instanceof ReferenceExp) {
                ReferenceExp func = (ReferenceExp)exp.func;
                Declaration binding = Declaration.followAliases(func.binding);
                if (binding != null) {
                    exp.nextCall = binding.firstCall;
                    binding.firstCall = exp;
                    binding.setCanCall();
                    Expression value = binding.getValue();
                    if (value instanceof LambdaExp) {
                        lexp = (LambdaExp)value;
                    }
                }
            } else if (exp.func instanceof LambdaExp) {
                lexp = (LambdaExp)exp.func;
                this.walkLambdaExp(lexp, false);
                lexp.setCanCall(true);
            } else {
                exp.func = exp.func.walk(this);
            }
            if (!(lexp == null || lexp.returnContinuation == exp || lexp == this.currentLambda && save)) {
                lexp.returnContinuation = lexp.returnContinuation == null ? exp : LambdaExp.unknownContinuation;
            }
            exp.args = this.walkExps(exp.args);
            ApplyExp applyExp = exp;
            Object var8_7 = null;
            this.inTailContext = save;
            return applyExp;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.inTailContext = save;
            throw throwable;
        }
    }

    protected Expression walkBeginExp(BeginExp exp) {
        boolean save = this.inTailContext;
        try {
            int n = exp.length - 1;
            int i = 0;
            while (i <= n) {
                this.inTailContext = i == n && save;
                exp.exps[i] = exp.exps[i].walk(this);
                ++i;
            }
            BeginExp beginExp = exp;
            Object var7_6 = null;
            this.inTailContext = save;
            return beginExp;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.inTailContext = save;
            throw throwable;
        }
    }

    protected Expression walkFluidLetExp(FluidLetExp exp) {
        Declaration decl = exp.firstDecl();
        while (decl != null) {
            decl.setCanRead(true);
            decl.setCanWrite(true);
            decl = decl.nextDecl();
        }
        return super.walkFluidLetExp(exp);
    }

    protected Expression walkLetExp(LetExp exp) {
        int n = exp.inits.length;
        boolean save = this.inTailContext;
        try {
            this.inTailContext = false;
            Declaration decl = exp.firstDecl();
            int i = 0;
            while (i < n) {
                exp.inits[i] = this.walkSetExp(decl, exp.inits[i]);
                ++i;
                decl = decl.nextDecl();
            }
            Object var7_6 = null;
            this.inTailContext = save;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.inTailContext = save;
            throw throwable;
        }
        exp.body = exp.body.walk(this);
        this.walkDecls(exp);
        return exp;
    }

    public void walkDecls(ScopeExp exp) {
        Declaration decl = exp.firstDecl();
        while (decl != null) {
            Expression value = decl.getValue();
            if (value != null && value instanceof LambdaExp) {
                LambdaExp lexp = (LambdaExp)value;
                if (decl.getCanRead()) {
                    lexp.setCanRead(true);
                }
                if (decl.getCanCall()) {
                    lexp.setCanCall(true);
                }
            }
            decl = decl.nextDecl();
        }
    }

    protected Expression walkIfExp(IfExp exp) {
        boolean save = this.inTailContext;
        try {
            this.inTailContext = false;
            exp.test = exp.test.walk(this);
            Object var4_3 = null;
            this.inTailContext = save;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.inTailContext = save;
            throw throwable;
        }
        exp.then_clause = exp.then_clause.walk(this);
        Expression else_clause = exp.else_clause;
        if (else_clause != null) {
            exp.else_clause = else_clause.walk(this);
        }
        return exp;
    }

    protected Expression walkLambdaExp(LambdaExp exp) {
        this.walkLambdaExp(exp, true);
        return exp;
    }

    final void walkLambdaExp(LambdaExp exp, boolean canRead) {
        boolean save = this.inTailContext;
        LambdaExp parent = this.currentLambda;
        this.currentLambda = exp;
        if (canRead) {
            exp.setCanRead(true);
        }
        try {
            this.inTailContext = false;
            if (exp.defaultArgs != null) {
                exp.defaultArgs = this.walkExps(exp.defaultArgs);
            }
            boolean bl = this.inTailContext = exp.getInlineOnly() ? save : true;
            if (this.exitValue == null && exp.body != null) {
                exp.body = exp.body.walk(this);
            }
            Object var6_5 = null;
            this.inTailContext = save;
            this.currentLambda = parent;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.inTailContext = save;
            this.currentLambda = parent;
            throw throwable;
        }
        this.walkDecls(exp);
        LambdaExp child = exp.firstChild;
        while (child != null) {
            if (child.getCanRead() || child.min_args != child.max_args) {
                child.flags |= 0x20;
            } else {
                ApplyExp caller = child.returnContinuation;
                if (caller != LambdaExp.unknownContinuation && !Compilation.usingCPStyle()) {
                    child.setInlineOnly(true);
                }
            }
            child = child.nextSibling;
        }
        LambdaExp child2 = exp.firstChild;
        while (child2 != null) {
            if ((child2.flags & 0x21) != 0) {
                // empty if block
            }
            child2 = child2.nextSibling;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Expression walkClassExp(ClassExp exp) {
        boolean save = this.inTailContext;
        LambdaExp parent = this.currentLambda;
        this.currentLambda = exp;
        exp.setCanRead(true);
        try {
            this.inTailContext = false;
            LambdaExp child = exp.firstChild;
            while (true) {
                block6: {
                    block5: {
                        if (child == null) break block5;
                        if (this.exitValue == null) break block6;
                    }
                    Object var6_5 = null;
                    this.inTailContext = save;
                    this.currentLambda = parent;
                    return exp;
                }
                this.walkLambdaExp(child, false);
                child = child.nextSibling;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.inTailContext = save;
            this.currentLambda = parent;
            throw throwable;
        }
    }

    protected Expression walkReferenceExp(ReferenceExp exp) {
        Declaration decl = Declaration.followAliases(exp.binding);
        if (decl != null) {
            decl.setCanRead(true);
        }
        return exp;
    }

    final Expression walkSetExp(Declaration decl, Expression value) {
        if (decl != null) {
            decl.setCanWrite();
        }
        if (decl != null && decl.getValue() == value && value instanceof LambdaExp && !(value instanceof ObjectExp) && !decl.isPublic()) {
            LambdaExp lexp = (LambdaExp)value;
            this.walkLambdaExp(lexp, false);
            return lexp;
        }
        return value.walk(this);
    }

    protected Expression walkSetExp(SetExp exp) {
        SetExp setExp;
        boolean save = this.inTailContext;
        try {
            this.inTailContext = false;
            Declaration decl = exp.binding;
            if (decl != null && decl.isAlias()) {
                if (exp.isDefining()) {
                    SetExp setExp2 = exp;
                    Object var7_6 = null;
                    this.inTailContext = save;
                    return setExp2;
                }
                decl = Declaration.followAliases(decl);
            }
            exp.new_value = this.walkSetExp(decl, exp.new_value);
            setExp = exp;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.inTailContext = save;
            throw throwable;
        }
        Object var7_7 = null;
        this.inTailContext = save;
        return setExp;
    }

    protected Expression walkTryExp(TryExp exp) {
        boolean save = this.inTailContext;
        try {
            this.inTailContext = false;
            Expression expression = super.walkTryExp(exp);
            Object var5_4 = null;
            this.inTailContext = save;
            return expression;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.inTailContext = save;
            throw throwable;
        }
    }

    protected Expression walkSynchronizedExp(SynchronizedExp exp) {
        boolean save = this.inTailContext;
        try {
            this.inTailContext = false;
            Expression expression = super.walkSynchronizedExp(exp);
            Object var5_4 = null;
            this.inTailContext = save;
            return expression;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.inTailContext = save;
            throw throwable;
        }
    }
}

