/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Arguments;
import bossa.syntax.Definition;
import bossa.syntax.Expression;
import bossa.syntax.FieldAccess;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.Node;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import gnu.expr.Declaration;
import gnu.expr.ReferenceExp;
import gnu.expr.ThisExp;
import mlsub.typing.Polytype;

public abstract class VarSymbol
extends Node
implements Located {
    LocatedString name;
    private Declaration decl = null;
    private boolean isThis;

    public VarSymbol(LocatedString name) {
        super(3);
        this.name = name;
        this.addSymbol(this);
    }

    public boolean hasName(LocatedString i) {
        return this.name.equals(i);
    }

    boolean isAssignable() {
        return true;
    }

    final boolean isFieldAccess() {
        return this.getFieldAccessMethod() != null;
    }

    final boolean isNonStaticFieldAccess() {
        FieldAccess access = this.getFieldAccessMethod();
        return access != null && !access.isStatic();
    }

    final boolean isStaticFieldAccess() {
        FieldAccess access = this.getFieldAccessMethod();
        return access != null && access.isStatic();
    }

    FieldAccess getFieldAccessMethod() {
        return null;
    }

    public MethodDeclaration getMethodDeclaration() {
        return null;
    }

    boolean isIgnored() {
        return false;
    }

    void checkSpecialRequirements(Expression[] arguments) {
    }

    public Definition getDefinition() {
        return null;
    }

    abstract Polytype getType();

    int match(Arguments arguments) {
        return 1;
    }

    String explainWhyMatchFails(Arguments arguments) {
        return "Incorrect call to " + this.name;
    }

    abstract void makeClonedType(Polytype[] var1, int[] var2);

    abstract void releaseClonedType();

    abstract Polytype getClonedType();

    public Location location() {
        return this.name.location();
    }

    public final LocatedString getName() {
        return this.name;
    }

    gnu.expr.Expression compile() {
        Declaration decl = this.getDeclaration();
        if (decl == null) {
            Internal.error(this + " has no bytecode declaration");
        }
        if (this.isThis) {
            return new ThisExp(decl);
        }
        return new ReferenceExp(this.name == null ? null : this.name.toString(), decl);
    }

    gnu.expr.Expression compileInCallPosition() {
        return this.compile();
    }

    static gnu.expr.Expression[] compile(VarSymbol[] syms) {
        gnu.expr.Expression[] res = new gnu.expr.Expression[syms.length];
        int i = 0;
        while (i < syms.length) {
            res[i] = syms[i].compile();
            ++i;
        }
        return res;
    }

    public void setDeclaration(Declaration declaration) {
        this.setDeclaration(declaration, false);
    }

    public void setDeclaration(Declaration declaration, boolean isThis) {
        this.decl = declaration;
        this.isThis = isThis;
        if (this.name != null) {
            this.name.location.write(this.decl);
        }
        this.decl.setCanRead(true);
        this.decl.setCanWrite(true);
    }

    Declaration getDeclaration() {
        return this.decl;
    }
}

