/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Expression;
import bossa.syntax.PrimitiveType;
import bossa.syntax.Statement;
import mlsub.typing.Polytype;
import nice.tools.code.Gen;

public class ReturnStmt
extends Statement {
    Expression value;
    boolean fake;

    public ReturnStmt(Expression value) {
        this(value, false);
    }

    public ReturnStmt(Expression value, boolean fake) {
        this.value = value;
        if (value != null) {
            this.setLocation(value.location());
        }
        this.fake = fake;
    }

    Polytype returnType() {
        if (this.value == null) {
            return PrimitiveType.voidPolytype;
        }
        return this.value.getType();
    }

    public gnu.expr.Expression generateCode() {
        if (this.value == null) {
            return Gen.returnVoid();
        }
        return Gen.returnValue(this.value.generateCode());
    }

    public String toString() {
        return "return" + (this.value != null ? " " + this.value : "") + ";";
    }
}

