/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.link.Alternative;
import bossa.link.SourceAlternative;
import bossa.modules.CompilationInterface;
import bossa.syntax.FormalParameters;
import bossa.syntax.JavaMethod;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.MethodImplementation;
import bossa.syntax.MonoSymbol;
import bossa.syntax.NiceClass;
import bossa.syntax.NiceMethod;
import bossa.syntax.Node;
import bossa.syntax.OverloadedSymbolExp;
import bossa.syntax.Pattern;
import bossa.syntax.PrimitiveType;
import bossa.syntax.Statement;
import bossa.syntax.SymbolExp;
import bossa.syntax.TypeConstructors;
import bossa.syntax.TypeIdent;
import bossa.syntax.TypeScope;
import bossa.syntax.VarSymbol;
import bossa.syntax.dispatch;
import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import bossa.util.UserError;
import bossa.util.Util;
import gnu.bytecode.Type;
import gnu.expr.Expression;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mlsub.typing.BadSizeEx;
import mlsub.typing.Constraint;
import mlsub.typing.Monotype;
import mlsub.typing.Polytype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.SpecialArray;
import nice.tools.code.Types;

public class MethodBodyDefinition
extends MethodImplementation {
    private List symbols;
    private Alternative alternative;
    Collection binders;

    public MethodBodyDefinition(NiceClass container, LocatedString name, Collection binders, List formals, Statement body) {
        super(name, body, MethodBodyDefinition.makeFormals(formals, container, name.location()));
        this.binders = binders;
        this.declaration = null;
    }

    boolean hasThis() {
        return this.formals != null && this.formals.length >= 1 && String.valueOf(this.formals[0].name).equals("this");
    }

    private static Pattern[] makeFormals(List formals, NiceClass container, Location loc) {
        if (container == null) {
            return formals.toArray(new Pattern[formals.size()]);
        }
        Pattern[] res = new Pattern[formals.size() + 1];
        res[0] = new Pattern(new LocatedString("this", loc), new TypeIdent(container.definition.getName()));
        int n = 1;
        Iterator f = formals.iterator();
        while (f.hasNext()) {
            res[n] = (Pattern)f.next();
            ++n;
        }
        return res;
    }

    final TypeConstructor firstArgument() {
        if (this.formals[0].tc != null) {
            return this.formals[0].tc;
        }
        return Types.equivalent(this.declaration.getArgTypes()[0]).head();
    }

    private void setDeclaration(MethodDeclaration d) {
        if (d == null) {
            User.error((Located)this, "Method " + this.name + " is not declared");
        }
        this.declaration = d;
        if (d instanceof JavaMethod) {
            ((JavaMethod)d).registerForDispatch();
            if (TypeConstructors.isInterface(this.formals[0].tc)) {
                User.error((Located)this, this.name + " is a native method. Dispatch can only occur if the first argument is not a interface.");
            }
        } else if (!(d instanceof NiceMethod)) {
            User.error((Located)this, "Implementations can only be made for methods, but " + d.getName() + " is a function.\nIt was defined at:\n" + d.location());
        }
        this.alternative = new SourceAlternative(this);
        this.buildSymbols();
    }

    private VarSymbol findSymbol(List symbols) {
        MethodDeclaration m;
        if (symbols.size() == 0) {
            return null;
        }
        TypeConstructor[] tags = Pattern.getTC(this.formals);
        TypeConstructor[] additionalTags = Pattern.getAdditionalTC(this.formals);
        boolean hasAdditionalTags = false;
        int i = 0;
        while (i < tags.length) {
            if (additionalTags[i] != null) {
                hasAdditionalTags = true;
            }
            ++i;
        }
        Iterator i2 = symbols.iterator();
        while (i2.hasNext()) {
            VarSymbol s = (VarSymbol)i2.next();
            if (s.getMethodDeclaration() == null) {
                i2.remove();
                continue;
            }
            m = s.getMethodDeclaration();
            if (m.isIgnored()) {
                i2.remove();
                continue;
            }
            if (m.getArity() != this.formals.length || !(m instanceof NiceMethod) && !(m instanceof JavaMethod)) {
                i2.remove();
                continue;
            }
            try {
                Object var12_20;
                int level = Debug.overloading ? Typing.enter("Trying declaration " + m + " for method body " + this.name) : Typing.enter();
                try {
                    Polytype t = m.getType();
                    Constraint.enter(t.getConstraint());
                    Pattern.inDomain(this.formals, t.domain());
                    var12_20 = null;
                }
                catch (Throwable throwable) {
                    var12_20 = null;
                    if (Typing.leave() != level) {
                        Internal.error("Enter/Leave error");
                    }
                    throw throwable;
                }
                if (Typing.leave() == level) continue;
                Internal.error("Enter/Leave error");
                {
                }
            }
            catch (TypingEx e) {
                if (Debug.overloading) {
                    Debug.println("Not the right choice :" + e);
                }
                i2.remove();
            }
            catch (BadSizeEx e) {
                i2.remove();
            }
        }
        if (symbols.size() > 1 && hasAdditionalTags) {
            MethodDeclaration.Symbol[] tempSymbols = new MethodDeclaration.Symbol[symbols.size()];
            symbols.toArray(tempSymbols);
            int size = symbols.size();
            symbols = new LinkedList<MethodDeclaration.Symbol>();
            int len = this.formals.length;
            boolean[] removed = new boolean[size];
            int m1 = 0;
            while (m1 < size) {
                Monotype[] dom1 = tempSymbols[m1].getMethodDeclaration().getType().domain();
                int m2 = 0;
                while (m2 < size) {
                    if (m1 != m2) {
                        boolean remove = true;
                        boolean additionalsEqual = true;
                        Monotype[] dom2 = tempSymbols[m2].getMethodDeclaration().getType().domain();
                        int i3 = 0;
                        while (i3 < len) {
                            if (additionalTags[i3] != null) {
                                try {
                                    this.domainMonotypeLeq(dom2[i3], dom1[i3]);
                                    try {
                                        this.domainMonotypeLeq(dom1[i3], dom2[i3]);
                                    }
                                    catch (TypingEx e) {
                                        additionalsEqual = false;
                                    }
                                }
                                catch (TypingEx e) {
                                    remove = false;
                                    break;
                                }
                            }
                            ++i3;
                        }
                        boolean bl = removed[m1] = remove && !additionalsEqual;
                        if (removed[m1]) break;
                    }
                    ++m2;
                }
                if (!removed[m1]) {
                    symbols.add(tempSymbols[m1]);
                }
                ++m1;
            }
        }
        Iterator it = symbols.iterator();
        block14: while (it.hasNext()) {
            m = ((MethodDeclaration.Symbol)it.next()).getMethodDeclaration();
            if (!(m instanceof NiceMethod)) continue;
            FormalParameters params = m.formalParameters();
            int i4 = params.hasThis() ? 1 : 0;
            while (i4 < this.formals.length) {
                if (this.formals[i4].atAny() && this.formals[i4].name != null && params.getName(i4) != null && !this.formals[i4].name.toString().equals(params.getName(i4).toString())) {
                    it.remove();
                    continue block14;
                }
                ++i4;
            }
        }
        OverloadedSymbolExp.removeNonMinimal(symbols);
        if (symbols.size() == 1) {
            return (VarSymbol)symbols.get(0);
        }
        if (symbols.size() == 0) {
            User.error((Located)this, "No method called " + this.name + " is compatible with these patterns");
        }
        String methods = "";
        Iterator i5 = symbols.iterator();
        while (i5.hasNext()) {
            MethodDeclaration m2 = ((MethodDeclaration.Symbol)i5.next()).getMethodDeclaration();
            methods = methods + m2 + " defined " + m2.location() + "\n";
        }
        throw User.error((Located)this, "There is an ambiguity about which version  of the overloaded method \"" + this.name + "\" this alternative belongs to.\n" + "Try to use more patterns.\n\n" + "Possible methods:\n" + methods);
    }

    private void domainMonotypeLeq(Monotype m1, Monotype m2) throws TypingEx {
        if (m1 == m2) {
            return;
        }
        Types.setMarkedKind(m1);
        Types.setMarkedKind(m2);
        Typing.leq(Types.rawType(m1), Types.rawType(m2));
    }

    void doResolve() {
        Pattern.resolve(this.typeScope, Node.getGlobalScope(), this.formals);
        this.symbols = this.scope.lookup(this.name);
    }

    void lateBuildScope() {
        Pattern.resolveValues(this.formals);
        VarSymbol s = this.findSymbol(this.symbols);
        this.symbols = null;
        if (s == null) {
            User.error((Located)this, this.name + " is not declared");
        }
        if (s.getMethodDeclaration() == null) {
            User.error((Located)this, this.name + " is not a method");
        }
        MethodDeclaration decl = s.getMethodDeclaration();
        this.setDeclaration(decl);
        if (this.binders != null) {
            Constraint cst = this.declaration.getType().getConstraint();
            if (!Constraint.hasBinders(cst)) {
                User.error((Located)this.name, "Method " + this.name + " has no type parameters");
            }
            try {
                this.typeScope.addMappingsLS(this.binders, cst.binders());
            }
            catch (BadSizeEx e) {
                User.error((Located)this.name, "Method " + this.name + " expects " + e.expected + " type parameters");
            }
            catch (TypeScope.DuplicateName e) {
                User.error((Located)this, e);
            }
        }
        try {
            int n = 0;
            while (n < this.formals.length) {
                TypeConstructor tc = this.formals[n].getRuntimeTC();
                if (tc != null) {
                    this.typeScope.addSymbol(tc);
                }
                ++n;
            }
        }
        catch (TypeScope.DuplicateName e) {
            User.error((Located)this, e);
        }
        this.removeUnnecessaryDispatch();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeUnnecessaryDispatch() {
        boolean entered = false;
        if (Constraint.hasBinders(this.declaration.getType().getConstraint())) {
            Typing.enter();
            entered = true;
        }
        try {
            try {
                Constraint.enter(this.declaration.getType().getConstraint());
                Typing.implies();
                Monotype[] domain = this.declaration.getType().domain();
                int n = 0;
                while (n < this.formals.length) {
                    TypeConstructor tc = Types.rawType(domain[n]).head();
                    if (this.formals[n].tc != null) {
                        this.formals[n].setDomainEq(tc != null && Types.isSure(domain[n]) && Typing.testLeq(tc, this.formals[n].tc));
                    }
                    ++n;
                }
                Object var6_6 = null;
                if (!entered) return;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (!entered) throw throwable;
                Typing.leave();
                throw throwable;
            }
            Typing.leave();
            return;
        }
        catch (TypingEx ex) {
            Internal.warning(ex.toString());
        }
    }

    void typecheck() {
        boolean errorFound = false;
        int level = Debug.typing ? Typing.enter("METHOD BODY " + this + "\n\n") : Typing.enter();
        try {
            try {
                try {
                    Constraint.enter(this.declaration.getType().getConstraint());
                }
                catch (TypingEx e) {
                    throw User.error((Located)this.name, "the constraint will never be satisfied", ": " + e.getMessage());
                }
                Monotype[] monotypes = MonoSymbol.getMonotype(this.parameters);
                int n = 0;
                while (n < this.formals.length) {
                    TypeConstructor runtimeTC = this.formals[n].getRuntimeTC();
                    if (runtimeTC == null) {
                        Typing.introduce(monotypes[n]);
                    } else {
                        Typing.introduce(runtimeTC);
                    }
                    ++n;
                }
                Monotype[] domain = this.declaration.getType().domain();
                int n2 = 0;
                while (n2 < this.formals.length) {
                    TypeConstructor tc = Types.rawType(domain[n2]).head();
                    if (this.formals[n2].tc != null) {
                        this.formals[n2].setDomainTC(tc);
                    }
                    ++n2;
                }
                try {
                    Pattern.in(monotypes, this.formals);
                }
                catch (TypingEx e) {
                    throw User.error((Located)this.name, "The patterns are not correct", e);
                }
                int i = 0;
                while (i < monotypes.length) {
                    try {
                        Typing.leq(monotypes[i], domain[i]);
                    }
                    catch (TypingEx e) {
                        throw User.error((Located)this.formals[i], "Pattern " + this.formals[i] + " is incompatible with type " + domain[i]);
                    }
                    ++i;
                }
                try {
                    Types.setBytecodeType(monotypes);
                    Typing.implies();
                }
                catch (TypingEx e) {
                    throw User.error((Located)this.name, "Type error in method body \"" + this.name + "\":\n" + e);
                }
                Node.currentFunction = this;
                if (this.hasThis()) {
                    Node.thisExp = new SymbolExp(this.parameters[0], this.location());
                }
                dispatch.typecheck(this.body);
            }
            catch (UserError ex) {
                ((CompilationInterface)this.module.compilation()).error(ex);
                errorFound = true;
            }
            Object var10_14 = null;
            Node.currentFunction = null;
            Node.thisExp = null;
        }
        catch (Throwable throwable) {
            block26: {
                Object var10_15 = null;
                Node.currentFunction = null;
                Node.thisExp = null;
                try {
                    if (Typing.leave() != level) {
                        Internal.error("Unmatching enter/leave");
                    }
                }
                catch (TypingEx e) {
                    if (errorFound) break block26;
                    User.error((Located)this, "Type error in method " + this.name, ": " + e);
                }
            }
            throw throwable;
        }
        try {
            if (Typing.leave() != level) {
                Internal.error("Unmatching enter/leave");
            }
        }
        catch (TypingEx e) {
            if (!errorFound) {
                User.error((Located)this, "Type error in method " + this.name, ": " + e);
            }
        }
    }

    public void printInterface(PrintWriter s) {
    }

    protected Type[] javaArgTypes() {
        Type[] res = new Type[this.parameters.length];
        int n = 0;
        while (n < this.parameters.length) {
            res[n] = this.formals[n].atNull() ? Types.javaType(PrimitiveType.nullTC) : (this.formals[n].tc == PrimitiveType.arrayTC ? SpecialArray.unknownTypeArray() : Types.javaType(this.parameters[n].getMonotype()));
            ++n;
        }
        return res;
    }

    Expression[] compiledArguments() {
        return VarSymbol.compile(this.parameters);
    }

    Alternative getAlternative() {
        return this.alternative;
    }

    public String toString() {
        return this.name + "(" + Util.map("", ", ", "", this.formals) + ")";
    }
}

