/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.JavaClasses;
import bossa.syntax.LocatedString;
import bossa.syntax.Module;
import bossa.syntax.TypeScope;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import java.util.HashSet;
import java.util.Set;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;

public class GlobalTypeScope
extends TypeScope {
    public Module module;
    private Set set = new HashSet();

    GlobalTypeScope() {
        super(null);
        try {
            this.addMapping("java.lang.Object", TopMonotype.instance);
        }
        catch (TypeScope.DuplicateName duplicateName) {
            // empty catch block
        }
    }

    void addMapping(String name, TypeSymbol s) throws TypeScope.DuplicateName {
        super.addMapping(name, s);
        if (!this.set.add(name.toLowerCase())) {
            throw new TypeScope.DuplicateName(name);
        }
    }

    public TypeConstructor globalLookup(LocatedString name) {
        return this.globalLookup(name.toString(), name.location());
    }

    public TypeConstructor globalLookup(String name, Location loc) {
        TypeSymbol res = this.lookup(name, loc);
        if (res instanceof TypeConstructor) {
            return (TypeConstructor)res;
        }
        if (res != null) {
            Internal.warning("Non type-constructor found in global type scope");
        }
        return null;
    }

    TypeSymbol lookup(String name, Location loc) {
        boolean notFullyQualified;
        TypeSymbol res = super.lookup(name, loc);
        if (res != null) {
            return res;
        }
        boolean bl = notFullyQualified = name.indexOf(46) == -1;
        if (notFullyQualified) {
            boolean first = true;
            String[] pkgs = this.module.listImplicitPackages();
            int i = 0;
            while (i < pkgs.length) {
                String fullName = pkgs[i] + "." + name;
                TypeSymbol sym = this.get(fullName);
                if (sym != null) {
                    if (res == null) {
                        res = sym;
                        if (first) {
                            break;
                        }
                    } else {
                        User.error((Located)loc, "Ambiguity for symbol " + name + ":\n" + res + " and " + sym + " both exist");
                    }
                }
                first = false;
                ++i;
            }
        }
        if (res != null) {
            return res;
        }
        return JavaClasses.lookup(name, loc);
    }
}

