/*
 * Decompiled with CFR 0.152.
 */
package bossa.parser;

import bossa.parser.ParseException;
import bossa.parser.Parser;
import bossa.parser.Token;
import bossa.parser.TokenMgrError;
import bossa.syntax.LocatedString;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import nice.tools.util.Chronometer;

public abstract class Loader {
    private static Chronometer chrono = Chronometer.make("Parsing");

    public static LocatedString readImports(Reader r, List imports, Collection opens) {
        chrono.start();
        try {
            Parser parser = new Parser(r);
            try {
                LocatedString locatedString = parser.readImports(imports, opens);
                Object var6_6 = null;
                chrono.stop();
                return locatedString;
            }
            catch (ParseException e) {
                throw Loader.reportError(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            chrono.stop();
            throw throwable;
        }
    }

    public static void open(Reader r, List definitions, boolean storeDocStrings) {
        chrono.start();
        try {
            Parser parser = new Parser(r);
            try {
                parser.module(definitions, storeDocStrings);
            }
            catch (ParseException e) {
                throw Loader.reportError(e);
            }
            catch (TokenMgrError e) {
                String message = e.getMessage();
                if (message.indexOf("<EOF>") != -1) {
                    message = "Unexpected end of file";
                }
                User.error((Located)Location.nowhere(), message);
            }
            Object var8_7 = null;
            chrono.stop();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            chrono.stop();
            throw throwable;
        }
    }

    private static Error reportError(ParseException e) {
        if (e.currentToken != null) {
            Token token = e.currentToken;
            if (token.next != null) {
                token = token.next;
            }
            User.error((Located)Location.make(token), Loader.removeLocation(e.getMessage()));
        } else {
            User.error(e.getMessage());
        }
        return null;
    }

    private static String removeLocation(String message) {
        int start = message.indexOf(" at line ");
        if (start == -1) {
            return message;
        }
        int end = message.indexOf(46, start);
        return message.substring(0, start) + message.substring(end, message.length());
    }

    public static Parser getParser(String toParse) {
        StringReader r = new StringReader(toParse);
        Parser parser = new Parser(r);
        return parser;
    }
}

