/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IgnoreTarget;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;
import gnu.mapping.AliasConstraint;
import gnu.mapping.Binding;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.OutPort;
import gnu.mapping.SFormat;
import gnu.mapping.Values;

public class SetExp
extends Expression {
    private int flags;
    String name;
    public Declaration binding;
    Expression new_value;
    private static int DEFINING_FLAG = 1;
    private static int GLOBAL_FLAG = 2;
    public static int PREFER_BINDING2 = 4;
    private static int PROCEDURE = 8;
    private static int SET_IF_UNBOUND = 16;
    private static int HAS_VALUE = 32;
    static Method setMethod = null;

    public SetExp(String sym, Expression val) {
        this.name = sym;
        this.new_value = val;
    }

    public final String getName() {
        return this.name;
    }

    public final Expression getNewValue() {
        return this.new_value;
    }

    public final boolean isDefining() {
        return (this.flags & DEFINING_FLAG) != 0;
    }

    public final void setDefining(boolean value) {
        this.flags = value ? (this.flags |= DEFINING_FLAG) : (this.flags &= ~DEFINING_FLAG);
    }

    public final boolean getHasValue() {
        return (this.flags & HAS_VALUE) != 0;
    }

    public final void setHasValue(boolean value) {
        this.flags = value ? (this.flags |= HAS_VALUE) : (this.flags &= ~HAS_VALUE);
    }

    public final boolean isFuncDef() {
        return (this.flags & PROCEDURE) != 0;
    }

    public final void setFuncDef(boolean value) {
        this.flags = value ? (this.flags |= PROCEDURE) : (this.flags &= ~PROCEDURE);
    }

    public final boolean isSetIfUnbound() {
        return (this.flags & SET_IF_UNBOUND) != 0;
    }

    public final void setSetIfUnbound(boolean value) {
        this.flags = value ? (this.flags |= SET_IF_UNBOUND) : (this.flags &= ~SET_IF_UNBOUND);
    }

    public SetExp(Declaration decl, Expression val) {
        this.binding = decl;
        this.name = decl.getName();
        this.new_value = val;
    }

    @Override
    public Object eval(Environment env) throws Throwable {
        if (this.isSetIfUnbound()) {
            Binding binding = env.getBinding(this.name);
            if (!binding.isBound()) {
                binding.set(this.new_value.eval(env));
            }
            if (this.getHasValue()) {
                return this.name;
            }
            return Interpreter.getInterpreter().noValue();
        }
        Object new_val = this.new_value.eval(env);
        if (this.binding != null && !(this.binding.context instanceof ModuleExp)) {
            throw new Error("internal error - SetExp.eval with lexical binding");
        }
        if (this.isDefining()) {
            if (this.binding != null && this.binding.isAlias()) {
                AliasConstraint.define(env.getBinding(this.name), (Location)new_val);
            } else {
                env.define(this.name, new_val);
            }
        } else {
            Binding bind = env.lookup(this.name);
            if (bind != null) {
                env.put(this.name, new_val);
            } else {
                env.define(this.name, new_val);
            }
        }
        return this.getHasValue() ? new_val : Interpreter.getInterpreter().noValue();
    }

    @Override
    public void compile(Compilation comp, Target target) {
        if (this.new_value instanceof LambdaExp && target instanceof IgnoreTarget && ((LambdaExp)this.new_value).getInlineOnly()) {
            return;
        }
        CodeAttr code = comp.getCode();
        boolean needValue = this.getHasValue() && !(target instanceof IgnoreTarget);
        boolean valuePushed = false;
        Declaration decl = this.binding;
        if (!decl.isPrivate() && decl.context instanceof ModuleExp && decl.getValue() instanceof LambdaExp && ((LambdaExp)decl.getValue()).getName() != null && decl.getValue() == this.new_value) {
            ((LambdaExp)this.new_value).compileSetField(comp);
        } else if (!(decl.context instanceof ModuleExp) || !(this.new_value instanceof QuoteExp) || decl.isPrivate() || comp.immediate || decl.getValue() == null) {
            if (!this.isDefining()) {
                decl = Declaration.followAliases(decl);
            }
            if (decl.ignorable()) {
                this.new_value.compile(comp, Target.Ignore);
            } else if (decl.isAlias() && this.isDefining()) {
                if (decl.isPublic() || !(decl.getValue() instanceof ReferenceExp)) {
                    decl.load(comp);
                    this.new_value.compile(comp, Target.pushObject);
                    Method meth = ClassType.make("gnu.mapping.AliasConstraint").getDeclaredMethod("define", 2);
                    code.emitInvokeStatic(meth);
                }
            } else if (decl.isIndirectBinding() && (!this.isDefining() || decl.isPublic())) {
                decl.load(comp);
                this.new_value.compile(comp, Target.pushObject);
                if (needValue) {
                    code.emitDupX();
                    valuePushed = true;
                }
                if (setMethod == null) {
                    setMethod = Compilation.typeLocation.addMethod("set", Compilation.apply1args, Type.void_type, 17);
                }
                code.emitInvokeVirtual(setMethod);
            } else if (decl.isFluid()) {
                decl.load(comp);
                this.new_value.compile(comp, Type.pointer_type);
                code.emitPutField(FluidLetExp.valueField);
            } else if (decl.isSimple()) {
                Variable var;
                Type type = decl.getType();
                this.new_value.compile(comp, type);
                if (needValue) {
                    code.emitDup(type);
                    valuePushed = true;
                }
                if ((var = decl.getVariable()) == null) {
                    var = decl.allocateVariable(code);
                }
                code.emitStore(var);
            } else if (decl.context instanceof ClassExp && decl.field == null && !this.getFlag(PROCEDURE) && ((ClassExp)decl.context).isMakingClassPair()) {
                String setName = ClassExp.slotToMethodName("set", decl.getName());
                ClassExp cl = (ClassExp)decl.context;
                Method setter = cl.type.getDeclaredMethod(setName, 1);
                cl.loadHeapFrame(comp);
                this.new_value.compile(comp, decl.getType());
                if (needValue) {
                    code.emitDupX();
                    valuePushed = true;
                }
                code.emitInvoke(setter);
            } else {
                Field field = decl.field;
                if (!field.getStaticFlag()) {
                    decl.loadOwningObject(comp);
                }
                Type type = field.getType();
                this.new_value.compile(comp, type);
                if (field.getStaticFlag()) {
                    if (needValue) {
                        code.emitDup(type);
                        valuePushed = true;
                    }
                    code.emitPutStatic(field);
                } else {
                    if (needValue) {
                        code.emitDupX();
                        valuePushed = true;
                    }
                    code.emitPutField(field);
                }
            }
        }
        if (needValue && !valuePushed) {
            throw new Error("SetExp.compile: not implemented - return value");
        }
        if (needValue) {
            target.compileFromStack(comp, this.getType());
        } else {
            comp.compileConstant(Values.empty, target);
        }
    }

    @Override
    public final Type getType() {
        return !this.getHasValue() ? Type.void_type : (this.binding == null ? Type.pointer_type : this.binding.getType());
    }

    @Override
    protected Expression walk(ExpWalker walker) {
        return walker.walkSetExp(this);
    }

    @Override
    protected void walkChildren(ExpWalker walker) {
        this.new_value = this.new_value.walk(walker);
    }

    @Override
    public void print(OutPort out) {
        out.startLogicalBlock(this.isDefining() ? "(Define" : "(Set", ")", 2);
        out.writeSpaceFill();
        this.printLineColumn(out);
        SFormat.print(this.name, out);
        out.writeSpaceLinear();
        this.new_value.print(out);
        out.endLogicalBlock(")");
    }
}

