/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.modules.Compilation;
import bossa.modules.Package;
import bossa.syntax.Definition;
import bossa.syntax.Expression;
import bossa.syntax.Symbol;
import bossa.syntax.TypeScope;
import bossa.syntax.VarScope;
import bossa.syntax.dispatch;
import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import bossa.util.UserError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;

public abstract class Node {
    static final int global = 1;
    static final int down = 2;
    static final int upper = 3;
    static final int none = 4;
    public static Compilation compilation = null;
    static Object currentFunction;
    static Expression thisExp;
    private boolean typecheckingDone = false;
    protected VarScope scope;
    protected TypeScope typeScope;
    protected List children;
    private List varSymbols;
    int propagate;
    private List typeMapsSymbols;
    private List typeMapsNames;

    Node(int propagate) {
        this.propagate = propagate;
    }

    Node(List children, int propagate) {
        this(propagate);
        this.addChildren(children);
    }

    void addChild(Node n) {
        if (n == null) {
            Internal.error("null child in Node.addChild for node " + this);
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(n);
    }

    final Node child(Node n) {
        if (n == null) {
            return null;
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(n);
        return n;
    }

    void removeChild(Node n) {
        if (this.children == null || !this.children.contains(n)) {
            Internal.error(n + " is not a child of " + this);
        }
        this.children.remove(n);
    }

    void removeChildren() {
        this.children = null;
    }

    List addChildren(List c) {
        if (c == null) {
            return Collections.EMPTY_LIST;
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.addChild((Node)i.next());
        }
        return c;
    }

    void addSymbol(Symbol s) {
        if (this.varSymbols == null) {
            this.varSymbols = new ArrayList();
        }
        this.varSymbols.add(s);
    }

    void addTypeSymbol(TypeSymbol s) {
        this.addTypeMap(s.toString(), s);
    }

    void addTypeMap(String name, TypeSymbol symbol) {
        if (this.typeMapsNames == null) {
            this.typeMapsNames = new ArrayList();
            this.typeMapsSymbols = new ArrayList();
        }
        this.typeMapsNames.add(name);
        this.typeMapsSymbols.add(symbol);
    }

    public static final TypeScope getGlobalTypeScope() {
        return Node.compilation.globalTypeScope;
    }

    public static final Package getGlobalTypeScopeModule() {
        return Node.compilation.globalTypeScope.getPackage();
    }

    public static TypeConstructor globalTypeScopeLookup(String name, Location loc) {
        return Node.compilation.globalTypeScope.globalLookup(name, loc);
    }

    public static void setPackage(Package pkg) {
        if (compilation != pkg.getCompilation()) {
            compilation = pkg.getCompilation();
            if (Node.compilation.globalTypeScope == null) {
                Node.compilation.globalTypeScope = dispatch.createGlobalTypeScope();
            }
        }
        Node.compilation.globalTypeScope.setPackage(pkg);
    }

    void buildScope(Package pkg) {
        Node.setPackage(pkg);
        this.buildScope(null, Node.compilation.globalTypeScope);
    }

    void buildScope(VarScope outer, TypeScope typeOuter) {
        if (this instanceof Definition) {
            outer = ((Definition)this).module.scope;
        }
        switch (this.propagate) {
            case 4: {
                this.scope = outer;
                this.typeScope = typeOuter;
                break;
            }
            case 2: {
                this.scope = VarScope.create(outer, this.varSymbols);
                this.typeScope = new TypeScope(typeOuter);
                break;
            }
            case 1: {
                this.scope = outer;
                this.scope.addSymbols(this.varSymbols);
                this.typeScope = typeOuter = Node.compilation.globalTypeScope;
                break;
            }
            case 3: {
                if (outer == null) {
                    outer = VarScope.create(null);
                }
                outer.addSymbols(this.varSymbols);
                this.scope = outer;
                if (typeOuter == null) {
                    typeOuter = new TypeScope(null);
                }
                this.typeScope = typeOuter;
                break;
            }
            default: {
                Internal.error("Invalid case in Node.buildScope");
            }
        }
        if (this.propagate != 4) {
            try {
                if (this.typeMapsNames != null) {
                    this.typeScope.addMappings(this.typeMapsNames, this.typeMapsSymbols.toArray(new TypeSymbol[this.typeMapsSymbols.size()]));
                }
            }
            catch (TypeScope.DuplicateName e) {
                if (this instanceof Located) {
                    User.error((Located)((Located)((Object)this)).location(), e.getMessage());
                }
                User.error(e);
            }
        }
        this.varSymbols = null;
        this.typeMapsSymbols = null;
        this.typeMapsNames = null;
        if (this.children != null) {
            for (Node d : this.children) {
                d.buildScope(this.scope, this.typeScope);
            }
        }
    }

    VarScope getScope() {
        return this.scope;
    }

    TypeScope getTypeScope() {
        return this.typeScope;
    }

    void resolve() {
    }

    void doResolve() {
        if (Debug.resolution) {
            Debug.println("Resolving " + this + " [" + this.getClass() + "]");
        }
        this.resolve();
        this.scope = null;
        this.typeScope = null;
        if (this.children != null) {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                ((Node)i.next()).doResolve();
            }
        }
        if (Debug.resolution) {
            Debug.println("Resolved to " + this + " [" + this.getClass() + "]");
        }
    }

    static Object getCurrentFunction() {
        return currentFunction;
    }

    static void setCurrentFunction(Object f) {
        currentFunction = f;
    }

    void typecheck() {
    }

    final void doTypecheck() {
        if (this.typecheckingDone) {
            return;
        }
        this.typecheckingDone = true;
        this.typecheck();
        if (this.children != null) {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                try {
                    ((Node)i.next()).doTypecheck();
                }
                catch (UserError ex) {
                    Node.compilation.globalTypeScope.getPackage().getCompilation().error(ex);
                }
            }
        }
    }
}

