/*
 * Decompiled with CFR 0.152.
 */
package bossa.modules;

import bossa.modules.CompiledContent;
import bossa.modules.Content;
import bossa.modules.Package;
import bossa.util.User;
import bossa.util.Util;
import gnu.bytecode.ClassFileInput;
import gnu.bytecode.ClassType;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import nice.tools.util.System;

class DirectoryCompiledContent
extends CompiledContent {
    private File itf;
    private Package pkg;
    private File directory;

    static DirectoryCompiledContent create(Package pkg, File directory) {
        if (!directory.exists()) {
            return null;
        }
        DirectoryCompiledContent res = new DirectoryCompiledContent(pkg, directory);
        if (res.isValid()) {
            return res;
        }
        return null;
    }

    DirectoryCompiledContent(Package pkg, File directory) {
        this.pkg = pkg;
        this.directory = directory;
        this.itf = this.getInterface();
    }

    private boolean isValid() {
        return this.itf != null;
    }

    @Override
    Content.Unit[] getDefinitions() {
        return new Content.Unit[]{new Content.Unit(this.read(this.itf), this.itf)};
    }

    @Override
    ClassType readClass(String name) {
        InputStream s = this.getFileStream(Util.simpleName(name) + ".class");
        if (s == null) {
            return null;
        }
        ClassType res = null;
        s = new BufferedInputStream(s);
        try {
            res = ClassFileInput.readClassType(name, s);
        }
        catch (LinkageError e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return res;
    }

    private File getInterface() {
        File itf = new File(this.directory, "package.nicei");
        File dispatchFile = new File(this.directory, "dispatch.class");
        if (!itf.exists()) {
            return null;
        }
        this.bytecode = this.readClass(this.pkg.getName() + "." + "fun");
        this.dispatch = this.readClass(this.pkg.getName() + ".dispatch");
        if (this.bytecode == null || this.dispatch == null) {
            return null;
        }
        this.lastCompilation = Math.min(itf.lastModified(), dispatchFile.lastModified());
        return itf;
    }

    private BufferedReader read(File f) {
        try {
            return new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException e) {
            User.error(System.prettyPrint(f) + " of package " + this.pkg.getName() + " could not be found");
            return null;
        }
    }

    @Override
    void addClasses(Set classes) {
        DirectoryCompiledContent.addClasses(classes, this.directory);
    }

    static void addClasses(Set classes, File directory) {
        File[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName();
                if (name.equals("package.nicei")) {
                    return true;
                }
                return name.endsWith(".class") && f.isFile();
            }
        });
        for (int i = 0; i < files.length; ++i) {
            try {
                classes.add(new Content.Stream(new BufferedInputStream(new FileInputStream(files[i])), files[i].getName()));
                continue;
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
    }

    private InputStream getFileStream(String name) {
        File f = new File(this.directory, name);
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public String getName() {
        return System.prettyPrint(this.directory);
    }

    @Override
    public String toString() {
        return "Compiled package in: " + this.getName();
    }
}

