/*
 * nghttp3
 *
 * Copyright (c) 2020 nghttp3 contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "nghttp3_http_test.h"

#include <assert.h>

#include <CUnit/CUnit.h>

#include "nghttp3_http.h"
#include "nghttp3_macro.h"
#include "nghttp3_test_helper.h"

void test_nghttp3_http_parse_priority(void) {
  int rv;

  {
    nghttp3_pri pri = {(uint32_t)-1, -1};
    const uint8_t v[] = "";

    rv = nghttp3_http_parse_priority(&pri, v, sizeof(v) - 1);

    CU_ASSERT(0 == rv);
    CU_ASSERT((uint32_t)-1 == pri.urgency);
    CU_ASSERT(-1 == pri.inc);
  }

  {
    nghttp3_pri pri = {(uint32_t)-1, -1};
    const uint8_t v[] = "u=7,i";

    rv = nghttp3_http_parse_priority(&pri, v, sizeof(v) - 1);

    CU_ASSERT(0 == rv);
    CU_ASSERT((uint32_t)7 == pri.urgency);
    CU_ASSERT(1 == pri.inc);
  }

  {
    nghttp3_pri pri = {(uint32_t)-1, -1};
    const uint8_t v[] = "u=0,i=?0";

    rv = nghttp3_http_parse_priority(&pri, v, sizeof(v) - 1);

    CU_ASSERT(0 == rv);
    CU_ASSERT((uint32_t)0 == pri.urgency);
    CU_ASSERT(0 == pri.inc);
  }

  {
    nghttp3_pri pri = {(uint32_t)-1, -1};
    const uint8_t v[] = "u=3, i";

    rv = nghttp3_http_parse_priority(&pri, v, sizeof(v) - 1);

    CU_ASSERT(0 == rv);
    CU_ASSERT((uint32_t)3 == pri.urgency);
    CU_ASSERT(1 == pri.inc);
  }

  {
    nghttp3_pri pri = {(uint32_t)-1, -1};
    const uint8_t v[] = "u=0, i, i=?0, u=6";

    rv = nghttp3_http_parse_priority(&pri, v, sizeof(v) - 1);

    CU_ASSERT(0 == rv);
    CU_ASSERT((uint32_t)6 == pri.urgency);
    CU_ASSERT(0 == pri.inc);
  }

  {
    nghttp3_pri pri = {(uint32_t)-1, -1};
    const uint8_t v[] = "u=0,";

    rv = nghttp3_http_parse_priority(&pri, v, sizeof(v) - 1);

    CU_ASSERT(NGHTTP3_ERR_INVALID_ARGUMENT == rv);
  }

  {
    nghttp3_pri pri = {(uint32_t)-1, -1};
    const uint8_t v[] = "u=";

    rv = nghttp3_http_parse_priority(&pri, v, sizeof(v) - 1);

    CU_ASSERT(NGHTTP3_ERR_INVALID_ARGUMENT == rv);
  }

  {
    nghttp3_pri pri = {(uint32_t)-1, -1};
    const uint8_t v[] = "u";

    rv = nghttp3_http_parse_priority(&pri, v, sizeof(v) - 1);

    CU_ASSERT(NGHTTP3_ERR_INVALID_ARGUMENT == rv);
  }

  {
    nghttp3_pri pri = {(uint32_t)-1, -1};
    const uint8_t v[] = "i=?1";

    rv = nghttp3_http_parse_priority(&pri, v, sizeof(v) - 1);

    CU_ASSERT(0 == rv);
    CU_ASSERT((uint32_t)-1 == pri.urgency);
    CU_ASSERT(1 == pri.inc);
  }

  {
    nghttp3_pri pri = {(uint32_t)-1, -1};
    const uint8_t v[] = "i=?2";

    rv = nghttp3_http_parse_priority(&pri, v, sizeof(v) - 1);

    CU_ASSERT(NGHTTP3_ERR_INVALID_ARGUMENT == rv);
  }

  {
    nghttp3_pri pri = {(uint32_t)-1, -1};
    const uint8_t v[] = "i=?";

    rv = nghttp3_http_parse_priority(&pri, v, sizeof(v) - 1);

    CU_ASSERT(NGHTTP3_ERR_INVALID_ARGUMENT == rv);
  }

  {
    nghttp3_pri pri = {(uint32_t)-1, -1};
    const uint8_t v[] = "i=";

    rv = nghttp3_http_parse_priority(&pri, v, sizeof(v) - 1);

    CU_ASSERT(NGHTTP3_ERR_INVALID_ARGUMENT == rv);
  }
}
