/*
 * Copyright (C) by Roeland Jago Douma <roeland@famdouma.nl>
 * Copyright (C) 2015 by Klaas Freitag <freitag@owncloud.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 */

#ifndef SHARELINKWIDGET_H
#define SHARELINKWIDGET_H

#include "accountfwd.h"
#include "sharepermissions.h"
#include "QProgressIndicator.h"
#include <QDialog>
#include <QSharedPointer>
#include <QList>

class QMenu;
class QTableWidgetItem;

namespace OCC {

namespace Ui {
    class ShareLinkWidget;
}

class AbstractCredentials;
class SyncResult;
class LinkShare;
class Share;

/**
 * @brief The ShareDialog class
 * @ingroup gui
 */
class ShareLinkWidget : public QWidget
{
    Q_OBJECT

public:
    explicit ShareLinkWidget(AccountPtr account,
        const QString &sharePath,
        const QString &localPath,
        SharePermissions maxSharingPermissions,
        QWidget *parent = nullptr);
    ~ShareLinkWidget();

    void toggleButton(bool show);
    void setupUiOptions();

    void setLinkShare(QSharedPointer<LinkShare> linkShare);
    QSharedPointer<LinkShare> getLinkShare();

public slots:
    void slotDeleteShareFetched();
    void slotToggleAnimation(bool start);
    void slotServerError(int code, const QString &message);
    void slotCreateShareRequiresPassword(const QString &message);
    void slotStyleChanged();

private slots:
    void slotCreateShareLink(bool clicked);

    void slotCreatePassword();
    void slotPasswordSet();
    void slotPasswordSetError(int code, const QString &message);

    void slotSetExpireDate();
    void slotExpireDateSet();

    void slotContextMenuButtonClicked();
    void slotLinkContextMenuActionTriggered(QAction *action);

    void slotDeleteAnimationFinished();
    void slotAnimationFinished();

signals:
    void createLinkShare();
    void deleteLinkShare();
    void resizeRequested();
    void visualDeletionDone();

private:
    void displayError(const QString &errMsg);

    void showPasswordOptions(bool show);
    void togglePasswordOptions(bool enable);

    void showExpireDateOptions(bool show);
    void toggleExpireDateOptions(bool enable);

    void slotCopyLinkShare(bool clicked);

    /** Confirm with the user and then delete the share */
    void confirmAndDeleteShare();

    /** Retrieve a share's name, accounting for _namesSupported */
    QString shareName() const;

    void startAnimation(const int start, const int end);

    void customizeStyle();

    Ui::ShareLinkWidget *_ui;
    AccountPtr _account;
    QString _sharePath;
    QString _localPath;
    QString _shareUrl;

    QSharedPointer<LinkShare> _linkShare;

    bool _isFile;
    bool _passwordRequired;
    bool _expiryRequired;
    bool _namesSupported;

    QMenu *_linkContextMenu;
    QAction *_readOnlyLinkAction;
    QAction *_allowEditingLinkAction;
    QAction *_allowUploadEditingLinkAction;
    QAction *_allowUploadLinkAction;
    QAction *_passwordProtectLinkAction;
    QAction *_expirationDateLinkAction;
    QAction *_unshareLinkAction;
    QAction *_addAnotherLinkAction;
};
}

#endif // SHARELINKWIDGET_H
