/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// MailInfo.h: interface for the MailInfo class.
//
//////////////////////////////////////////////////////////////////////

#ifndef MAILINFO_H
#define MAILINFO_H

#include <mString.h>
#include <ASN1/Asn1Req.h>

/*!
	This class represents an email
*/
class MailInfo
{
public:
	/*! \brief This is the constructor.
	 */
	MailInfo();

	/*! \brief This is the destructor.
	 */
	virtual ~MailInfo();

	/*! \brief This function returns the recipient.
	 *  \return The recipient.
	 */
	const mString & get_MailTo() const;

	/*! \brief This function sets the recipient.
	 *  \param MailTo [IN] The recipient.
	 */
	void set_MailTo(const mString & MailTo);

	/*! \brief This function returns the body.
	 *  \return The body.
	 */
	const mString & get_Body() const;

	/*! \brief This function sets the body.
	 *  \param Body [IN] The body.
	 */
	void set_Body(const mString & Body);

	/*! \brief This function returns the subject.
	 *  \return The subject.
	 */
	const mString & get_Subject() const;

	/*! \brief This function sets the subject.
	 *  \param Subject [IN] The subject.
	 */
	void set_Subject(const mString & Subject);

	/*! \brief This function returns the attachement name.
	 *  \return The attachement name.
	 */
	const mString & get_AttachName() const;

	/*! \brief This function sets the attachement name.
	 *  \param AttachName [IN] The attachement name.
	 */
	void set_AttachName(const mString & AttachName);

	/*! \brief This function returns the attachement type.
	 *  \return The attachement type.
	 */
	const mString & get_AttachType() const;
	
	/*! \brief This function sets the attachement type.
	 *  \param AttachType [IN] The attachement type.
	 */
	void set_AttachType(const mString & AttachType);

	/*! \brief This function returns the attachement.
	 *  \return The attachement.
	 */
	mBuffer & get_Attach();

	/*! \brief This function returns the attachement.
	 *  \return The attachement.
	 */
	const mBuffer & c_get_Attach() const;

	/*! \brief This function returns whether or not the mail should be signed.
	 *  \return Whether or not the mail should be signed.
	 */
	bool get_SignMail() const;

	/*! \brief This function sets whether or not the mail should be signed.
	 *  \param SignMail [IN] Whether or not the mail should be signed.
	 */
	void set_SignMail(bool SignMail);

	/*! \brief This function loads the info from a MAIL_DATAS.
	 *  \param mail [IN] The MAIL_DATAS to load info from.
	 *  \return Whether or not the mail should be signed.
	 */
	bool FromMAIL_DATAS(const MailDatas & mail);

	/*! \brief This function sets the recipient.
	 */
	void Clear();

	/*! \brief This function return 1 when the mail info is operable and 0 when not.
	 *  \return return 1 when the mail info is operable and 0 when not.
	 */
	operator int() const;
private:
	mBuffer m_Attach;
	mString m_AttachName;
	mString m_AttachType;
	mString m_MailTo;
	mString m_Body;
	mString m_Subject;
	bool m_SignMail;
};

#endif
