/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// ReadersWriter.h: interface for the ReadersWriter class.
//
//////////////////////////////////////////////////////////////////////

#ifndef READERSWRITER_H
#define READERSWRITER_H

#include <CriticalSection.h>
#include <Semaphore.h>
#include <newpki_threads.h>
#include <map>
using namespace std;


/*!
  This class implements the ReadersWriter algorithm
*/
class ReadersWriter
{
public:
	/*! \brief This is the constructor.
	 */
	ReadersWriter();

	/*! \brief This is the destructor.
	 */
	virtual ~ReadersWriter();

	/*! \brief Requests a READ access.
	 */
	void LockRead() const;

#ifdef _DEBUG
	#define LockWrite() DoLockWrite(__FILE__, __LINE__)
	/*! \brief Requests a WRITE access.
	 */
	void DoLockWrite(const char * file, int line);
#else
	/*! \brief Requests a WRITE access.
	 */
	void LockWrite();
#endif

	/*! \brief Unlock the access.
	 */
	void UnlockWrite() const;

	/*! \brief Unlock the access.
	 */
	void UnlockRead() const;

private:
	Semaphore write_lock;
	unsigned long write_ctr;
	unsigned long read_ctr;
	CriticalSection LockerAcc;
	size_t m_WriterWantsLockCount;
	map< NEWPKI_THREAD_ID, long > m_ReadersList;
	map< NEWPKI_THREAD_ID, long > m_UnlockedReadersList;
#ifdef _DEBUG
	int m_stIndex;
	CSFileLine m_stLockers[300];
#endif
};

#endif
