/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// PKI_HashTable.cpp: implementation of the PKI_HashTable class.
//
//////////////////////////////////////////////////////////////////////

#include "PKI_HashTable.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PKI_HashTable::PKI_HashTable()
{
	hashliste=NULL;
	ctr=0;
	datas_len=0;
	AllowDup = false;
}

PKI_HashTable::~PKI_HashTable()
{
	Clear();
}

const void * PKI_HashTable::m_Get(const char * Name) const
{
	HASH_LISTE *const * tmpliste=&hashliste;

	if(!Name  || !hashliste)
	{
		return NULL;
	}

	while(*tmpliste)
	{
		if((*tmpliste)->Name)
		{
			//On cherche a savoir s'il existe deja
			if(strcmp((*tmpliste)->Name,Name)==0)
			{
				return (*tmpliste)->Value;
			}
		}
		tmpliste=&((*tmpliste)->psuiv);
	}

	return NULL;
}

bool PKI_HashTable::m_Add(const char *Name, const void *Value, long size)
{
	HASH_LISTE * * tmpliste=&hashliste;

	if(!Name || !Value)
	{
		return false;
	}


	while(*tmpliste)
	{
		if((*tmpliste)->Name)
		{
			//On cherche a savoir s'il existe deja
			if(!AllowDup && strcmp((*tmpliste)->Name,Name)==0)
			{
				return false;
			}
		}
		tmpliste=&((*tmpliste)->psuiv);
	}

	(*tmpliste)=(HASH_LISTE*)malloc(sizeof(HASH_LISTE));
	if(!(*tmpliste))
	{
		return false;
	}

	
	(*tmpliste)->Name=strdup(Name);
	if(!(*tmpliste)->Name)
	{
		free((*tmpliste));
		(*tmpliste)=NULL;
		return false;
	}
	
	(*tmpliste)->Value=malloc(size);
	if(!(*tmpliste)->Value)
	{
		free((*tmpliste)->Name);
		free((*tmpliste));
		(*tmpliste)=NULL;
		return false;
	}
	memcpy((*tmpliste)->Value, Value, size);

	(*tmpliste)->size = size;
	

	(*tmpliste)->psuiv=NULL;
	ctr++;
	datas_len=datas_len+strlen(Name)+1+size;
	return true;
}

long PKI_HashTable::EntriesCount() const
{
	return ctr;
}

const char * PKI_HashTable::GetName(long Pos) const
{
	long i;
	HASH_LISTE *const * tmpliste=NULL;

	if(Pos>=ctr || !hashliste)
	{
		return NULL;
	}

	for(tmpliste=&hashliste,i=0; i<ctr && *tmpliste; i++, tmpliste=&((*tmpliste)->psuiv))
	{
		//On cherche a savoir s'il existe deja
		if(i==Pos)
		{
			return (*tmpliste)->Name;
		}
		
	}
	return NULL;
}

const void * PKI_HashTable::m_GetPTR(long Pos) const
{
	long i;
	HASH_LISTE *const * tmpliste=NULL;

	if(Pos>=ctr || !hashliste)
	{
		return NULL;
	}

	for(tmpliste=&hashliste,i=0;i<ctr && *tmpliste;i++,tmpliste=&((*tmpliste)->psuiv))
	{
		//On cherche a savoir s'il existe deja
		if(i==Pos)
		{
			return (*tmpliste)->Value;
		}
		
	}
	return NULL;
}

long PKI_HashTable::DatasLen() const
{
	return datas_len;
}

void PKI_HashTable::Clear()
{
	HASH_LISTE * tmpliste;
	if(!hashliste)
	{
		return;
	}

	do
	{
		if(hashliste->Name) free(hashliste->Name);
		if(hashliste->Value) free(hashliste->Value);
		tmpliste=hashliste->psuiv;
		free(hashliste);
		hashliste=tmpliste;
	}
	while(tmpliste);

	ctr = 0;
	datas_len = 0;
}

bool PKI_HashTable::m_Modify(const char *Name, const void *Value, long size)
{
	HASH_LISTE * * tmpliste=&hashliste;

	if(!Name || !Value)
	{
		return false;
	}


	while(*tmpliste)
	{
		if((*tmpliste)->Name)
		{
			//On cherche a savoir s'il existe deja
			if(!AllowDup && strcmp((*tmpliste)->Name,Name)==0)
			{
				break;
			}
		}
		tmpliste=&((*tmpliste)->psuiv);
	}

	//S'il n'est pas prsent on l'ajoute
	if(!*tmpliste)
	{
		return m_Add(Name, Value, size);
	}

	if((*tmpliste)->Value)
	{
		free((*tmpliste)->Value);
	}
	

	datas_len=datas_len - (*tmpliste)->size;

	(*tmpliste)->Value=malloc(size);
	if((*tmpliste)->Value)
	{
		memcpy((*tmpliste)->Value, Value, size);
		(*tmpliste)->size = size;
		datas_len=datas_len + size;
		return false;
	}
	else
	{
		(*tmpliste)->size = 0;
		return true;
	}
}

bool PKI_HashTable::m_Modify(long Pos, const void *Value, long size)
{
	HASH_LISTE * * tmpliste=&hashliste;
	long i;

	if(Pos>=ctr || !hashliste || !Value)
	{
		return false;
	}

	for(tmpliste=&hashliste,i=0;i<ctr && *tmpliste;i++,tmpliste=&((*tmpliste)->psuiv))
	{
		//On cherche a savoir s'il existe deja
		if(i==Pos)
		{
			break;
		}
		
	}

	if((*tmpliste)->Value)
	{
		free((*tmpliste)->Value);
	}
	

	datas_len=datas_len - (*tmpliste)->size;

	(*tmpliste)->Value=malloc(size);
	if((*tmpliste)->Value)
	{
		memcpy((*tmpliste)->Value, Value, size);
		(*tmpliste)->size = size;
		datas_len=datas_len + size;
		return true;
	}
	else
	{
		(*tmpliste)->size = 0;
		return false;
	}
}



bool PKI_HashTable::operator=( const PKI_HashTable &other )
{
	other.HashLock.EnterCS();
	Clear();

	HASH_LISTE * tmpliste=other.hashliste;
	if(!tmpliste)
	{
		other.HashLock.LeaveCS();
		return false;
	}
	if(!other.ctr)
	{
		other.HashLock.LeaveCS();
		return false;
	}

	AllowDup = other.AllowDup;
	do
	{
		if(!m_Add(tmpliste->Name, tmpliste->Value, tmpliste->size))
		{
			Clear();
			other.HashLock.LeaveCS();
			return false;
		}
		tmpliste=tmpliste->psuiv;
	}
	while(tmpliste);

	other.HashLock.LeaveCS();
	return true;
}

bool PKI_HashTable::Delete(const char * Name)
{
	HASH_LISTE * * tmpliste=&hashliste;
	HASH_LISTE * tmpvalue;


	if(!Name  || !hashliste)
	{
		return false;
	}

	while(*tmpliste)
	{
		if((*tmpliste)->Name)
		{
			//On cherche a savoir s'il existe deja
			if(strcmp((*tmpliste)->Name,Name)==0)
			{
				tmpvalue = (*tmpliste);
				(*tmpliste) = tmpvalue->psuiv;

				datas_len = datas_len - tmpvalue->size;
				datas_len = datas_len - strlen(tmpvalue->Name) - 1;

				if(tmpvalue->Name) free(tmpvalue->Name);
				if(tmpvalue->Value) free(tmpvalue->Value);
				free(tmpvalue);
				ctr--;
				return true;
			}
		}
		tmpliste=&((*tmpliste)->psuiv);
	}
	return false;
}

bool PKI_HashTable::Delete(long Pos)
{
	HASH_LISTE * * tmpliste=&hashliste;
	HASH_LISTE * tmpvalue;
	long i;



	if(Pos>=ctr || !hashliste)
	{
		return false;
	}

	for(tmpliste=&hashliste,i=0;i<ctr && *tmpliste;i++,tmpliste=&((*tmpliste)->psuiv))
	{
		//On cherche a savoir s'il existe deja
		if(i==Pos)
		{
			tmpvalue = (*tmpliste);
			(*tmpliste) = tmpvalue->psuiv;

			datas_len = datas_len - tmpvalue->size;
			datas_len = datas_len - strlen(tmpvalue->Name) - 1;

			if(tmpvalue->Name) free(tmpvalue->Name);
			if(tmpvalue->Value) free(tmpvalue->Value);
			free(tmpvalue);
			ctr--;
			return true;
		}
		
	}
	return false;
}


long PKI_HashTable::SeekEntryName(const char *Name, long LastPos) const
{
	long i;
	HASH_LISTE *const * tmpliste=NULL;

	if(!Name || !hashliste)
	{
		return -1;
	}

	for(tmpliste=&hashliste,i=0;i<ctr && *tmpliste;i++,tmpliste=&((*tmpliste)->psuiv))
	{
		//On cherche a savoir s'il existe deja
		if(i > LastPos && strcmp(Name, (*tmpliste)->Name) == 0)
		{
			return i;
		}
		
	}
	return -1;
}

void PKI_HashTable::AllowDuplicateNames()
{
	AllowDup = true;
}

void PKI_HashTable::Lock() const
{
	HashLock.EnterCS();
}

void PKI_HashTable::Unlock() const
{
	HashLock.LeaveCS();
}
