#include "netwibtest.h"

/*-------------------------------------------------------------*/
static netwib_err test_bufnet2(netwib_conststring ips,
                               netwib_conststring wantips)
{
  netwib_buf buf;
  netwib_ip ipa, wantip;
  netwib_cmp cmp;

  netwib_er(netwib_buf_init_ext_text(ips, &buf));
  netwib_er(netwib_priv_ip_init_bufnet(&buf, &ipa));
  netwib_er(netwib_buf_init_ext_text(wantips, &buf));
  netwib_er(netwib_ip_init_buf_best(&buf, &wantip));

  netwib_er(netwib_ip_cmp(&ipa, &wantip, &cmp));
  if (cmp != NETWIB_CMP_EQ) {
    return(NETWIBTEST_ERR_4);
  }

  return(NETWIB_ERR_OK);
}
static netwib_err test_bufnet(void)
{
  puts("++++----\nTest of netwib_priv_ip_init_bufnet");
  netwib_er(test_bufnet2("1.2.3.130", "1.2.3.130"));
  netwib_er(test_bufnet2("1.2.3", "1.2.3.0"));
  netwib_er(test_bufnet2("1.2", "1.2.0.0"));
  netwib_er(test_bufnet2("127", "127.0.0.0"));
  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
static netwib_err test_ipnet2(netwib_conststring ips,
                              netwib_conststring nets,
                              netwib_conststring wantmasks,
                              netwib_uint32 wantprefix)
{
  netwib_buf buf;
  netwib_ip ipa, net, wantmask, mask;
  netwib_uint32 prefix;
  netwib_cmp cmp;

  netwib_er(netwib_buf_init_ext_text(ips, &buf));
  netwib_er(netwib_ip_init_buf_best(&buf, &ipa));
  netwib_er(netwib_buf_init_ext_text(nets, &buf));
  netwib_er(netwib_ip_init_buf_best(&buf, &net));
  netwib_er(netwib_buf_init_ext_text(wantmasks, &buf));
  netwib_er(netwib_ip_init_buf_best(&buf, &wantmask));

  prefix = 0;
  netwib_er(netwib_priv_ip_maskprefix_init_ipnet(&ipa, &net, &mask, &prefix));
  if (ipa.iptype == NETWIB_IPTYPE_IP4) {
    netwib_er(netwib_ip_cmp(&mask, &wantmask, &cmp));
    if (cmp != NETWIB_CMP_EQ) {
      return(NETWIBTEST_ERR_4);
    }
  } else {
    if (prefix != wantprefix) {
      return(NETWIBTEST_ERR_5);
    }
  }


  return(NETWIB_ERR_OK);
}
static netwib_err test_ipnet(void)
{
  puts("++++----\nTest of netwib_priv_ip_maskprefix_init_ipnet");
  netwib_er(test_ipnet2("1.2.3.130", "1.2.3.128", "255.255.255.128", 0));
  netwib_er(test_ipnet2("1.2.3.130", "1.2.3.0", "255.255.255.0", 0));
  netwib_er(test_ipnet2("1.2.3.130", "1.2.0.0", "255.255.0.0", 0));
  netwib_er(test_ipnet2("1.2.3.130", "1.0.0.0", "255.0.0.0", 0));
  netwib_er(test_ipnet2("1.2.66.130", "1.64.0.0", "255.192.0.0", 0));
  netwib_er(test_ipnet2("1.2.196.130", "1.192.0.0", "255.192.0.0", 0));
  netwib_er(test_ipnet2("127.0.0.1", "127.0.0.0", "255.255.255.0", 0));
  netwib_er(test_ipnet2("1:2:3:4::1", "1:2:3:4::", "1.2.3.4", 112));
  netwib_er(test_ipnet2("1:2:3:4:1::1", "1:2:3:4::", "1.2.3.4", 64));
  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
/*-------------------------------------------------------------*/
netwib_err netwibtest_net_priv(void)
{
  puts("###########################################\nTest of net/priv");

  netwib_er(test_bufnet());
  netwib_er(test_ipnet());
  return(NETWIB_ERR_OK);
}
