
/*-------------------------------------------------------------*/
/* common structures for NETWOX_SMBCMD_TYPE_TRANSACTION2 */

/*-------------------------------------------------------------*/
typedef enum {
  NETWOX_SMBCMDTSC2_FMT_FIND_DIRECTORY =     0x101,
  NETWOX_SMBCMDTSC2_FMT_FIND_FULLDIRECTORY = 0x102,
  NETWOX_SMBCMDTSC2_FMT_FIND_NAMESINFO =     0x103,
  NETWOX_SMBCMDTSC2_FMT_FIND_BOTHDIRECTORY = 0x104
} netwox_smbcmdtsc2_fmt_find;

/*----*/
typedef struct {
  netwib_uint32 fileindex;
  netwox_smbcmdcmn_time1601 creationtime;
  netwox_smbcmdcmn_time1601 lastaccesstime;
  netwox_smbcmdcmn_time1601 lastwritetime;
  netwox_smbcmdcmn_time1601 changetime;
  netwox_smbcmdcmn_uint64 filesize;
  netwox_smbcmdcmn_uint64 allocationsize;
  netwox_smbcmdcmn_fileattr32 fileattributes;
  netwib_uint32 easize; /* ?, apparently always zero */
  netwox_smbcmdcmn_data shortfilename;
  netwox_smbcmdcmn_data longfilename;
} netwox_smbcmdtsc2_fmt_find_bothdirectory;
netwib_err netwox_smbcmdtsc2_fmt_find_bothdirectory_init(netwox_smbcmdtsc2_fmt_find_bothdirectory *pitem);
netwib_err netwox_smbcmdtsc2_fmt_find_bothdirectory_setdefault(netwox_smbcmdtsc2_fmt_find_bothdirectory *pitem);
netwib_err netwox_smbcmdtsc2_fmt_find_bothdirectory_close(netwox_smbcmdtsc2_fmt_find_bothdirectory *pitem);
netwib_err netwox_smbcmdtsc2_fmt_find_bothdirectory_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_find_bothdirectory *pitem);
netwib_err netwox_smbcmdtsc2_fmt_find_bothdirectory_size(netwox_smbcmdtsc2_fmt_find_bothdirectory *pitem,
                                                         netwib_uint32 *psize);
netwib_err netwox_smbcmdtsc2_fmt_find_bothdirectory_append(const netwox_smbcmdtsc2_fmt_find_bothdirectory *pitem,
                                                           netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_find_bothdirectory_show(const netwox_smbcmdtsc2_fmt_find_bothdirectory *pitem,
                                                         netwib_buf *pbuf);

/*-------------------------------------------------------------*/
typedef enum {
  NETWOX_SMBCMDTSC2_FMT_FS_OLDALLOCATION =     1,
  NETWOX_SMBCMDTSC2_FMT_FS_OLDVOLUME =         2,
  NETWOX_SMBCMDTSC2_FMT_FS_LABEL =         0x101,
  NETWOX_SMBCMDTSC2_FMT_FS_VOLUME =        0x102,
  NETWOX_SMBCMDTSC2_FMT_FS_SIZE =          0x103,
  NETWOX_SMBCMDTSC2_FMT_FS_DEVICE =        0x104,
  NETWOX_SMBCMDTSC2_FMT_FS_ATTRIBUTE =     0x105,
  NETWOX_SMBCMDTSC2_FMT_FS_EVOLUME =        1001,
  NETWOX_SMBCMDTSC2_FMT_FS_ELABEL =         1002,
  NETWOX_SMBCMDTSC2_FMT_FS_ESIZE =          1003,
  NETWOX_SMBCMDTSC2_FMT_FS_EDEVICE =        1004,
  NETWOX_SMBCMDTSC2_FMT_FS_EATTRIBUTE =     1005,
  NETWOX_SMBCMDTSC2_FMT_FS_EQUOTA =         1006,
  NETWOX_SMBCMDTSC2_FMT_FS_EFULLSIZE =      1007,
  NETWOX_SMBCMDTSC2_FMT_FS_EOBJECTID =      1008
} netwox_smbcmdtsc2_fmt_fs;

/*----*/
typedef struct {
  netwib_uint32 fsid;
  netwib_uint32 sectorsperunit;
  netwib_uint32 totalunits;
  netwib_uint32 availableunits;
  netwib_uint16 bytespersector;
} netwox_smbcmdtsc2_fmt_fs_oldallocation;
netwib_err netwox_smbcmdtsc2_fmt_fs_oldallocation_init(netwox_smbcmdtsc2_fmt_fs_oldallocation *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_oldallocation_setdefault(netwox_smbcmdtsc2_fmt_fs_oldallocation *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_oldallocation_close(netwox_smbcmdtsc2_fmt_fs_oldallocation *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_oldallocation_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_fs_oldallocation *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_oldallocation_append(const netwox_smbcmdtsc2_fmt_fs_oldallocation *pitem,
                                                         netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_fs_oldallocation_show(const netwox_smbcmdtsc2_fmt_fs_oldallocation *pitem,
                                                       netwib_buf *pbuf);

/*----*/
typedef struct {
  netwib_uint32 serialnumber;
  netwox_smbcmdcmn_data label;
} netwox_smbcmdtsc2_fmt_fs_oldvolume;
netwib_err netwox_smbcmdtsc2_fmt_fs_oldvolume_init(netwox_smbcmdtsc2_fmt_fs_oldvolume *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_oldvolume_setdefault(netwox_smbcmdtsc2_fmt_fs_oldvolume *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_oldvolume_close(netwox_smbcmdtsc2_fmt_fs_oldvolume *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_oldvolume_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_fs_oldvolume *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_oldvolume_append(const netwox_smbcmdtsc2_fmt_fs_oldvolume *pitem,
                                                  netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_fs_oldvolume_show(const netwox_smbcmdtsc2_fmt_fs_oldvolume *pitem,
                                                netwib_buf *pbuf);

/*----*/
typedef struct {
  netwox_smbcmdcmn_time1601 creationtime;
  netwib_uint32 serialnumber;
  netwox_smbcmdcmn_data label;
} netwox_smbcmdtsc2_fmt_fs_volume;
netwib_err netwox_smbcmdtsc2_fmt_fs_volume_init(netwox_smbcmdtsc2_fmt_fs_volume *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_volume_setdefault(netwox_smbcmdtsc2_fmt_fs_volume *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_volume_close(netwox_smbcmdtsc2_fmt_fs_volume *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_volume_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_fs_volume *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_volume_append(const netwox_smbcmdtsc2_fmt_fs_volume *pitem,
                                                  netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_fs_volume_show(const netwox_smbcmdtsc2_fmt_fs_volume *pitem,
                                                netwib_buf *pbuf);

/*----*/
typedef struct {
  netwox_smbcmdcmn_uint64 allocationsize;
  netwox_smbcmdcmn_uint64 freeunits;
  netwib_uint32 sectorsperunit;
  netwib_uint32 bytespersector;
} netwox_smbcmdtsc2_fmt_fs_size;
netwib_err netwox_smbcmdtsc2_fmt_fs_size_init(netwox_smbcmdtsc2_fmt_fs_size *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_size_setdefault(netwox_smbcmdtsc2_fmt_fs_size *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_size_close(netwox_smbcmdtsc2_fmt_fs_size *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_size_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_fs_size *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_size_append(const netwox_smbcmdtsc2_fmt_fs_size *pitem,
                                                netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_fs_size_show(const netwox_smbcmdtsc2_fmt_fs_size *pitem,
                                              netwib_buf *pbuf);

/*----*/
typedef struct {
  netwib_uint32 fsattributes;
#define NETWOX_SMBCMDTSC2_FS_ATTRIBUTE_CASESENSSEARCH 0x00000001
#define NETWOX_SMBCMDTSC2_FS_ATTRIBUTE_CASEPRESERVING 0x00000002
#define NETWOX_SMBCMDTSC2_FS_ATTRIBUTE_PERSISTENTACL  0x00000004
#define NETWOX_SMBCMDTSC2_FS_ATTRIBUTE_COMPRESSEDFILE 0x00000008
#define NETWOX_SMBCMDTSC2_FS_ATTRIBUTE_VOLUMEQUOTAS   0x00000010
#define NETWOX_SMBCMDTSC2_FS_ATTRIBUTE_MOUNTED        0x00000020
#define NETWOX_SMBCMDTSC2_FS_ATTRIBUTE_COMPRESSEDVOL  0x00008000
  netwib_uint32 maxnamesize; /* 255 */
  netwox_smbcmdcmn_data fsname; /* FAT, FAT32 or NTFS */
} netwox_smbcmdtsc2_fmt_fs_attribute;
netwib_err netwox_smbcmdtsc2_fmt_fs_attribute_init(netwox_smbcmdtsc2_fmt_fs_attribute *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_attribute_setdefault(netwox_smbcmdtsc2_fmt_fs_attribute *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_attribute_close(netwox_smbcmdtsc2_fmt_fs_attribute *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_attribute_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_fs_attribute *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_attribute_append(const netwox_smbcmdtsc2_fmt_fs_attribute *pitem,
                                                     netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_fs_attribute_show(const netwox_smbcmdtsc2_fmt_fs_attribute *pitem,
                                                   netwib_buf *pbuf);

/*----*/
typedef struct {
  netwox_smbcmdcmn_uint64 allocationsize;
  netwox_smbcmdcmn_uint64 callerfreeunits;
  netwox_smbcmdcmn_uint64 actualfreeunits;
  netwib_uint32 sectorsperunit;
  netwib_uint32 bytespersector;
} netwox_smbcmdtsc2_fmt_fs_efullsize;
netwib_err netwox_smbcmdtsc2_fmt_fs_efullsize_init(netwox_smbcmdtsc2_fmt_fs_efullsize *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_efullsize_setdefault(netwox_smbcmdtsc2_fmt_fs_efullsize *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_efullsize_close(netwox_smbcmdtsc2_fmt_fs_efullsize *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_efullsize_decode(netwib_data *pdata,
                             netwib_uint32 *pdataefullsize,
                             netwox_smbcmdtsc2_fmt_fs_efullsize *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_efullsize_append(const netwox_smbcmdtsc2_fmt_fs_efullsize *pitem,
                                                     netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_fs_efullsize_show(const netwox_smbcmdtsc2_fmt_fs_efullsize *pitem,
                                                   netwib_buf *pbuf);

/*----*/
typedef struct {
  netwox_smbcmdcmn_data guid;
  netwox_smbcmdcmn_data unknown;
} netwox_smbcmdtsc2_fmt_fs_eobjectid;
netwib_err netwox_smbcmdtsc2_fmt_fs_eobjectid_init(netwox_smbcmdtsc2_fmt_fs_eobjectid *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_eobjectid_setdefault(netwox_smbcmdtsc2_fmt_fs_eobjectid *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_eobjectid_close(netwox_smbcmdtsc2_fmt_fs_eobjectid *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_eobjectid_decode(netwib_data *pdata,
                             netwib_uint32 *pdataeobjectid,
                             netwox_smbcmdtsc2_fmt_fs_eobjectid *pitem);
netwib_err netwox_smbcmdtsc2_fmt_fs_eobjectid_append(const netwox_smbcmdtsc2_fmt_fs_eobjectid *pitem,
                                                     netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_fs_eobjectid_show(const netwox_smbcmdtsc2_fmt_fs_eobjectid *pitem,
                                                   netwib_buf *pbuf);

/*-------------------------------------------------------------*/
typedef enum {
  NETWOX_SMBCMDTSC2_FMT_FILE_BASIC =      0x101,
  NETWOX_SMBCMDTSC2_FMT_FILE_STANDARD =   0x102,
  NETWOX_SMBCMDTSC2_FMT_FILE_EA =         0x103,
  NETWOX_SMBCMDTSC2_FMT_FILE_NAME =       0x104,
  NETWOX_SMBCMDTSC2_FMT_FILE_ALLOCATION = 0x105,
  NETWOX_SMBCMDTSC2_FMT_FILE_EOF =        0x106,
  NETWOX_SMBCMDTSC2_FMT_FILE_ALL =        0x107,
  NETWOX_SMBCMDTSC2_FMT_FILE_ALTNAME =    0x108,
  NETWOX_SMBCMDTSC2_FMT_FILE_STREAM =     0x109,
  NETWOX_SMBCMDTSC2_FMT_FILE_EDIRECTORY =     1001,
  NETWOX_SMBCMDTSC2_FMT_FILE_EFULLDIRECTORY = 1002,
  NETWOX_SMBCMDTSC2_FMT_FILE_EBOTHDIRECTORY = 1003,
  NETWOX_SMBCMDTSC2_FMT_FILE_EBASIC =         1004,
  NETWOX_SMBCMDTSC2_FMT_FILE_ESTANDARD =      1005,
  NETWOX_SMBCMDTSC2_FMT_FILE_EINTERNAL =      1006,
  NETWOX_SMBCMDTSC2_FMT_FILE_EEA =            1007,
  NETWOX_SMBCMDTSC2_FMT_FILE_EACCESS =        1008,
  NETWOX_SMBCMDTSC2_FMT_FILE_ENAME =          1009,
  NETWOX_SMBCMDTSC2_FMT_FILE_ERENAME =        1010,
  NETWOX_SMBCMDTSC2_FMT_FILE_ELINK =          1011,
  NETWOX_SMBCMDTSC2_FMT_FILE_ENAMES =         1012,
  NETWOX_SMBCMDTSC2_FMT_FILE_EDISPOSITION =   1013,
  NETWOX_SMBCMDTSC2_FMT_FILE_EPOSITION =      1014,
  NETWOX_SMBCMDTSC2_FMT_FILE_EFULL_EA =       1015,
  NETWOX_SMBCMDTSC2_FMT_FILE_EMODE =          1016,
  NETWOX_SMBCMDTSC2_FMT_FILE_EALIGNMENT =     1017,
  NETWOX_SMBCMDTSC2_FMT_FILE_EALL =           1018,
  NETWOX_SMBCMDTSC2_FMT_FILE_EALLOCATION =    1019,
  NETWOX_SMBCMDTSC2_FMT_FILE_EEOF =           1020,
  NETWOX_SMBCMDTSC2_FMT_FILE_EALTERNATENAME = 1021,
  NETWOX_SMBCMDTSC2_FMT_FILE_ESTREAM =        1022,
  NETWOX_SMBCMDTSC2_FMT_FILE_EPIPE =          1023,
  NETWOX_SMBCMDTSC2_FMT_FILE_EPIPELOCAL =     1024,
  NETWOX_SMBCMDTSC2_FMT_FILE_EPIPEREMOTE =    1025,
  NETWOX_SMBCMDTSC2_FMT_FILE_EMAILSLOTQUERY = 1026,
  NETWOX_SMBCMDTSC2_FMT_FILE_EMAILSLOTSET =   1027,
  NETWOX_SMBCMDTSC2_FMT_FILE_ECOMPRESSION =   1028,
  NETWOX_SMBCMDTSC2_FMT_FILE_EOBJECTID =      1029,
  NETWOX_SMBCMDTSC2_FMT_FILE_ECOMPLETION =    1030,
  NETWOX_SMBCMDTSC2_FMT_FILE_EMOVECLUSTER =   1031,
  NETWOX_SMBCMDTSC2_FMT_FILE_EQUOTA =         1032,
  NETWOX_SMBCMDTSC2_FMT_FILE_EREPARSEPOINT =  1033,
  NETWOX_SMBCMDTSC2_FMT_FILE_ENETWORKOPEN =   1034,
  NETWOX_SMBCMDTSC2_FMT_FILE_EATTRIBUTETAG =  1035,
  NETWOX_SMBCMDTSC2_FMT_FILE_ETRACKING =      1036,
  NETWOX_SMBCMDTSC2_FMT_FILE_EMAXIMUM =       1037
} netwox_smbcmdtsc2_fmt_file;

/*----*/
typedef struct {
  netwox_smbcmdcmn_time1601 creationtime;
  netwox_smbcmdcmn_time1601 lastaccesstime;
  netwox_smbcmdcmn_time1601 lastwritetime;
  netwox_smbcmdcmn_time1601 changetime;
  netwox_smbcmdcmn_fileattr16 fileattributes;
} netwox_smbcmdtsc2_fmt_file_basic;
netwib_err netwox_smbcmdtsc2_fmt_file_basic_init(netwox_smbcmdtsc2_fmt_file_basic *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_basic_setdefault(netwox_smbcmdtsc2_fmt_file_basic *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_basic_close(netwox_smbcmdtsc2_fmt_file_basic *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_basic_decode(netwib_data *pdata,
                                                   netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_basic *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_basic_append(const netwox_smbcmdtsc2_fmt_file_basic *pitem,
                                                   netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_basic_show(const netwox_smbcmdtsc2_fmt_file_basic *pitem,
                                                 netwib_buf *pbuf);

/*----*/
typedef struct {
  netwox_smbcmdcmn_uint64 allocationsize;
  netwox_smbcmdcmn_uint64 filesize;
  netwib_uint32 linkcount; /* at least 1 */
  netwib_uint16 deletepending; /* 0 or 256 */
  netwib_bool isdirectory;
} netwox_smbcmdtsc2_fmt_file_standard;
netwib_err netwox_smbcmdtsc2_fmt_file_standard_init(netwox_smbcmdtsc2_fmt_file_standard *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_standard_setdefault(netwox_smbcmdtsc2_fmt_file_standard *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_standard_close(netwox_smbcmdtsc2_fmt_file_standard *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_standard_decode(netwib_data *pdata,
                                                      netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_standard *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_standard_append(const netwox_smbcmdtsc2_fmt_file_standard *pitem,
                                                      netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_standard_show(const netwox_smbcmdtsc2_fmt_file_standard *pitem,
                                                    netwib_buf *pbuf);

/*----*/
typedef struct {
  netwib_uint32 easize; /* ?, seen 0, 5, 9, 11 or 15 */
} netwox_smbcmdtsc2_fmt_file_ea;
netwib_err netwox_smbcmdtsc2_fmt_file_ea_init(netwox_smbcmdtsc2_fmt_file_ea *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_ea_setdefault(netwox_smbcmdtsc2_fmt_file_ea *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_ea_close(netwox_smbcmdtsc2_fmt_file_ea *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_ea_decode(netwib_data *pdata,
                                                netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_ea *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_ea_append(const netwox_smbcmdtsc2_fmt_file_ea *pitem,
                                                netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_ea_show(const netwox_smbcmdtsc2_fmt_file_ea *pitem,
                                              netwib_buf *pbuf);

/*----*/
typedef struct {
  netwox_smbcmdcmn_data filename;
} netwox_smbcmdtsc2_fmt_file_name;
netwib_err netwox_smbcmdtsc2_fmt_file_name_init(netwox_smbcmdtsc2_fmt_file_name *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_name_setdefault(netwox_smbcmdtsc2_fmt_file_name *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_name_close(netwox_smbcmdtsc2_fmt_file_name *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_name_decode(netwib_data *pdata,
                                                  netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_name *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_name_append(const netwox_smbcmdtsc2_fmt_file_name *pitem,
                                                  netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_name_show(const netwox_smbcmdtsc2_fmt_file_name *pitem,
                                                netwib_buf *pbuf);

/*----*/
#if 0
/* supposed, but not seen on wire */
typedef struct {
  netwox_smbcmdcmn_uint64 allocationsize;
} netwox_smbcmdtsc2_fmt_file_allocation;
netwib_err netwox_smbcmdtsc2_fmt_file_allocation_init(netwox_smbcmdtsc2_fmt_file_allocation *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_allocation_setdefault(netwox_smbcmdtsc2_fmt_file_allocation *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_allocation_close(netwox_smbcmdtsc2_fmt_file_allocation *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_allocation_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_allocation *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_allocation_append(const netwox_smbcmdtsc2_fmt_file_allocation *pitem,
                                                        netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_allocation_show(const netwox_smbcmdtsc2_fmt_file_allocation *pitem,
                                                    netwib_buf *pbuf);
#endif

/*----*/
typedef struct {
  netwox_smbcmdcmn_data filename;
} netwox_smbcmdtsc2_fmt_file_altname;
netwib_err netwox_smbcmdtsc2_fmt_file_altname_init(netwox_smbcmdtsc2_fmt_file_altname *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_altname_setdefault(netwox_smbcmdtsc2_fmt_file_altname *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_altname_close(netwox_smbcmdtsc2_fmt_file_altname *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_altname_decode(netwib_data *pdata,
                                                     netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_altname *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_altname_append(const netwox_smbcmdtsc2_fmt_file_altname *pitem,
                                                     netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_altname_show(const netwox_smbcmdtsc2_fmt_file_altname *pitem,
                                                   netwib_buf *pbuf);

/*----*/
typedef struct {
  netwox_smbcmdcmn_uint64 streamsize;
  netwox_smbcmdcmn_uint64 allocationsize;
  netwox_smbcmdcmn_data name;
} netwox_smbcmdtsc2_fmt_file_stream;
netwib_err netwox_smbcmdtsc2_fmt_file_stream_init(netwox_smbcmdtsc2_fmt_file_stream *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_stream_setdefault(netwox_smbcmdtsc2_fmt_file_stream *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_stream_close(netwox_smbcmdtsc2_fmt_file_stream *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_stream_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_stream *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_stream_size(netwox_smbcmdtsc2_fmt_file_stream *pitem,
                                                  netwib_uint32 *psize);
netwib_err netwox_smbcmdtsc2_fmt_file_stream_append(const netwox_smbcmdtsc2_fmt_file_stream *pitem,
                                                    netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_stream_show(const netwox_smbcmdtsc2_fmt_file_stream *pitem,
                                                  netwib_buf *pbuf);

/*----*/
typedef struct {
  netwox_smbcmdcmn_time1601 creationtime;
  netwox_smbcmdcmn_time1601 lastaccesstime;
  netwox_smbcmdcmn_time1601 lastwritetime;
  netwox_smbcmdcmn_time1601 changetime;
  netwox_smbcmdcmn_fileattr16 fileattributes;
} netwox_smbcmdtsc2_fmt_file_ebasic;
netwib_err netwox_smbcmdtsc2_fmt_file_ebasic_init(netwox_smbcmdtsc2_fmt_file_ebasic *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_ebasic_setdefault(netwox_smbcmdtsc2_fmt_file_ebasic *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_ebasic_close(netwox_smbcmdtsc2_fmt_file_ebasic *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_ebasic_decode(netwib_data *pdata,
                                                    netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_ebasic *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_ebasic_append(const netwox_smbcmdtsc2_fmt_file_ebasic *pitem,
                                                    netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_ebasic_show(const netwox_smbcmdtsc2_fmt_file_ebasic *pitem,
                                                  netwib_buf *pbuf);

/*----*/
typedef struct {
  netwox_smbcmdcmn_uint64 allocationsize;
  netwox_smbcmdcmn_uint64 filesize;
  netwib_uint32 linkcount;
  netwib_uint16 deletepending;
  netwib_bool isdirectory;
} netwox_smbcmdtsc2_fmt_file_estandard;
netwib_err netwox_smbcmdtsc2_fmt_file_estandard_init(netwox_smbcmdtsc2_fmt_file_estandard *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_estandard_setdefault(netwox_smbcmdtsc2_fmt_file_estandard *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_estandard_close(netwox_smbcmdtsc2_fmt_file_estandard *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_estandard_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_estandard *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_estandard_append(const netwox_smbcmdtsc2_fmt_file_estandard *pitem,
                                                       netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_estandard_show(const netwox_smbcmdtsc2_fmt_file_estandard *pitem,
                                                     netwib_buf *pbuf);

/*----*/
typedef struct {
  netwib_uint32 dev;
  netwib_uint32 ino;
} netwox_smbcmdtsc2_fmt_file_einternal;
netwib_err netwox_smbcmdtsc2_fmt_file_einternal_init(netwox_smbcmdtsc2_fmt_file_einternal *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_einternal_setdefault(netwox_smbcmdtsc2_fmt_file_einternal *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_einternal_close(netwox_smbcmdtsc2_fmt_file_einternal *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_einternal_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_einternal *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_einternal_append(const netwox_smbcmdtsc2_fmt_file_einternal *pitem,
                                                       netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_einternal_show(const netwox_smbcmdtsc2_fmt_file_einternal *pitem,
                                                     netwib_buf *pbuf);

/*----*/
typedef struct {
  netwib_uint32 easize;
} netwox_smbcmdtsc2_fmt_file_eea;
netwib_err netwox_smbcmdtsc2_fmt_file_eea_init(netwox_smbcmdtsc2_fmt_file_eea *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eea_setdefault(netwox_smbcmdtsc2_fmt_file_eea *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eea_close(netwox_smbcmdtsc2_fmt_file_eea *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eea_decode(netwib_data *pdata,
                                                 netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_eea *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eea_append(const netwox_smbcmdtsc2_fmt_file_eea *pitem,
                                                 netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_eea_show(const netwox_smbcmdtsc2_fmt_file_eea *pitem,
                                               netwib_buf *pbuf);

/*----*/
typedef struct {
  netwox_smbcmdcmn_uint64 allocationsize;
} netwox_smbcmdtsc2_fmt_file_eallocation;
netwib_err netwox_smbcmdtsc2_fmt_file_eallocation_init(netwox_smbcmdtsc2_fmt_file_eallocation *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eallocation_setdefault(netwox_smbcmdtsc2_fmt_file_eallocation *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eallocation_close(netwox_smbcmdtsc2_fmt_file_eallocation *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eallocation_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_eallocation *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eallocation_append(const netwox_smbcmdtsc2_fmt_file_eallocation *pitem,
                                                        netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_eallocation_show(const netwox_smbcmdtsc2_fmt_file_eallocation *pitem,
                                                    netwib_buf *pbuf);

/*----*/
typedef struct {
  netwox_smbcmdcmn_uint64 filesize;
} netwox_smbcmdtsc2_fmt_file_eeof;
netwib_err netwox_smbcmdtsc2_fmt_file_eeof_init(netwox_smbcmdtsc2_fmt_file_eeof *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eeof_setdefault(netwox_smbcmdtsc2_fmt_file_eeof *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eeof_close(netwox_smbcmdtsc2_fmt_file_eeof *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eeof_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_eeof *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eeof_append(const netwox_smbcmdtsc2_fmt_file_eeof *pitem,
                                                  netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_eeof_show(const netwox_smbcmdtsc2_fmt_file_eeof *pitem,
                                                netwib_buf *pbuf);

/*----*/
typedef struct {
  netwox_smbcmdcmn_uint64 streamsize;
  netwox_smbcmdcmn_uint64 allocationsize;
  netwox_smbcmdcmn_data name;
} netwox_smbcmdtsc2_fmt_file_estream;
netwib_err netwox_smbcmdtsc2_fmt_file_estream_init(netwox_smbcmdtsc2_fmt_file_estream *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_estream_setdefault(netwox_smbcmdtsc2_fmt_file_estream *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_estream_close(netwox_smbcmdtsc2_fmt_file_estream *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_estream_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_estream *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_estream_size(netwox_smbcmdtsc2_fmt_file_estream *pitem,
                                                   netwib_uint32 *psize);
netwib_err netwox_smbcmdtsc2_fmt_file_estream_append(const netwox_smbcmdtsc2_fmt_file_estream *pitem,
                                                     netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_estream_show(const netwox_smbcmdtsc2_fmt_file_estream *pitem,
                                                   netwib_buf *pbuf);

/*----*/
typedef struct {
  netwib_uint32 mode; /* ?, 16 or 32 */
  netwib_uint32 unknown; /* ?, always 0 */
} netwox_smbcmdtsc2_fmt_file_eattributetag;
netwib_err netwox_smbcmdtsc2_fmt_file_eattributetag_init(netwox_smbcmdtsc2_fmt_file_eattributetag *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eattributetag_setdefault(netwox_smbcmdtsc2_fmt_file_eattributetag *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eattributetag_close(netwox_smbcmdtsc2_fmt_file_eattributetag *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eattributetag_decode(netwib_data *pdata,
                             netwib_uint32 *pdatasize,
                             netwox_smbcmdtsc2_fmt_file_eattributetag *pitem);
netwib_err netwox_smbcmdtsc2_fmt_file_eattributetag_append(const netwox_smbcmdtsc2_fmt_file_eattributetag *pitem,
                                                           netwib_buf *pbuf);
netwib_err netwox_smbcmdtsc2_fmt_file_eattributetag_show(const netwox_smbcmdtsc2_fmt_file_eattributetag *pitem,
                                                         netwib_buf *pbuf);
