#ifndef FILE_PDE
#define FILE_PDE

/*********************************************************************/
/* File:   pde.hh                                                    */
/* Author: Joachim Schoeberl                                         */
/* Date:   08. Jul. 2000                                             */
/*********************************************************************/

#ifdef GNU_PRE3
#define ios_base ios
#endif

/** 
   Description of partial differential equation
*/
class PDE
{
  ///
  const MeshAccess & ma;

  ///
  string geometryfilename;
  ///
  string meshfilename;
  ///
  SymbolTable<double> constants;
  ///
  SymbolTable<double> variables;
  ///
  SymbolTable<CoefficientFunction*> coefficients;
  ///
  SymbolTable<FESpace*> spaces;
  ///
  SymbolTable<GridFunction*> gridfunctions;
  ///
  SymbolTable<BilinearForm*> bilinearforms;
  ///
  //  SymbolTable<BEMBilinearForm*> bembilinearforms;
  ///
  SymbolTable<LinearForm*> linearforms;
  ///
  SymbolTable<Preconditioner*> preconditioners;
  ///
  SymbolTable<NumProc*> numprocs;
  
  ///
  int levelsolved;
public:
  ///
  PDE(const MeshAccess & ama);
  ///
  ~PDE();

  ///
  void LoadPDE (const string & filename);
  ///
  void SavePDE (const string & filename);

  ///
  void SaveSolution (const string & filename);
  ///
  void LoadSolution (const string & filename);
  ///
  void SolveBVP ();

  ///
  void PrintReport (ostream & ost);

  ///
  void PrintMemoryUsage (ostream & ost);

  ///
  const MeshAccess & GetMeshAccess() const
  { return ma; }
  


  ///
  bool ConstantUsed (const string & aname) const;
  ///
  double GetConstant (const string & aname, bool opt = 0) const;
  ///
  bool VariableUsed (const string & aname) const;
  ///
  double & GetVariable (const string & aname, bool opt = 0);
  ///
  CoefficientFunction * GetCoefficientFunction (const string & name, bool opt = 0);

  ///
  FESpace * GetFESpace (const string & name, bool opt = 0);

  ///
  GridFunction * GetGridFunction (const string & name, bool opt = 0);

  ///
  BilinearForm * GetBilinearForm (const string & name, bool opt = 0);

  ///
  //  BEMBilinearForm * GetBEMBilinearForm (const string & name, bool opt = 0);

  ///
  LinearForm * GetLinearForm (const string & name, bool opt = 0);

  ///
  Preconditioner * GetPreconditioner (const string & name, bool opt = 0);

  ///
  NumProc * GetNumProc (const string & name, bool opt = 0);

  ///
  const CoefficientFunction * GetCoefficientFunction (const string & name, bool opt = 0) const;

  ///
  const FESpace * GetFESpace (const string & name, bool opt = 0) const;

  ///
  const GridFunction * GetGridFunction (const string & name, bool opt = 0) const;

  ///
  const BilinearForm * GetBilinearForm (const string & name, bool opt = 0) const;

  ///
  //  const BEMBilinearForm * GetBEMBilinearForm (const string & name, bool opt = 0) const;

  ///
  const LinearForm * GetLinearForm (const string & name, bool opt = 0) const;

  ///
  const Preconditioner * GetPreconditioner (const string & name, bool opt = 0) const;

  ///
  const NumProc * GetNumProc (const string & name, bool opt = 0) const;





  ///
  void AddConstant (const string & name, double val);
  ///
  void AddVariable (const string & name, double val);
  ///
  void AddCoefficientFunction (const string & name, CoefficientFunction* fun);
  ///
  FESpace * AddFESpace (const string & name, Flags & flags);
  ///
  GridFunction * AddGridFunction (const string & name, Flags & flags);
  ///
  BilinearForm * AddBilinearForm (const string & name, Flags & flags);
  ///
  void AddBEMElement (const string & name, Flags & flags);
  ///
  LinearForm * AddLinearForm (const string & name, Flags & flags);
  ///
  Preconditioner * AddPreconditioner (const string & name, Flags & flags);
  ///
  void AddNumProc (const string & name, NumProc * np);


  ///
  void AddBilinearFormIntegrator (const string & name, BilinearFormIntegrator * part);
  ///
  void AddLinearFormIntegrator (const string & name, LinearFormIntegrator * part);

  ///
  SymbolTable<double> & GetConstantTable ()
  { return constants; }
  SymbolTable<double> & GetVariableTable ()
  { return variables; }
  ///
  SymbolTable<CoefficientFunction*> & GetCoefficientTable ()
  { return coefficients; }
  ///
  SymbolTable<FESpace*> & GetSpaceTable ()
    { return spaces; }
  ///
  SymbolTable<GridFunction*> & GetGridFunctionTable()
    { return gridfunctions; }
  ///
  SymbolTable<BilinearForm*> & GetBilinearFormTable()
    { return bilinearforms; }
  ///
  SymbolTable<LinearForm*> & GetLinearFormTable()
    { return linearforms; }
  ///
  SymbolTable<Preconditioner*> & GetPreconditionerTable ()
    { return preconditioners; }
  ///
  SymbolTable<NumProc*> & GetNumProcTable()
    { return numprocs; }  

  /// a hack 
  Tcl_Interp * tcl_interpreter;
};


#endif
