#
#
geometry = ngsolve/pde_tutorial/beam.geo
mesh = ngsolve/pde_tutorial/beam_hp.vol

define constant heapsize = 100000000

define coefficient E
1,

define coefficient nu
0.2,

define coefficient rho
1

define coefficient penalty
1e6, 0, 0, 0, 0, 0

define coefficient coef_force
5e-5, 

define fespace v -dim=3 -order=5 -eliminate_internal -augmented=1
define fespace vp -dim=6  -order=5

define gridfunction u -fespace=v
define gridfunction stress -fespace=vp

define linearform f -fespace=v
source coef_force -comp=3 

define bilinearform a -fespace=v -symmetric  -eliminate_internal -linearform=f 
elasticity E nu
robin penalty  -comp=1
robin penalty  -comp=2
robin penalty  -comp=3

# define bilinearform m -fespace=v 
# sysmass rho



# define preconditioner c -type=direct -bilinearform=a -notest
define preconditioner c -type=multigrid -bilinearform=a -notest
# define preconditioner c -type=local -bilinearform=a -block


numproc bvp np1 -bilinearform=a -linearform=f -gridfunction=u -preconditioner=c -maxsteps=200

# numproc evp np1 -bilinearforma=a -bilinearformm=m  -gridfunction=u -preconditioner=c
numproc calcflux np2 -bilinearform=a -solution=u -flux=stress -applyd
# numproc drawflux np2b -bilinearform=a -solution=u -label=drawstress
# numproc zzerrorestimator np3 -bilinearform=a -linearform=f -solution=u -flux=p -minlevel=0
