
template <class T> class VFlatVector;
template <class T> class VVector;

/**
   The T_BaseVector specifies the type of the vector element
 */
template <typename T = double>
class T_BaseVector : public S_BaseVector<typename mat_traits<T>::TSCAL>
{
public:
  typedef T TELEM;
  typedef typename mat_traits<T>::TSCAL TSCAL;

  //  T_BaseVector () throw () { ; }
  //  virtual ~T_BaseVector() throw () { ; }


  FlatVector<T> FV () const throw()
  {
    return FlatVector<T> (this->size, this->Memory());
  }

  FlatVector<T> FV () throw()
  {
    return FlatVector<T> (this->size, this->Memory());
  }


  FlatVector<T> FV (const BaseVector & v2) const
  {
    return FlatVector<T> (v2.Size(), v2.Memory());
  }

  virtual TempVector Range (int begin, int end)
  {
    return TempVector (new VFlatVector<T> (end-begin, &FV()[0]+begin));
  }
  
  virtual TempVector Range (int begin, int end) const
  {
    return TempVector (new VFlatVector<T> (end-begin, &FV()[0]+begin));
  }
  
  virtual BaseVector * CreateVector () const
  {
    return new VVector<T> (this->size);
  }
  
  virtual ostream & Print (ostream & ost) const
  {
    ost << "addr = " << &FV()(0) << endl;
    return (ost << FV() << endl);
  }

};




/**
   A specific vector based on Vector.
 */
template <typename T = double>
class VFlatVector : public T_BaseVector<T>
{
  // int s;
  T * data;
public:
  typedef typename mat_traits<T>::TSCAL TSCAL;

  explicit VFlatVector (int as, T * adata) throw(); 
  explicit VFlatVector () throw();
  virtual ~VFlatVector() throw();

  /*
  virtual FlatVector<T> FV () const throw();
  virtual FlatVector<T> FV () throw();
  */

  virtual void * Memory () const throw()
    { return data; }

  void AssignMemory (int as, void * adata)
  {
    this->size = as; data = static_cast<T*> (adata); 
  }

  VFlatVector & operator= (TSCAL s1)
  {
    BaseVector::operator= (s1);
    return *this;
  }

  template <typename T2>
  VFlatVector & operator= (const VVecExpr<T2> & v)
  {
    BaseVector::operator= (v);
    return *this;
  }
};



/**
   A specific vector based on Vector.
 */
template <typename T = double>
class VVector : public T_BaseVector<T>
{
  // int s;
  //  T * data;
  MoveableMem<T> data;
public:
  typedef typename mat_traits<T>::TSCAL TSCAL;

  explicit VVector (int as);

  virtual ~VVector() throw();

  /*
  virtual FlatVector<T> FV () const throw();
  virtual FlatVector<T> FV () throw();
  */

  virtual void * Memory () const throw()
    { return const_cast<void*> (static_cast<const void*> (&data[0])); }

  void SetSize(int as);

  VVector & operator= (TSCAL s1)
  {
    BaseVector::operator= (s1);
    return *this;
  }

  VVector & operator= (const VVector & v2)
  {
    BaseVector::operator= (v2);
    return *this;
  }

  // hierarchical EE
  T & operator() (int i)
  {
    return data[i];
  }
  const T & operator() (int i) const
  {
    return data[i];
  }


  template <typename T2>
  VVector & operator= (const VVecExpr<T2> & v)
  {
    BaseVector::operator= (v);
    return *this;
  }

};




