#ifndef FILE_NGS_SPECIALMATRIX
#define FILE_NGS_SPECIALMATRIX

/* ************************************************************************/
/* File:   special_matrix.hpp                                             */
/* Author: Joachim Schoeberl                                              */
/* Date:   14 Mar. 02                                                     */
/* ************************************************************************/



template <class TVR, class TVC>
class Real2ComplexMatrix : public BaseMatrix
{
  const BaseMatrix * realmatrix;
  VVector<TVR> hx, hy;
public:
  Real2ComplexMatrix (const BaseMatrix * arealmatrix = 0);
  void SetMatrix (const BaseMatrix * arealmatrix);
  const BaseMatrix & GetMatrix () const { return *realmatrix; }
  virtual void MultAdd (double s, const BaseVector & x, BaseVector & y) const;
  virtual void MultAdd (Complex s, const BaseVector & x, BaseVector & y) const;
};




////////////////////////////////////////////////////////////////////////////////
// added 08/19/2003
template <class TVR>
class Sym2NonSymMatrix : public BaseMatrix
{
  const BaseMatrix * base;
  VVector<TVR> hx, hy;
public:
  Sym2NonSymMatrix (const BaseMatrix * abasematrix = 0);
  void SetMatrix (const BaseMatrix * abasematrix);
  const BaseMatrix & GetMatrix () const { return *base; }
  virtual void MultAdd (double s, const BaseVector & x, BaseVector & y) const;
  //  virtual void MultAdd (Complex s, const BaseVector & x, BaseVector & y) const;
};



////////////////////////////////////////////////////////////////////////////////
// added 09/02/2003
template <class TVSMALL, class TVBIG>
class Small2BigNonSymMatrix : public BaseMatrix
{
  const BaseMatrix * base;
  VVector<TVSMALL> hx1, hx2, hy1, hy2;
public:
  Small2BigNonSymMatrix (const BaseMatrix * abasematrix = 0);
  void SetMatrix (const BaseMatrix * abasematrix);
  const BaseMatrix & GetMatrix () const { return *base; }
  virtual void MultAdd (double s, const BaseVector & x, BaseVector & y) const;
  //  virtual void MultAdd (Complex s, const BaseVector & x, BaseVector & y) const;
  virtual void MultTransAdd (double s, const BaseVector & x, BaseVector & y) const;
};


#endif
