/*********************************************************************/
/* File:   bdbequations.cpp                                          */
/* Author: Joachim Schoeberl                                         */
/* Date:   10. Feb. 2002                                             */
/*********************************************************************/
  
/*  
   Finite Element Integrators 
*/
 
#include <fem.hpp>
  
namespace ngfem
{
  using namespace ngfem;
  


  template <int D>  MassIntegrator<D> :: 
  MassIntegrator (CoefficientFunction * coeff)
    : T_BDBIntegrator<DiffOpId<D>, DiagDMat<1>, NodalFiniteElement> (DiagDMat<1> (coeff))
  { ; }



  template <int D> RobinIntegrator<D> ::
  RobinIntegrator (CoefficientFunction * coeff)
    : T_BDBIntegrator<DiffOpIdBoundary<D>, DiagDMat<1>, NodalFiniteElement> (DiagDMat<1> (coeff))
  { ; }


  template class MassIntegrator<1>;
  template class MassIntegrator<2>;
  template class MassIntegrator<3>;

  template class RobinIntegrator<2>;
  template class RobinIntegrator<3>;


  // standard integratos:
  
  namespace {
    class Init
    { 
    public: 
      Init ();
    };        
    
    Init::Init()
    {
      GetIntegrators().AddBFIntegrator ("laplace", 2, 1,
					LaplaceIntegrator<2>::Create);
      GetIntegrators().AddBFIntegrator ("laplace", 3, 1,
					LaplaceIntegrator<3>::Create);
      GetIntegrators().AddBFIntegrator ("rotsymlaplace", 2, 1,
					RotSymLaplaceIntegrator<2>::Create);
      GetIntegrators().AddBFIntegrator ("ortholaplace", 2, 2,
					OrthoLaplaceIntegrator<2>::Create);
      
      GetIntegrators().AddBFIntegrator ("mass", 2, 1,
					MassIntegrator<2>::Create);
      GetIntegrators().AddBFIntegrator ("mass", 3, 1,
					MassIntegrator<3>::Create);
      GetIntegrators().AddBFIntegrator ("divdiv", 2, 1,
					DivDivIntegrator<2>::Create);
      GetIntegrators().AddBFIntegrator ("curlcurl", 2, 1,
					CurlCurlIntegrator<>::Create);
      GetIntegrators().AddBFIntegrator ("curlcurl", 3, 1,
					CurlCurl3dIntegrator<>::Create);


      GetIntegrators().AddBFIntegrator ("robin", 2, 1,
					RobinIntegrator<2>::Create);
      GetIntegrators().AddBFIntegrator ("robin", 3, 1,
					RobinIntegrator<3>::Create);
      GetIntegrators().AddBFIntegrator ("laplaceboundary", 2, 1,
					LaplaceBoundaryIntegrator<2>::Create);
      GetIntegrators().AddBFIntegrator ("laplaceboundary", 3, 1,
					LaplaceBoundaryIntegrator<3>::Create);

      GetIntegrators().AddBFIntegrator ("normalrobin", 2, 1,
					NormalRobinIntegrator<2>::Create);
      GetIntegrators().AddBFIntegrator ("normalrobin", 3, 1,
					NormalRobinIntegrator<3>::Create);
      
      GetIntegrators().AddBFIntegrator ("elasticity", 2, 2,
					ElasticityIntegrator<2>::Create);
      GetIntegrators().AddBFIntegrator ("elasticity", 3, 2,
					ElasticityIntegrator<3>::Create);
      
      GetIntegrators().AddBFIntegrator ("orthoelasticity", 2, 9,
					OrthotropicElasticityIntegrator<2>::Create);
      GetIntegrators().AddBFIntegrator ("orthoelasticity", 3, 9,
					OrthotropicElasticityIntegrator<3>::Create);
      

      GetIntegrators().AddBFIntegrator ("dirichletpenalty", 3, 1,
					DirichletPenaltyIntegrator<3>::Create);
      GetIntegrators().AddBFIntegrator ("dirichletpenalty", 2, 1,
					DirichletPenaltyIntegrator<2>::Create);



      GetIntegrators().AddLFIntegrator ("source", 2, 1,
					SourceIntegrator<2>::Create);
      GetIntegrators().AddLFIntegrator ("source", 3, 1,
					SourceIntegrator<3>::Create);
      GetIntegrators().AddLFIntegrator("gradsource", 3,3, 
				       GradSourceIntegrator<3>::Create); 

      GetIntegrators().AddLFIntegrator ("neumann", 2, 1,
					NeumannIntegrator<2>::Create);
      GetIntegrators().AddLFIntegrator ("neumann", 3, 1,
					NeumannIntegrator<3>::Create);
    }
    
    Init init;
    
  }
 
}
