/* private.c
  
   libpbuild private functions.

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect (nexp)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "pbuild-priv.h"

/*
 * Retrieves the data pointer in a parameter node given the parameter name.
 */
void *
_pb_pdata(const GNode *pdu, const char *fname)
{
    const GNode *child;
    struct node_data *node_data;

    for (child = g_node_first_child(pdu);
	 child;
	 child = g_node_next_sibling(child) ) {
	node_data = child->data;

	if (!strcmp(node_data->name, fname) )
	    return node_data->type == PDU_NODE_PARM
		   ? node_data->_data_parm.data : NULL;
    }

    return NULL;
}

const GNode *
_pb_findnode(const GNode *pdu, const char *pdu_name)
{
    const GNode *child;
    struct node_data *node_data;

    for (child = g_node_first_child(pdu);
	 child;
	 child = g_node_next_sibling(child) ) {
	node_data = child->data;

	if (!strcmp(node_data->name, pdu_name) )
	    return child;
    }

    return NULL;
}

/*
 * Given a node in a PDU tree, find the parent PDU node.
 */
const GNode *
_pb_parent_pdu(const GNode *node)
{
    if (!node->parent)
	/*
	 * If the node doesn't have a parent then the node itself
	 * is the parent! :-)
	 */
	return node;

    while ( (node = node->parent)
	   && ( (struct node_data *) node->data)->type != PDU_NODE_PDU);

    return node;
}
