#ifndef _NEXP_CMD_PARSER_H
#define _NEXP_CMD_PARSER_H

/* nexp_cmd_parser.h
   
   Definitions from the Network Expect command parser.

   Copyright (C) 2007, 2008 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

enum cmd_codes {
    CMD_SHOW_VERSION,
    CMD_SHOW_DISSECTION_VARS,
    CMD_SHOW_PACKET,
    CMD_SHOW_GHOSTS,
    CMD_GHOST_CREATE,
    CMD_GHOST_INFO,
    CMD_GHOST_KILL
};

/*
 * Command description block. Used to pass information from the command
 * parser to the command functions.
 */
struct cdb {
    enum cmd_codes code;

    union {
	/* Arguments for the "ghost" command */
	struct {
	    char *name;
	    struct addr l2addr;
	    struct addr l3addr;
	    char *iface;
	} __ghost;
    } __args_u;
};

#define _ghost __args_u.__ghost

extern int cmd_parseargs(Tcl_Interp *, const char *, struct cdb *);

#endif /* _NEXP_CMD_PARSER_H */
