/*

Copyright (C) 2000, 2001 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __nd_arp_h
#define __nd_arp_h

#include <net/ethernet.h>
#include <net/if_arp.h>

#include <netdude/nd_gettext.h>
#include <netdude/nd_packet.h>
#include <netdude/nd_trace.h>
#include <netdude/nd_protocol.h>

extern ND_MenuData arp_menu_hrd_data[];
extern ND_MenuData arp_menu_op_data[];

/* These are the implementations of ND_Protocol's callbacks: */
GtkWidget *nd_arp_create_gui(ND_Trace *trace, ND_ProtoInfo *pinf);
void       nd_arp_set_gui(const ND_Packet *packet, ND_ProtoInfo *pinf);
void       nd_arp_init_packet(ND_Packet *packet, guchar *data, guchar *data_end);
gboolean   nd_arp_header_complete(const ND_Packet *packet, guint nesting);

/* Generic accessor function for the protocol implementation: */
ND_Protocol *nd_arp_get(void);

/* Helper functions to set a trace's GUI table to a packet's content: */
void       nd_arp_set_gui_hrd(ND_ProtoInfo *pinfo, struct arphdr *arphdr);
void       nd_arp_set_gui_pro(ND_ProtoInfo *pinfo, struct arphdr *arphdr);
void       nd_arp_set_gui_hln(ND_ProtoInfo *pinfo, struct arphdr *arphdr);
void       nd_arp_set_gui_pln(ND_ProtoInfo *pinfo, struct arphdr *arphdr);
void       nd_arp_set_gui_op(ND_ProtoInfo *pinfo, struct arphdr *arphdr);

void       nd_arp_set_gui_addresses(ND_ProtoInfo *pinfo,
				    struct arphdr *arphdr,
				    const ND_Packet *packet);

#endif
