/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer.dot;

import java.awt.geom.Point2D;
import net.claribole.zgrviewer.dot.DotUtils;
import net.claribole.zgrviewer.dot.Graph;
import net.claribole.zgrviewer.dot.Node;
import net.claribole.zgrviewer.dot.Point;

abstract class CommonNode
extends Node {
    String group = "";
    boolean fixedsize = false;
    String tooltip = "";
    double rotate = 0.0;
    double z = 0.0;
    double height = 0.5;
    double width = 0.75;
    boolean pin = false;
    int showboxes = 0;
    Point2D.Double[] vertices;
    Point2D.Double margin = new Point2D.Double(0.11, 0.055);
    Point pos;
    String[] layer;

    CommonNode(Object root, String id) throws Exception {
        super(root, id);
    }

    protected void changeOption(String name, String value) throws Exception {
        try {
            super.changeOption(name, value);
        }
        catch (Exception e) {
            String v = value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' ? value.substring(1, value.length() - 1) : value;
            v = v.replaceAll("\\\\\\n", "");
            if (name.equals("fixedsize")) {
                this.fixedsize = DotUtils.readBoolean(v);
            }
            if (name.equals("group")) {
                this.group = v;
            }
            if (name.equals("height")) {
                this.height = DotUtils.readDouble(v);
            }
            if (name.equals("layer")) {
                this.layer = v.split(((Graph)this.root).layersep);
            }
            if (name.equals("margin")) {
                this.margin = DotUtils.readPointf(v);
            }
            if (name.equals("pin")) {
                this.pin = DotUtils.readBoolean(v);
            }
            if (name.equals("pos")) {
                this.pos = DotUtils.readPoint(v);
            }
            if (name.equals("rotate") || name.equals("orientation")) {
                this.rotate = DotUtils.readDouble(v);
            }
            if (name.equals("showboxes")) {
                this.showboxes = DotUtils.readInteger(v);
            }
            if (name.equals("tooltip")) {
                this.tooltip = v;
            }
            if (name.equals("vertices")) {
                this.vertices = DotUtils.readPointfList(v);
            }
            if (name.equals("width")) {
                this.width = DotUtils.readDouble(v);
            }
            if (name.equals("z")) {
                this.z = DotUtils.readDouble(v);
            }
            throw new Exception("CommonNode attribute \"" + name + "\" does not exist");
        }
    }

    protected String nodeOptions() {
        String o = super.nodeOptions();
        if (!this.group.equals("")) {
            o = o + this.printOption("group", this.group);
        }
        if (this.fixedsize) {
            o = o + this.printOption("fixedsize", this.fixedsize);
        }
        if (!this.tooltip.equals("")) {
            o = o + this.printOption("tooltip", this.tooltip);
        }
        if (this.rotate != 0.0) {
            o = o + this.printOption("orientation", this.rotate);
        }
        if (this.z != 0.0) {
            o = o + this.printOption("z", this.z);
        }
        if (this.height != 0.5) {
            o = o + this.printOption("height", this.height);
        }
        if (this.width != 0.75) {
            o = o + this.printOption("width", this.width);
        }
        if (this.pin) {
            o = o + this.printOption("pin", this.pin);
        }
        if (this.showboxes != 0) {
            o = o + this.printOption("showboxes", this.showboxes);
        }
        if (this.vertices != null) {
            o = o + this.printOption("vertices", this.vertices);
        }
        if (this.margin.x != 0.11 || this.margin.y != 0.055) {
            o = o + this.printOption("margin", this.margin);
        }
        if (this.pos != null) {
            o = o + this.printOption("pos", this.pos);
        }
        if (this.layer != null) {
            o = o + this.printOption("layer", this.layer);
        }
        return o;
    }

    private String printOption(String attribute, String[] value) {
        String ret = attribute + "=\"";
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                ret = ret + " ";
            }
            ret = ret + value[i];
        }
        return ret + "\" ";
    }

    private String printOption(String attribute, Point2D.Double value) {
        return attribute + "=" + this.printPoint2DOption(value) + " ";
    }

    private String printPoint2DOption(Point2D.Double value) {
        return "\"" + value.x + "," + value.y + "\"";
    }

    private String printOption(String attribute, Point2D.Double[] value) {
        String o = attribute + "=";
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                o = o + " ";
            }
            o = o + this.printPoint2DOption(value[i]);
        }
        return o;
    }

    private String printOption(String attribute, Point value) {
        String o = attribute + "=\"";
        for (int i = 0; i < value.coords.length; ++i) {
            if (i > 0) {
                o = o + ",";
            }
            o = o + value.coords[i];
        }
        return o + "\"" + (value.change ? "" : "!") + " ";
    }
}

