/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import com.xerox.VTM.engine.SwingWorker;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.svg.SVGWriter;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.DOTManager;
import net.claribole.zgrviewer.GVLoader;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.Messages;
import net.claribole.zgrviewer.PNGExportWindow;
import net.claribole.zgrviewer.PrefWindow;
import net.claribole.zgrviewer.PrintWindow;
import net.claribole.zgrviewer.SearchBox;
import net.claribole.zgrviewer.TextViewer;
import net.claribole.zgrviewer.Utils;
import net.claribole.zgrviewer.WebBrowser;
import net.claribole.zgrviewer.ZGRApplication;
import net.claribole.zgrviewer.ZgrvEvtHdlr;
import net.claribole.zvtm.glyphs.PieMenu;
import net.claribole.zvtm.glyphs.PieMenuFactory;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class ZGRViewer
implements ZGRApplication {
    static ConfigManager cfgMngr;
    static DOTManager dotMngr;
    public GVLoader gvLdr;
    public GraphicsManager grMngr;
    ZgrvEvtHdlr meh;
    static File cmdLineDOTFile;
    static String cmdLinePrg;
    PieMenu mainPieMenu;
    PieMenu subPieMenu;
    static final String CURRENT_VERSION_URL = "http://zvtm.sourceforge.net/zgrviewer/currentVersion";

    ZGRViewer(int acc) {
        this.initConfig();
        this.initGUI(acc);
        if (cmdLineDOTFile != null) {
            this.loadCmdLineFile();
        }
    }

    void loadCmdLineFile() {
        if (cmdLinePrg != null) {
            if (cmdLinePrg.equals("-Pneato")) {
                this.gvLdr.loadFile(cmdLineDOTFile, (short)1, false);
            } else if (cmdLinePrg.equals("-Pdot")) {
                this.gvLdr.loadFile(cmdLineDOTFile, (short)0, false);
            } else if (cmdLinePrg.equals("-Pcirco")) {
                this.gvLdr.loadFile(cmdLineDOTFile, (short)2, false);
            } else if (cmdLinePrg.equals("-Ptwopi")) {
                this.gvLdr.loadFile(cmdLineDOTFile, (short)3, false);
            } else if (cmdLinePrg.equals("-Psvg")) {
                this.gvLdr.loadSVG(cmdLineDOTFile);
            } else {
                System.err.println("Bad option: " + cmdLinePrg + "\n\t" + "Only -Pdot, -Pneato, -Pcirco, -Ptwopi and -Psvg are allowed");
                System.exit(0);
            }
        } else if (cmdLineDOTFile.toString().endsWith(".svg")) {
            this.gvLdr.loadSVG(cmdLineDOTFile);
        } else {
            this.gvLdr.loadFile(cmdLineDOTFile, (short)0, false);
        }
    }

    void initConfig() {
        this.grMngr = new GraphicsManager(this);
        cfgMngr = new ConfigManager(this.grMngr, false);
        dotMngr = new DOTManager(this.grMngr, cfgMngr);
        this.grMngr.setConfigManager(cfgMngr);
        this.gvLdr = new GVLoader(this, this.grMngr, cfgMngr, dotMngr);
        cfgMngr.loadConfig();
        cfgMngr.initPlugins(this);
    }

    void initGUI(int acc) {
        Utils.initLookAndFeel();
        JMenuBar jmb = this.initViewMenu(acc);
        this.grMngr.createFrameView(this.grMngr.createZVTMelements(false), acc, jmb);
        this.grMngr.parameterizeView(new ZgrvEvtHdlr(this, this.grMngr));
    }

    JMenuBar initViewMenu(int accelerationMode) {
        JMenu open = new JMenu("Open");
        JMenu openD = new JMenu("Open with dot...");
        JMenu openN = new JMenu("Open with neato...");
        JMenu openC = new JMenu("Open with circo...");
        JMenu openT = new JMenu("Open with twopi...");
        final JMenuItem openO = new JMenuItem("Open with...");
        openO.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final JMenuItem openDG = new JMenuItem("SVG pipeline (standard)...");
        openDG.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final JMenuItem openNG = new JMenuItem("SVG pipeline (standard)...");
        openNG.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final JMenuItem openDI = new JMenuItem("DOT pipeline (experimental)...");
        final JMenuItem openNI = new JMenuItem("DOT pipeline (experimental)...");
        final JMenuItem openCG = new JMenuItem("SVG pipeline (standard)...");
        final JMenuItem openCI = new JMenuItem("DOT pipeline (experimental)...");
        final JMenuItem openTG = new JMenuItem("SVG pipeline (standard)...");
        final JMenuItem openTI = new JMenuItem("DOT pipeline (experimental)...");
        final JMenuItem openS = new JMenuItem("Open SVG generated by GraphViz...");
        final JMenuItem reloadI = new JMenuItem("Reload current file");
        reloadI.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final JMenuItem pngI = new JMenuItem("Export to PNG (current view)...");
        final JMenuItem svgI = new JMenuItem("Export to SVG...");
        final JMenuItem printI = new JMenuItem("Print (current view)...");
        final JMenuItem exitI = new JMenuItem("Exit");
        printI.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final JMenuItem backI = new JMenuItem("Back");
        backI.setAccelerator(KeyStroke.getKeyStroke(66, 0));
        final JMenuItem globvI = new JMenuItem("Global View");
        globvI.setAccelerator(KeyStroke.getKeyStroke(71, 0));
        final JMenuItem radarI = new JMenuItem("Overview");
        radarI.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final JMenuItem searchI = new JMenuItem("Find...");
        searchI.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        final JMenuItem fontI = new JMenuItem("Set Font...");
        final JMenuItem prefsI = new JMenuItem("Preferences...");
        final JMenuItem helpI = new JMenuItem("Commands...");
        final JMenuItem versionI = new JMenuItem("Check for updates...");
        final JMenuItem aboutI = new JMenuItem("About...");
        exitI.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        ActionListener a0 = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == openDG) {
                    ZGRViewer.this.gvLdr.open((short)0, false);
                } else if (e.getSource() == openNG) {
                    ZGRViewer.this.gvLdr.open((short)1, false);
                } else if (e.getSource() == openDI) {
                    ZGRViewer.this.gvLdr.open((short)0, true);
                } else if (e.getSource() == openNI) {
                    ZGRViewer.this.gvLdr.open((short)1, true);
                } else if (e.getSource() == openCG) {
                    ZGRViewer.this.gvLdr.open((short)2, false);
                } else if (e.getSource() == openCI) {
                    ZGRViewer.this.gvLdr.open((short)2, true);
                } else if (e.getSource() == openTG) {
                    ZGRViewer.this.gvLdr.open((short)3, false);
                } else if (e.getSource() == openTI) {
                    ZGRViewer.this.gvLdr.open((short)3, true);
                } else if (e.getSource() == openS) {
                    ZGRViewer.this.gvLdr.openSVGFile();
                } else if (e.getSource() == openO) {
                    ZGRViewer.this.gvLdr.openOther();
                } else if (e.getSource() == reloadI) {
                    ZGRViewer.this.gvLdr.reloadFile();
                } else if (e.getSource() == globvI) {
                    ZGRViewer.this.grMngr.getGlobalView();
                } else if (e.getSource() == radarI) {
                    ZGRViewer.this.grMngr.showRadarView(true);
                } else if (e.getSource() == searchI) {
                    ZGRViewer.this.showSearchBox();
                } else if (e.getSource() == backI) {
                    ZGRViewer.this.grMngr.moveBack();
                } else if (e.getSource() == fontI) {
                    ZGRViewer.this.grMngr.assignFontToGraph();
                } else if (e.getSource() == pngI) {
                    ZGRViewer.this.savePNG();
                } else if (e.getSource() == svgI) {
                    ZGRViewer.this.saveSVG();
                } else if (e.getSource() == printI) {
                    ZGRViewer.this.print();
                } else if (e.getSource() == prefsI) {
                    ZGRViewer.this.showPreferences();
                } else if (e.getSource() == exitI) {
                    ZGRViewer.this.exit();
                } else if (e.getSource() == helpI) {
                    ZGRViewer.this.help();
                } else if (e.getSource() == versionI) {
                    ZGRViewer.this.checkVersion();
                } else if (e.getSource() == aboutI) {
                    ZGRViewer.this.about();
                }
            }
        };
        JMenuBar jmb = new JMenuBar();
        JMenu jm1 = new JMenu("File");
        JMenu jm2 = new JMenu("View");
        JMenu jm3 = new JMenu("Help");
        jmb.add(jm1);
        jmb.add(jm2);
        jmb.add(jm3);
        open.add(openD);
        open.add(openN);
        open.add(openC);
        open.add(openT);
        open.add(openO);
        openD.add(openDG);
        openD.add(openDI);
        openN.add(openNG);
        openN.add(openNI);
        openC.add(openCG);
        openC.add(openCI);
        openT.add(openTG);
        openT.add(openTI);
        open.addSeparator();
        open.add(openS);
        jm1.add(open);
        jm1.add(reloadI);
        jm1.addSeparator();
        jm1.add(pngI);
        jm1.add(svgI);
        jm1.addSeparator();
        jm1.add(printI);
        jm1.addSeparator();
        jm1.add(exitI);
        jm2.add(backI);
        jm2.add(globvI);
        jm2.add(radarI);
        jm2.addSeparator();
        jm2.add(searchI);
        jm2.addSeparator();
        jm2.add(fontI);
        jm2.addSeparator();
        jm2.add(prefsI);
        jm3.add(helpI);
        jm3.add(versionI);
        jm3.add(aboutI);
        openDG.addActionListener(a0);
        openDI.addActionListener(a0);
        openNG.addActionListener(a0);
        openNI.addActionListener(a0);
        openCG.addActionListener(a0);
        openCI.addActionListener(a0);
        openTG.addActionListener(a0);
        openTI.addActionListener(a0);
        openS.addActionListener(a0);
        openO.addActionListener(a0);
        reloadI.addActionListener(a0);
        pngI.addActionListener(a0);
        svgI.addActionListener(a0);
        printI.addActionListener(a0);
        exitI.addActionListener(a0);
        globvI.addActionListener(a0);
        radarI.addActionListener(a0);
        searchI.addActionListener(a0);
        backI.addActionListener(a0);
        fontI.addActionListener(a0);
        prefsI.addActionListener(a0);
        helpI.addActionListener(a0);
        versionI.addActionListener(a0);
        aboutI.addActionListener(a0);
        if (accelerationMode == 2) {
            printI.setEnabled(false);
        }
        return jmb;
    }

    void savePNG() {
        final long[] vr = this.grMngr.mainView.getVisibleRegion(this.grMngr.mSpace.getCamera(0));
        SwingWorker sw = new SwingWorker(){

            public Object construct() {
                new PNGExportWindow(vr[2] - vr[0], vr[1] - vr[3], ZGRViewer.this.grMngr);
                return null;
            }
        };
        sw.start();
    }

    void saveSVG() {
        final JFileChooser fc = new JFileChooser(ConfigManager.m_LastExportDir != null ? ConfigManager.m_LastExportDir : ConfigManager.m_PrjDir);
        fc.setDialogTitle("Export SVG");
        int returnVal = fc.showSaveDialog(this.grMngr.mainView.getFrame());
        if (returnVal == 0) {
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    ZGRViewer.this.exportSVG(fc.getSelectedFile());
                    return null;
                }
            };
            worker.start();
        }
    }

    public void exportSVG(File f) {
        if (f != null) {
            this.grMngr.mainView.setCursorIcon(3);
            ConfigManager.m_LastExportDir = f.getParentFile();
            this.setStatusBarText("Exporting to SVG " + f.toString() + " ...");
            if (f.exists()) {
                f.delete();
            }
            SVGWriter svgw = new SVGWriter();
            Document d = svgw.exportVirtualSpace(this.grMngr.vsm.getVirtualSpace("graphSpace"), (DOMImplementation)new DOMImplementationImpl(), f);
            Utils.serialize(d, f);
            this.setStatusBarText("Exporting to SVG " + f.toString() + " ...done");
            this.grMngr.mainView.setCursorIcon(-1);
        }
    }

    public void setStatusBarText(String s) {
        this.grMngr.mainView.setStatusBarText(s);
    }

    void print() {
        final long[] vr = this.grMngr.mainView.getVisibleRegion(this.grMngr.mSpace.getCamera(0));
        SwingWorker sw = new SwingWorker(){

            public Object construct() {
                new PrintWindow(vr[2] - vr[0], vr[1] - vr[3], ZGRViewer.this.grMngr);
                return null;
            }
        };
        sw.start();
    }

    void displayMainPieMenu(boolean b) {
        if (b) {
            PieMenuFactory.setItemFillColor(ConfigManager.PIEMENU_FILL_COLOR);
            PieMenuFactory.setItemBorderColor(ConfigManager.PIEMENU_BORDER_COLOR);
            PieMenuFactory.setSelectedItemFillColor(ConfigManager.PIEMENU_INSIDE_COLOR);
            PieMenuFactory.setSelectedItemBorderColor(null);
            PieMenuFactory.setLabelColor(ConfigManager.PIEMENU_BORDER_COLOR);
            PieMenuFactory.setFont(ConfigManager.PIEMENU_FONT);
            if (Utils.osIsWindows() || Utils.osIsMacOS()) {
                PieMenuFactory.setTranslucency(0.85f);
            }
            PieMenuFactory.setSensitivityRadius(0.5);
            PieMenuFactory.setAngle(-1.5707963267948966);
            PieMenuFactory.setRadius(150L);
            this.mainPieMenu = PieMenuFactory.createPieMenu(Messages.mainMenuLabels, Messages.mainMenuLabelOffsets, 0L, this.grMngr.mainView, this.grMngr.vsm);
            Glyph[] items = this.mainPieMenu.getItems();
            items[0].setType("mpmE");
            items[1].setType("mpmS");
            items[2].setType("mpmE");
            items[3].setType("mpmS");
        } else {
            this.mainPieMenu.destroy(0);
            this.mainPieMenu = null;
        }
    }

    void displaySubMenu(Glyph menuItem, boolean b) {
        if (b) {
            int index = this.mainPieMenu.getItemIndex(menuItem);
            if (index != -1) {
                String label = this.mainPieMenu.getLabels()[index].getText();
                PieMenuFactory.setFont(ConfigManager.PIEMENU_FONT);
                PieMenuFactory.setItemFillColor(ConfigManager.PIEMENU_FILL_COLOR);
                PieMenuFactory.setItemBorderColor(ConfigManager.PIEMENU_BORDER_COLOR);
                PieMenuFactory.setSelectedItemFillColor(ConfigManager.PIEMENU_INSIDE_COLOR);
                PieMenuFactory.setSelectedItemBorderColor(null);
                PieMenuFactory.setSensitivityRadius(1.0);
                if (Utils.osIsWindows() || Utils.osIsMacOS()) {
                    PieMenuFactory.setTranslucency(0.95f);
                }
                PieMenuFactory.setRadius(120L);
                if (label == "File...") {
                    this.subPieMenu = PieMenuFactory.createPieMenu(Messages.fileMenuLabels, Messages.fileMenuLabelOffsets, 0L, this.grMngr.mainView, this.grMngr.vsm);
                    Glyph[] items = this.subPieMenu.getItems();
                    for (int i = 0; i < items.length; ++i) {
                        items[i].setType("mpmE");
                    }
                } else if (label == "Export...") {
                    this.subPieMenu = PieMenuFactory.createPieMenu(Messages.exportMenuLabels, 0L, this.grMngr.mainView, this.grMngr.vsm);
                    Glyph[] items = this.subPieMenu.getItems();
                    for (int i = 0; i < items.length; ++i) {
                        items[i].setType("mpmE");
                    }
                }
            }
        } else {
            this.subPieMenu.destroy(0);
            this.subPieMenu = null;
        }
    }

    void pieMenuEvent(Glyph menuItem) {
        int index = this.mainPieMenu.getItemIndex(menuItem);
        if (index != -1) {
            String label = this.mainPieMenu.getLabels()[index].getText();
            if (label == "Back") {
                this.grMngr.moveBack();
            } else if (label == "Global View") {
                this.grMngr.getGlobalView();
            }
        } else {
            index = this.subPieMenu.getItemIndex(menuItem);
            if (index != -1) {
                String label = this.subPieMenu.getLabels()[index].getText();
                if (label == "Dot (SVG)...") {
                    this.gvLdr.open((short)0, false);
                } else if (label == "Neato (SVG)...") {
                    this.gvLdr.open((short)1, false);
                } else if (label == "Circo (SVG)...") {
                    this.gvLdr.open((short)2, false);
                } else if (label == "Twopi (SVG)...") {
                    this.gvLdr.open((short)3, false);
                } else if (label == "SVG...") {
                    this.gvLdr.openSVGFile();
                } else if (label == "Other (SVG)...") {
                    this.gvLdr.openOther();
                } else if (label == "Export (SVG)...") {
                    this.saveSVG();
                } else if (label == "Export (PNG)...") {
                    this.savePNG();
                } else if (label == "Print...") {
                    this.print();
                }
            }
        }
    }

    void displayURLinBrowser(String uri) {
        if (ConfigManager.webBrowser == null) {
            ConfigManager.webBrowser = new WebBrowser();
        }
        ConfigManager.webBrowser.show(uri, this.grMngr);
    }

    void showPreferences() {
        PrefWindow dp = new PrefWindow(this, this.grMngr);
        dp.setLocationRelativeTo(this.grMngr.mainView.getFrame());
        dp.setVisible(true);
    }

    void showSearchBox() {
        SearchBox sb = new SearchBox(this.grMngr);
        sb.setLocationRelativeTo(this.grMngr.mainView.getFrame());
        sb.setVisible(true);
    }

    public File getLastFileOpened() {
        return ZGRViewer.cfgMngr.lastFileOpened;
    }

    void saveConfiguration() {
        cfgMngr.saveConfig();
    }

    void help() {
        TextViewer tv = new TextViewer(new StringBuffer("Under Mac OS X, replace Ctrl by the Command key\n\nMisc. Commands\n* Press right mouse button to display the pie menu\n\n* Ctrl+D = open a file with dot (SVG pipeline)\n* Ctrl+N = open a file with neato (SVG pipeline)\n* Ctrl+Z = open a file with another program (SVG pipeline)\n* Ctrl+R = Reload current file (SVG pipeline)\n* Ctrl+P = Print current view\n* Ctrl+Q = Exit ZGRViewer\n\nNavigation (left mouse button corresponds to the single button for Mac users)\n* Press left mouse button and drag to move in the graph\n* Hold Shift, press left mouse button and drag vertically to zoom-in/zoom-out\n* Click left mouse button on a node or arc to center on it\n* Hold Alt, press left mouse button and drag to select a region of interest\n* Home (or G) = get a global view of the graph\n* Ctrl+L = (de)activate distortion lens\n* Ctrl+F = pop up search window\n* Page Down = Zoom In\n* Page Up = Zoom Out\n* Mouse wheel =  zoom in/out* Arrow Keys = Translation\n* B = Back to previous location\n* L or Space bar or Middle mouse button = load associated URL in a Web browser\n"), "Commands", 0, false);
        tv.setLocationRelativeTo(this.grMngr.mainView.getFrame());
        tv.setVisible(true);
    }

    public void about() {
        JOptionPane.showMessageDialog(this.grMngr.mainView.getFrame(), "ZGRViewer 0.8.2\n\nA Visualization Tool for GraphViz based on ZVTM\nhttp://zvtm.sourceforge.net/zgrviewer.html\n\nWritten by Emmanuel Pietriga\n(INRIA project In Situ)\nemmanuel.pietriga@inria.fr");
    }

    public void checkVersion() {
        try {
            String version = Utils.getTextContent(new URL(CURRENT_VERSION_URL), 10).trim();
            if (version != null) {
                if (version.equals("0.8.2")) {
                    JOptionPane.showMessageDialog(this.grMngr.mainView.getFrame(), "You have the most recent version of ZGRViewer (0.8.2)", "Version Information", 1);
                } else {
                    JOptionPane.showMessageDialog(this.grMngr.mainView.getFrame(), "A new version of ZGRViewer is available: " + version + "\n" + "http://zvtm.sourceforge.net/zgrviewer.html#download", "Version Information", 1);
                }
            } else {
                JOptionPane.showMessageDialog(this.grMngr.mainView.getFrame(), "Failed to get version information", "Error", 0);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.grMngr.mainView.getFrame(), "Failed to get version information", "Error", 0);
        }
    }

    void exit() {
        cfgMngr.saveCommandLines();
        this.grMngr.paMngr.stop();
        cfgMngr.terminatePlugins();
        System.exit(0);
    }

    public static void main(String[] args) {
        if (Utils.osIsMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        int acceleratedView = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equals("--help")) {
                    System.out.println("\n\njava net.claribole.zgrviewer.ZGRViewer [options] [file]");
                    System.out.println("[options] -volatile ZVTM will run in VolatileImage accelerated mode (requires JDK 1.4 or later)");
                    System.out.println("          -opengl   ZVTM will run in OpenGL accelerated mode (requires JDK 1.5 or later)");
                    System.out.println("          -Pxxx     where xxx={dot, neato, svg} to specify what program to use to compute the [file]'s layout");
                    System.out.println("[file]    can be a relative or full path ; use the native OS syntax\n\n");
                    System.exit(0);
                    continue;
                }
                if (args[i].equals("-opengl")) {
                    System.setProperty("sun.java2d.opengl", "true");
                    System.out.println("OpenGL accelerated mode");
                    acceleratedView = 2;
                    continue;
                }
                if (args[i].equals("-volatile")) {
                    System.out.println("Volatile Image accelerated mode");
                    acceleratedView = 1;
                    continue;
                }
                if (!args[i].startsWith("-P")) continue;
                cmdLinePrg = args[i];
                continue;
            }
            File f = new File(args[i]);
            if (!f.exists()) continue;
            cmdLineDOTFile = f;
        }
        System.out.println("--help for command line options");
        int av = acceleratedView;
        new ZGRViewer(av);
    }

    static {
        cmdLineDOTFile = null;
        cmdLinePrg = null;
    }
}

