/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.lens;

import com.xerox.VTM.engine.AnimManager;
import java.util.Date;
import net.claribole.zvtm.lens.LAnimation;
import net.claribole.zvtm.lens.Lens;

public class LMaximumMagnification
extends LAnimation {
    public float[] steps;

    public LMaximumMagnification(Lens l, AnimManager mgr, long d) {
        this.started = false;
        this.target = l;
        this.parent = mgr;
        this.duration = d;
        this.type = "mm";
    }

    public void start() {
        this.now = new Date();
        this.startTime = this.now.getTime();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animate() {
        if (this.started) {
            this.now = new Date();
            this.progression = (float)(this.now.getTime() - this.startTime) / (float)this.duration;
            this.step = (int)Math.round((double)this.steps.length * this.progression);
            if (this.step < this.steps.length) {
                Lens lens = this.target;
                synchronized (lens) {
                    try {
                        this.target.setMaximumMagnification(this.steps[this.step], false);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        System.err.println("Error while animating lens maximum magnification");
                    }
                }
            }
            Lens lens = this.target;
            synchronized (lens) {
                try {
                    this.target.setMaximumMagnification(this.steps[this.steps.length - 1], false);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    System.err.println("Error while animating lens maximum magnification");
                }
                this.parent.killLAnim(this, this.type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void conclude() {
        this.target.setMaximumMagnification(this.steps[this.steps.length - 1], false);
        if (this.finalRasterSize != -1) {
            Lens lens = this.target;
            synchronized (lens) {
                this.target.setMagRasterDimensions(this.finalRasterSize);
            }
        }
    }

    public void postAnimAction() {
        if (this.paa != null) {
            this.paa.animationEnded(this.target, (short)2, "mm");
        }
    }
}

