/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import net.claribole.zvtm.glyphs.GlyphFactory;
import net.claribole.zvtm.glyphs.GlyphPanel;

class VDiamPanel
extends GlyphPanel
implements MouseMotionListener,
MouseListener {
    Polygon p;

    VDiamPanel(GlyphFactory gfact) {
        super(gfact);
        this.xcoords = new int[4];
        this.ycoords = new int[4];
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.xcoords[0] = (int)Math.round((double)this.cx + (double)this.cs * Math.cos(this.vertexAngle));
        this.xcoords[1] = (int)Math.round((double)this.cx - (double)this.cs * Math.sin(this.vertexAngle));
        this.xcoords[2] = (int)Math.round((double)this.cx - (double)this.cs * Math.cos(this.vertexAngle));
        this.xcoords[3] = (int)Math.round((double)this.cx + (double)this.cs * Math.sin(this.vertexAngle));
        this.ycoords[0] = (int)Math.round((double)this.cy - (double)this.cs * Math.sin(this.vertexAngle));
        this.ycoords[1] = (int)Math.round((double)this.cy - (double)this.cs * Math.cos(this.vertexAngle));
        this.ycoords[2] = (int)Math.round((double)this.cy + (double)this.cs * Math.sin(this.vertexAngle));
        this.ycoords[3] = (int)Math.round((double)this.cy + (double)this.cs * Math.cos(this.vertexAngle));
        this.p = new Polygon(this.xcoords, this.ycoords, 4);
        if (this.alpha > 0.0) {
            if (this.alpha == 1.0) {
                this.g2d.setColor(this.fColor);
                this.g2d.fillPolygon(this.p);
            } else {
                this.g2d.setColor(this.fColor);
                this.g2d.setComposite(this.acST);
                this.g2d.fillPolygon(this.p);
                this.g2d.setComposite(acO);
            }
        }
        this.g2d.setColor(this.bColor);
        this.g2d.drawPolygon(this.p);
        this.g2d.setColor(Color.black);
        if (this.displayIndicators) {
            this.g2d.setStroke(dashed);
            this.g2d.drawOval(this.cx - this.cs, this.cy - this.cs, 2 * this.cs, 2 * this.cs);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.orientDrag(e);
    }

    public void mousePressed(MouseEvent e) {
        int mx = e.getX();
        int my = e.getY();
        this.selectedVertex = this.gf.orientable && GlyphFactory.hasEditableAngle() && this.xorientHandle - 3 <= mx && mx <= this.xorientHandle + 3 && this.yorientHandle - 3 <= my && my <= this.yorientHandle + 3 ? -2 : -1;
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        this.selectedVertex = -1;
        this.gf.setVertexVal(-1.0);
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
        this.setCursor(new Cursor(1));
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

