/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.ClosedShape;
import com.xerox.VTM.glyphs.RectangularShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.projection.ProjRoundRect;

public class VRoundRect
extends ClosedShape
implements RectangularShape {
    public long vw;
    public long vh;
    float ar;
    public ProjRoundRect[] pc;
    public int arcWidth;
    public int arcHeight;

    public VRoundRect() {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0;
        this.vw = 10L;
        this.vh = 10L;
        this.computeSize();
        this.ar = (float)this.vw / (float)this.vh;
        this.orient = 0.0f;
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
        this.arcWidth = 10;
        this.arcHeight = 10;
    }

    public VRoundRect(long x, long y, int z, long w, long h, Color c, int aw, int ah) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vw = w;
        this.vh = h;
        this.computeSize();
        this.ar = this.vw == 0L && this.vh == 0L ? 1.0f : (float)this.vw / (float)this.vh;
        this.orient = 0.0f;
        this.setColor(c);
        this.setBorderColor(Color.black);
        this.arcWidth = aw;
        this.arcHeight = ah;
    }

    public VRoundRect(long x, long y, int z, long w, long h, Color c, Color bc, int aw, int ah) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vw = w;
        this.vh = h;
        this.computeSize();
        this.ar = this.vw == 0L && this.vh == 0L ? 1.0f : (float)this.vw / (float)this.vh;
        this.orient = 0.0f;
        this.setColor(c);
        this.setBorderColor(bc);
        this.arcWidth = aw;
        this.arcHeight = ah;
    }

    public void initCams(int nbCam) {
        this.pc = new ProjRoundRect[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjRoundRect();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjRoundRect[] ta = this.pc;
                this.pc = new ProjRoundRect[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjRoundRect();
            } else {
                System.err.println("VRoundRect:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjRoundRect[1];
            this.pc[0] = new ProjRoundRect();
        } else {
            System.err.println("VRoundRect:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    public float getOrient() {
        return 0.0f;
    }

    public void orientTo(float angle) {
    }

    public float getSize() {
        return this.size;
    }

    public long getWidth() {
        return this.vw;
    }

    public long getHeight() {
        return this.vh;
    }

    void computeSize() {
        this.size = (float)Math.sqrt(Math.pow(this.vw, 2.0) + Math.pow(this.vh, 2.0));
    }

    public void sizeTo(float radius) {
        this.size = radius;
        this.vw = Math.round((double)(this.size * this.ar) / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.vh = Math.round((double)this.size / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setWidth(long w) {
        this.vw = w;
        this.ar = (float)this.vw / (float)this.vh;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setHeight(long h) {
        this.vh = h;
        this.ar = (float)this.vw / (float)this.vh;
        this.computeSize();
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float factor) {
        this.size *= factor;
        this.vw = Math.round((double)(this.size * this.ar) / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.vh = Math.round((double)this.size / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public long[] getBounds() {
        long[] res = new long[]{this.vx - this.vw, this.vy + this.vh, this.vx + this.vw, this.vy - this.vh};
        return res;
    }

    public void setArcWidth(int w) {
        this.arcWidth = w >= 0 ? w : 0;
    }

    public void setArcHeight(int h) {
        this.arcHeight = h >= 0 ? h : 0;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public int getArcHeight() {
        return this.arcHeight;
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return w <= (long)(this.pc[camIndex].cx + this.pc[camIndex].cw) && 0 >= this.pc[camIndex].cx - this.pc[camIndex].cw && h <= (long)(this.pc[camIndex].cy + this.pc[camIndex].ch) && 0 >= this.pc[camIndex].cy - this.pc[camIndex].ch;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return jpx >= this.pc[camIndex].cx - this.pc[camIndex].cw && jpx <= this.pc[camIndex].cx + this.pc[camIndex].cw && jpy >= this.pc[camIndex].cy - this.pc[camIndex].ch && jpy <= this.pc[camIndex].cy + this.pc[camIndex].ch;
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return dvs.intersects(this.vx - this.vw, this.vy - this.vh, 2L * this.vw, 2L * this.vh);
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        this.pc[i].cw = Math.round((float)this.vw * this.coef);
        this.pc[i].ch = Math.round((float)this.vh * this.coef);
        this.pc[i].aw = Math.round((float)this.arcWidth * this.coef);
        this.pc[i].ah = Math.round((float)this.arcHeight * this.coef);
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        this.pc[i].lcw = Math.round((float)this.vw * this.coef);
        this.pc[i].lch = Math.round((float)this.vh * this.coef);
        this.pc[i].law = Math.round((float)this.arcWidth * this.coef);
        this.pc[i].lah = Math.round((float)this.arcHeight * this.coef);
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cw > 1 && this.pc[i].ch > 1) {
            if (this.filled) {
                g.setColor(this.color);
                if (this.pc[i].aw > 4 || this.pc[i].ah > 4) {
                    g.fillRoundRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch, this.pc[i].aw, this.pc[i].ah);
                } else {
                    g.fillRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                }
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawRoundRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1, this.pc[i].aw, this.pc[i].ah);
                    g.setStroke(stdS);
                } else {
                    g.drawRoundRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1, this.pc[i].aw, this.pc[i].ah);
                }
            }
        } else if (this.pc[i].cw <= 1 ^ this.pc[i].ch <= 1) {
            g.setColor(this.color);
            if (this.pc[i].cw <= 1) {
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy - this.pc[i].ch, 1, 2 * this.pc[i].ch);
            } else if (this.pc[i].ch <= 1) {
                g.fillRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy, 2 * this.pc[i].cw, 1);
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lcw > 1 && this.pc[i].lch > 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.fillRoundRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch, this.pc[i].law, this.pc[i].lah);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawRoundRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1, this.pc[i].law, this.pc[i].lah);
                    g.setStroke(stdS);
                } else {
                    g.drawRoundRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1, this.pc[i].law, this.pc[i].lah);
                }
            }
        } else if (this.pc[i].lcw <= 1 ^ this.pc[i].lch <= 1) {
            g.setColor(this.color);
            if (this.pc[i].lcw <= 1) {
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy - this.pc[i].lch, 1, 2 * this.pc[i].lch);
            } else if (this.pc[i].lch <= 1) {
                g.fillRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy, 2 * this.pc[i].lcw, 1);
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public Object clone() {
        VRoundRect res = new VRoundRect(this.vx, this.vy, 0, this.vw, this.vh, this.color, this.borderColor, this.arcWidth, this.arcHeight);
        res.mouseInsideColor = this.mouseInsideColor;
        return res;
    }
}

