/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.ClosedShape;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.projection.BProjectedCoords;

public class VCircle
extends ClosedShape {
    public long vr;
    public BProjectedCoords[] pc;

    public VCircle() {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0;
        this.vr = 10L;
        this.computeSize();
        this.orient = 0.0f;
        this.setColor(Color.white);
        this.setBorderColor(Color.black);
    }

    public VCircle(long x, long y, int z, long r, Color c) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vr = r;
        this.computeSize();
        this.orient = 0.0f;
        this.setColor(c);
        this.setBorderColor(Color.black);
    }

    public VCircle(long x, long y, int z, long r, Color c, Color bc) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vr = r;
        this.computeSize();
        this.orient = 0.0f;
        this.setColor(c);
        this.setBorderColor(bc);
    }

    public void initCams(int nbCam) {
        this.pc = new BProjectedCoords[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new BProjectedCoords();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                BProjectedCoords[] ta = this.pc;
                this.pc = new BProjectedCoords[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new BProjectedCoords();
            } else {
                System.err.println("VCircle:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new BProjectedCoords[1];
            this.pc[0] = new BProjectedCoords();
        } else {
            System.err.println("VCircle:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float angle) {
    }

    public void orientToNS(float angle) {
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = this.vr;
    }

    public void sizeTo(float radius) {
        this.size = radius;
        this.vr = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void sizeTo(long radius) {
        this.size = radius;
        this.vr = radius;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float factor) {
        this.size *= factor;
        this.vr = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return Math.sqrt(Math.pow(w - (long)this.pc[camIndex].cx, 2.0) + Math.pow(h - (long)this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cr && Math.sqrt(Math.pow(this.pc[camIndex].cx, 2.0) + Math.pow(h - (long)this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cr && Math.sqrt(Math.pow(w - (long)this.pc[camIndex].cx, 2.0) + Math.pow(this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cr && Math.sqrt(Math.pow(this.pc[camIndex].cx, 2.0) + Math.pow(this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cr;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return Math.sqrt(Math.pow(jpx - this.pc[camIndex].cx, 2.0) + Math.pow(jpy - this.pc[camIndex].cy, 2.0)) <= (double)this.pc[camIndex].cr;
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return Math.sqrt(Math.pow(this.vx - dvx, 2.0) + Math.pow(this.vy - dvy, 2.0)) <= (double)(dvr + this.vr);
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        this.pc[i].cr = Math.round((float)this.vr * this.coef);
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        this.pc[i].lcr = Math.round((float)this.vr * this.coef);
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cr > 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.fillOval(dx + this.pc[i].cx - this.pc[i].cr, dy + this.pc[i].cy - this.pc[i].cr, 2 * this.pc[i].cr, 2 * this.pc[i].cr);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawOval(dx + this.pc[i].cx - this.pc[i].cr, dy + this.pc[i].cy - this.pc[i].cr, 2 * this.pc[i].cr, 2 * this.pc[i].cr);
                    g.setStroke(stdS);
                } else {
                    g.drawOval(dx + this.pc[i].cx - this.pc[i].cr, dy + this.pc[i].cy - this.pc[i].cr, 2 * this.pc[i].cr, 2 * this.pc[i].cr);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lcr > 1) {
            if (this.filled) {
                g.setColor(this.color);
                g.fillOval(dx + this.pc[i].lcx - this.pc[i].lcr, dy + this.pc[i].lcy - this.pc[i].lcr, 2 * this.pc[i].lcr, 2 * this.pc[i].lcr);
            }
            if (this.paintBorder) {
                g.setColor(this.borderColor);
                if (this.stroke != null) {
                    g.setStroke(this.stroke);
                    g.drawOval(dx + this.pc[i].lcx - this.pc[i].lcr, dy + this.pc[i].lcy - this.pc[i].lcr, 2 * this.pc[i].lcr, 2 * this.pc[i].lcr);
                    g.setStroke(stdS);
                } else {
                    g.drawOval(dx + this.pc[i].lcx - this.pc[i].lcr, dy + this.pc[i].lcy - this.pc[i].lcr, 2 * this.pc[i].lcr, 2 * this.pc[i].lcr);
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public Object clone() {
        VCircle res = new VCircle(this.vx, this.vy, 0, this.vr, this.color);
        res.borderColor = this.borderColor;
        res.mouseInsideColor = this.mouseInsideColor;
        res.bColor = this.bColor;
        return res;
    }
}

