/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.LText;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class LBText
extends LText {
    Color bColor;
    Color borderColor = null;
    protected float[] HSVb = new float[3];
    Color fillColorThroughLens;
    Color borderColorThroughLens = null;
    boolean visibleThroughLens = this.visible;

    public LBText(long x, long y, int z, Color c, String t) {
        super(x, y, z, c, t);
        this.fillColorThroughLens = this.color;
    }

    public LBText(long x, long y, int z, Color c, String t, short ta) {
        super(x, y, z, c, t, ta);
        this.fillColorThroughLens = this.color;
    }

    public LBText(long x, long y, int z, Color c, String t, short ta, float scale) {
        super(x, y, z, c, t, ta);
        this.fillColorThroughLens = this.color;
        this.scaleFactor = scale;
    }

    public void setVisibleThroughLens(boolean b) {
        this.visibleThroughLens = b;
    }

    public boolean isVisibleThroughLens() {
        return this.visibleThroughLens;
    }

    public void setFillColorThroughLens(Color c) {
        this.fillColorThroughLens = c;
    }

    public void setBorderColorThroughLens(Color c) {
        this.borderColorThroughLens = c;
    }

    public Color getFillColorThroughLens() {
        return this.fillColorThroughLens;
    }

    public Color getBorderColorThroughLens() {
        return this.borderColorThroughLens;
    }

    public void setBorderColor(Color c) {
        this.bColor = this.borderColor = c;
        this.HSVb = Color.RGBtoHSB(this.borderColor.getRed(), this.borderColor.getGreen(), this.borderColor.getBlue(), new float[3]);
        if (this.vsm != null) {
            this.vsm.repaintNow();
        }
    }

    public void setHSVbColor(float h, float s, float v) {
        this.HSVb[0] = h;
        if (this.HSVb[0] > 1.0f) {
            this.HSVb[0] = 1.0f;
        } else if (this.HSVb[0] < 0.0f) {
            this.HSVb[0] = 0.0f;
        }
        this.HSVb[1] = s;
        if (this.HSVb[1] > 1.0f) {
            this.HSVb[1] = 1.0f;
        } else if (this.HSVb[1] < 0.0f) {
            this.HSVb[1] = 0.0f;
        }
        this.HSVb[2] = v;
        if (this.HSVb[2] > 1.0f) {
            this.HSVb[2] = 1.0f;
        } else if (this.HSVb[2] < 0.0f) {
            this.HSVb[2] = 0.0f;
        }
        this.bColor = this.borderColor = Color.getHSBColor(this.HSVb[0], this.HSVb[1], this.HSVb[2]);
        if (this.vsm != null) {
            this.vsm.repaintNow();
        }
    }

    public void addHSVbColor(float h, float s, float v) {
        this.HSVb[0] = this.HSVb[0] + h;
        if (this.HSVb[0] > 1.0f) {
            this.HSVb[0] = 1.0f;
        } else if (this.HSVb[0] < 0.0f) {
            this.HSVb[0] = 0.0f;
        }
        this.HSVb[1] = this.HSVb[1] + s;
        if (this.HSVb[1] > 1.0f) {
            this.HSVb[1] = 1.0f;
        } else if (this.HSVb[1] < 0.0f) {
            this.HSVb[1] = 0.0f;
        }
        this.HSVb[2] = this.HSVb[2] + v;
        if (this.HSVb[2] > 1.0f) {
            this.HSVb[2] = 1.0f;
        } else if (this.HSVb[2] < 0.0f) {
            this.HSVb[2] = 0.0f;
        }
        this.bColor = this.borderColor = Color.getHSBColor(this.HSVb[0], this.HSVb[1], this.HSVb[2]);
        if (this.vsm != null) {
            this.vsm.repaintNow();
        }
    }

    public float[] getHSVbColor() {
        return this.HSVb;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        this.trueCoef = this.scaleFactor * this.coef;
        if (this.trueCoef * fontSize > this.vsm.getTextDisplayedAsSegCoef() || !this.zoomSensitive) {
            g.setFont(this.font != null ? this.font : VirtualSpaceManager.getMainFont());
            if (!this.pc[i].valid) {
                this.bounds = g.getFontMetrics().getStringBounds(this.text, g);
                this.pc[i].cw = (int)Math.round(this.bounds.getWidth() * (double)this.scaleFactor);
                this.pc[i].ch = (int)Math.round(this.bounds.getHeight() * (double)this.scaleFactor);
                this.pc[i].valid = true;
            }
            this.at = this.text_anchor == 0 ? AffineTransform.getTranslateInstance(dx + this.pc[i].cx, dy + this.pc[i].cy) : (this.text_anchor == 1 ? AffineTransform.getTranslateInstance((float)(dx + this.pc[i].cx) - (float)this.pc[i].cw * this.coef / 2.0f, dy + this.pc[i].cy) : AffineTransform.getTranslateInstance((float)(dx + this.pc[i].cx) - (float)this.pc[i].cw * this.coef, dy + this.pc[i].cy));
            if (this.zoomSensitive) {
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
            }
            g.setTransform(this.at);
            if (this.borderColor != null) {
                g.setColor(this.borderColor);
                g.fillRect(dx - 2, dy - this.pc[i].lch + 1, this.pc[i].lcw + 4, this.pc[i].lch + 1);
            }
            g.setColor(this.color);
            g.drawString(this.text, 0.0f, 0.0f);
            g.setTransform(stdT);
        } else {
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        this.trueCoef = this.scaleFactor * this.coef;
        if (this.trueCoef * fontSize > this.vsm.getTextDisplayedAsSegCoef() || !this.zoomSensitive) {
            g.setFont(this.font != null ? this.font : VirtualSpaceManager.getMainFont());
            if (!this.pc[i].lvalid) {
                this.bounds = g.getFontMetrics().getStringBounds(this.text, g);
                this.pc[i].lcw = (int)Math.round(this.bounds.getWidth() * (double)this.scaleFactor);
                this.pc[i].lch = (int)Math.round(this.bounds.getHeight() * (double)this.scaleFactor);
                this.pc[i].lvalid = true;
            }
            this.at = this.text_anchor == 0 ? AffineTransform.getTranslateInstance(dx + this.pc[i].lcx, dy + this.pc[i].lcy) : (this.text_anchor == 1 ? AffineTransform.getTranslateInstance((float)(dx + this.pc[i].lcx) - (float)this.pc[i].lcw * this.coef / 2.0f, dy + this.pc[i].lcy) : AffineTransform.getTranslateInstance((float)(dx + this.pc[i].lcx) - (float)this.pc[i].lcw * this.coef, dy + this.pc[i].lcy));
            if (this.zoomSensitive) {
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
            }
            g.setTransform(this.at);
            if (this.borderColor != null) {
                g.setColor(this.borderColor);
                g.fillRect(dx - 2, dy - this.pc[i].lch + 1, this.pc[i].lcw + 4, this.pc[i].lch + 1);
            }
            g.setColor(this.fillColorThroughLens);
            g.drawString(this.text, 0.0f, 0.0f);
            g.setTransform(stdT);
        } else {
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public Object clone() {
        LBText res = new LBText(this.vx, this.vy, 0, this.color, this.text, this.text_anchor);
        res.borderColor = this.borderColor;
        res.fillColorThroughLens = this.fillColorThroughLens;
        res.borderColorThroughLens = this.borderColorThroughLens;
        res.mouseInsideColor = this.mouseInsideColor;
        res.bColor = this.bColor;
        res.setVisibleThroughLens(this.visibleThroughLens);
        return res;
    }
}

