/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.CameraManager;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.VCursor;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.RectangularShape;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class VirtualSpace {
    public String spaceName;
    public VirtualSpaceManager vsm;
    CameraManager cm = new CameraManager(this);
    Vector visualEnts = new Vector();
    Glyph[] drawingList;
    Vector[] camera2drawnList = new Vector[0];

    public static LongPoint getGlyphSetGeometricalCenter(Glyph[] gl) {
        if (gl != null && gl.length > 0) {
            long[] tmpC = new long[4];
            long size = (long)gl[0].getSize();
            tmpC[0] = gl[0].vx - size;
            tmpC[1] = gl[0].vy + size;
            tmpC[2] = gl[0].vx + size;
            tmpC[3] = gl[0].vy - size;
            for (int i = 1; i < gl.length; ++i) {
                size = (long)gl[i].getSize();
                long tmp = gl[i].vx - size;
                if (tmp < tmpC[0]) {
                    tmpC[0] = tmp;
                }
                if ((tmp = gl[i].vy + size) > tmpC[1]) {
                    tmpC[1] = tmp;
                }
                if ((tmp = gl[i].vx + size) > tmpC[2]) {
                    tmpC[2] = tmp;
                }
                if ((tmp = gl[i].vy - size) >= tmpC[3]) continue;
                tmpC[3] = tmp;
            }
            return new LongPoint((tmpC[2] + tmpC[0]) / 2L, (tmpC[1] + tmpC[3]) / 2L);
        }
        return new LongPoint(0L, 0L);
    }

    VirtualSpace(String n) {
        this.drawingList = new Glyph[0];
        this.spaceName = n;
    }

    public String getName() {
        return this.spaceName;
    }

    public Camera getCamera(int i) {
        return this.cm.getCamera(i);
    }

    public Vector getCameraList() {
        Vector<Camera> res = new Vector<Camera>();
        for (int i = 0; i < this.cm.cameraList.length; ++i) {
            res.add(this.cm.cameraList[i]);
        }
        return res;
    }

    public Camera[] getCameraListAsArray() {
        return this.cm.cameraList;
    }

    Camera createCamera() {
        Camera c = this.cm.addCamera();
        Vector[] newDrawnListList = new Vector[this.camera2drawnList.length + 1];
        System.arraycopy(this.camera2drawnList, 0, newDrawnListList, 0, this.camera2drawnList.length);
        newDrawnListList[this.camera2drawnList.length] = new Vector();
        this.camera2drawnList = newDrawnListList;
        c.setOwningSpace(this);
        Enumeration e = this.visualEnts.elements();
        while (e.hasMoreElements()) {
            Glyph g = (Glyph)e.nextElement();
            g.addCamera(c.getIndex());
        }
        return c;
    }

    public void removeCamera(int i) {
        if (this.cm.cameraList.length > i) {
            for (int j = 0; j < this.vsm.allViews.length; ++j) {
                if (!this.vsm.allViews[j].cameras.contains(this.cm.getCamera(i))) continue;
                this.vsm.allViews[j].destroyCamera(this.cm.getCamera(i));
            }
            Enumeration e = this.visualEnts.elements();
            while (e.hasMoreElements()) {
                Glyph g = (Glyph)e.nextElement();
                g.removeCamera(i);
            }
            this.cm.removeCamera(i);
            this.camera2drawnList[i] = null;
        }
    }

    protected void destroy() {
        for (int i = 0; i < this.cm.cameraList.length; ++i) {
            this.removeCamera(i);
        }
        Enumeration e = this.visualEnts.elements();
        while (e.hasMoreElements()) {
            this.removeGlyph((Glyph)e.nextElement());
        }
    }

    void addGlyph(Glyph g) {
        g.initCams(this.cm.cameraList.length);
        this.visualEnts.add(g);
        this.addGlyphToDrawingList(g);
    }

    public Vector getAllGlyphs() {
        return this.visualEnts;
    }

    public Vector getVisibleGlyphs() {
        Vector<Glyph> res = new Vector<Glyph>();
        for (int i = 0; i < this.drawingList.length; ++i) {
            res.add(this.drawingList[i]);
        }
        return res;
    }

    public Glyph[] getDrawingList() {
        return this.drawingList;
    }

    public Glyph[] getVisibleGlyphList() {
        Glyph[] res = new Glyph[this.drawingList.length];
        System.arraycopy(this.drawingList, 0, res, 0, this.drawingList.length);
        return res;
    }

    public Vector getDrawnGlyphs() {
        if (this.camera2drawnList.length > 0) {
            return this.camera2drawnList[0];
        }
        return null;
    }

    public Vector getDrawnGlyphs(int cameraIndex) {
        if (cameraIndex < this.camera2drawnList.length) {
            return this.camera2drawnList[cameraIndex];
        }
        return null;
    }

    protected void drewGlyph(Glyph gl, int cameraIndex) {
        if (cameraIndex < this.camera2drawnList.length && this.camera2drawnList[cameraIndex] != null) {
            this.camera2drawnList[cameraIndex].add(gl);
        }
    }

    public Vector getSelectedGlyphs() {
        Vector<Glyph> v = new Vector<Glyph>();
        Enumeration e = this.visualEnts.elements();
        while (e.hasMoreElements()) {
            Glyph g = (Glyph)e.nextElement();
            if (!g.isSelected()) continue;
            v.add(g);
        }
        return v;
    }

    public void selectAllGlyphs() {
        Enumeration e = this.visualEnts.elements();
        while (e.hasMoreElements()) {
            ((Glyph)e.nextElement()).select(true);
        }
    }

    public void unselectAllGlyphs() {
        Enumeration e = this.visualEnts.elements();
        while (e.hasMoreElements()) {
            ((Glyph)e.nextElement()).select(false);
        }
    }

    public Vector getGlyphsOfType(String t) {
        Vector<Glyph> v = new Vector<Glyph>();
        Enumeration e = this.visualEnts.elements();
        while (e.hasMoreElements()) {
            Glyph g = (Glyph)e.nextElement();
            if (!t.equals("") && !t.equals(g.getType())) continue;
            v.add(g);
        }
        return v;
    }

    public void removeGlyph(Long gID) {
        this.removeGlyph(this.vsm.getGlyph(gID), true);
    }

    public void removeGlyph(Long gID, boolean repaint) {
        this.removeGlyph(this.vsm.getGlyph(gID), repaint);
    }

    public void removeGlyph(Glyph g) {
        this.removeGlyph(g, true);
    }

    public void removeGlyph(Glyph g, boolean repaint) {
        try {
            if (g.stickedTo != null) {
                if (g.stickedTo instanceof Glyph) {
                    ((Glyph)g.stickedTo).unstick(g);
                } else if (g.stickedTo instanceof Camera) {
                    ((Camera)g.stickedTo).unstick(g);
                } else {
                    ((VCursor)g.stickedTo).unstickSpecificGlyph(g);
                }
            }
            if (g.getCGlyph() != null) {
                g.getCGlyph().removeSecondaryGlyph(g);
            }
            for (int i = 0; i < this.camera2drawnList.length; ++i) {
                if (this.camera2drawnList[i] == null) continue;
                this.camera2drawnList[i].remove(g);
            }
            for (int i = 0; i < this.cm.cameraList.length; ++i) {
                if (this.cm.cameraList[i] == null || this.cm.cameraList[i].view == null) continue;
                this.cm.cameraList[i].view.mouse.removeGlyphFromList(g);
            }
            this.visualEnts.remove(g);
            this.removeGlyphFromDrawingList(g);
            this.vsm.allGlyphs.remove(g.getID());
            if (repaint) {
                this.vsm.repaintNow();
            }
        }
        catch (NullPointerException ex) {
            System.err.println("ZVTM Error: VirtualSpace.removeGlyph(): the glyph you are trying to delete might not be a member of this virtual space (" + this.spaceName + ") or might be null");
            ex.printStackTrace();
        }
    }

    public void destroyGlyph(Long gID) {
        this.removeGlyph(this.vsm.getGlyph(gID), true);
    }

    public void destroyGlyph(Long gID, boolean repaint) {
        this.removeGlyph(this.vsm.getGlyph(gID), repaint);
    }

    public void destroyGlyph(Glyph g) {
        this.removeGlyph(g, true);
    }

    public void destroyGlyph(Glyph g, boolean repaint) {
        this.removeGlyph(g, repaint);
    }

    public void show(Glyph g) {
        if (this.visualEnts.contains(g) && this.glyphIndexInDrawingList(g) == -1) {
            this.addGlyphToDrawingList(g);
        }
        this.vsm.repaintNow();
    }

    public void hide(Glyph g) {
        this.removeGlyphFromDrawingList(g);
        g.resetMouseIn();
        for (int i = 0; i < this.cm.cameraList.length; ++i) {
            if (this.cm.cameraList[i] == null || this.cm.cameraList[i].view == null) continue;
            this.cm.cameraList[i].view.mouse.removeGlyphFromList(g);
        }
        this.vsm.repaintNow();
    }

    public void onTop(Glyph g) {
        if (this.glyphIndexInDrawingList(g) != -1) {
            this.removeGlyphFromDrawingList(g);
            this.addGlyphToDrawingList(g);
            g.setZindex(this.drawingList.length > 0 ? this.drawingList[this.drawingList.length - 1].getZindex() : 0);
        }
    }

    public void atBottom(Glyph g) {
        if (this.glyphIndexInDrawingList(g) != -1) {
            this.removeGlyphFromDrawingList(g);
            this.insertGlyphInDrawingList(g, 0);
            g.setZindex(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onTop(Glyph g, int z) {
        if (this.glyphIndexInDrawingList(g) == -1) return;
        this.removeGlyphFromDrawingList(g);
        int insertAt = 0;
        Glyph[] glyphArray = this.drawingList;
        synchronized (this.drawingList) {
            for (int i = this.drawingList.length - 1; i >= 0; --i) {
                if (this.drawingList[i].getZindex() > z) continue;
                insertAt = i + 1;
                break;
            }
            this.insertGlyphInDrawingList(g, insertAt);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            g.setZindex(z);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void atBottom(Glyph g, int z) {
        if (this.glyphIndexInDrawingList(g) == -1) return;
        this.removeGlyphFromDrawingList(g);
        int insertAt = 0;
        Glyph[] glyphArray = this.drawingList;
        synchronized (this.drawingList) {
            for (int i = 0; i < this.drawingList.length; ++i) {
                if (this.drawingList[i].getZindex() <= z) continue;
                insertAt = i;
                break;
            }
            this.insertGlyphInDrawingList(g, insertAt);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            g.setZindex(z);
            return;
        }
    }

    public void above(Glyph g1, Glyph g2) {
        if (g1 == g2) {
            return;
        }
        if (this.glyphIndexInDrawingList(g1) != -1 && this.glyphIndexInDrawingList(g2) != -1) {
            this.removeGlyphFromDrawingList(g1);
            int i = this.glyphIndexInDrawingList(g2);
            this.insertGlyphInDrawingList(g1, i + 1);
            g1.setZindex(g2.getZindex());
        }
    }

    public void below(Glyph g1, Glyph g2) {
        if (g1 == g2) {
            return;
        }
        if (this.glyphIndexInDrawingList(g1) != -1 && this.glyphIndexInDrawingList(g2) != -1) {
            this.removeGlyphFromDrawingList(g1);
            int i = this.glyphIndexInDrawingList(g2);
            this.insertGlyphInDrawingList(g1, i);
            g1.setZindex(g2.getZindex());
        }
    }

    void setManager(VirtualSpaceManager v) {
        this.vsm = v;
    }

    public long[] findFarmostGlyphCoords() {
        long[] res = new long[4];
        return this.findFarmostGlyphCoords(res);
    }

    public long[] findFarmostGlyphCoords(long[] res) {
        Glyph[] gl = this.getVisibleGlyphList();
        if (gl.length > 0) {
            long size;
            RectangularShape rs;
            if (gl[0] instanceof RectangularShape) {
                rs = (RectangularShape)((Object)gl[0]);
                res[0] = gl[0].vx - rs.getWidth();
                res[1] = gl[0].vy + rs.getHeight();
                res[2] = gl[0].vx + rs.getWidth();
                res[3] = gl[0].vy - rs.getHeight();
            } else {
                size = (long)gl[0].getSize();
                res[0] = gl[0].vx - size;
                res[1] = gl[0].vy + size;
                res[2] = gl[0].vx + size;
                res[3] = gl[0].vy - size;
            }
            for (int i = 1; i < gl.length; ++i) {
                long tmp;
                if (gl[i] instanceof RectangularShape) {
                    rs = (RectangularShape)((Object)gl[i]);
                    tmp = gl[i].vx - rs.getWidth();
                    if (tmp < res[0]) {
                        res[0] = tmp;
                    }
                    if ((tmp = gl[i].vy + rs.getHeight()) > res[1]) {
                        res[1] = tmp;
                    }
                    if ((tmp = gl[i].vx + rs.getWidth()) > res[2]) {
                        res[2] = tmp;
                    }
                    if ((tmp = gl[i].vy - rs.getHeight()) >= res[3]) continue;
                    res[3] = tmp;
                    continue;
                }
                size = (long)gl[i].getSize();
                tmp = gl[i].vx - size;
                if (tmp < res[0]) {
                    res[0] = tmp;
                }
                if ((tmp = gl[i].vy + size) > res[1]) {
                    res[1] = tmp;
                }
                if ((tmp = gl[i].vx + size) > res[2]) {
                    res[2] = tmp;
                }
                if ((tmp = gl[i].vy - size) >= res[3]) continue;
                res[3] = tmp;
            }
            return res;
        }
        Arrays.fill(res, 0L);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addGlyphToDrawingList(Glyph g) {
        int zindex = g.getZindex();
        int insertAt = 0;
        Glyph[] glyphArray = this.drawingList;
        synchronized (this.drawingList) {
            for (int i = this.drawingList.length - 1; i >= 0; --i) {
                if (this.drawingList[i].getZindex() > zindex) continue;
                insertAt = i + 1;
                break;
            }
            this.insertGlyphInDrawingList(g, insertAt);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertGlyphInDrawingList(Glyph g, int index) {
        Glyph[] glyphArray = this.drawingList;
        synchronized (this.drawingList) {
            Glyph[] newDrawingList = new Glyph[this.drawingList.length + 1];
            System.arraycopy(this.drawingList, 0, newDrawingList, 0, index);
            newDrawingList[index] = g;
            System.arraycopy(this.drawingList, index, newDrawingList, index + 1, this.drawingList.length - index);
            this.drawingList = newDrawingList;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeGlyphFromDrawingList(Glyph g) {
        Glyph[] glyphArray = this.drawingList;
        synchronized (this.drawingList) {
            for (int i = 0; i < this.drawingList.length; ++i) {
                if (this.drawingList[i] != g) continue;
                Glyph[] newDrawingList = new Glyph[this.drawingList.length - 1];
                System.arraycopy(this.drawingList, 0, newDrawingList, 0, i);
                System.arraycopy(this.drawingList, i + 1, newDrawingList, i, this.drawingList.length - i - 1);
                this.drawingList = newDrawingList;
                break;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int glyphIndexInDrawingList(Glyph g) {
        Glyph[] glyphArray = this.drawingList;
        synchronized (this.drawingList) {
            for (int i = 0; i < this.drawingList.length; ++i) {
                if (this.drawingList[i] != g) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return -1;
        }
    }
}

