(* $Id: http_client_aux.mli,v 1.1.2.2 2001/12/15 16:15:48 gerd Exp $
 * ----------------------------------------------------------------------
 * Auxiliary functions for which two implementations exist, one which is
 * multi-threading safe, one which is not.
 *)

(* The following functions match strings with a fixed pattern and return
 * the interesting substrings. 
 * Always Not_found is raised if matching fails.
 *)

val match_query : string -> (string * int * string)
val match_status : string -> (string * int * string)
val match_header_line : string -> (string * string)
val match_hex : string -> string
val match_ip : string -> string
val match_http : string -> (string option *
			    string option *
			    string *
			    int *
			    string)

(* Splits a string into pieces separated by a pattern: *)

val split_words_by_commas : string -> string list

(* The Unix system calls that are different in an MT environment: *)

module Unx :
    sig
      val execv : string -> string array -> unit
      val execve : string -> string array -> string array -> unit
      val execvp : string -> string array -> unit
      val wait : unit -> int * Unix.process_status
      val waitpid : Unix.wait_flag list -> int -> int * Unix.process_status
      val system : string -> Unix.process_status
      val read : Unix.file_descr -> string -> int -> int -> int
      val write : Unix.file_descr -> string -> int -> int -> int
      val select :
	  Unix.file_descr list -> Unix.file_descr list ->
	    Unix.file_descr list -> float ->
	      Unix.file_descr list * Unix.file_descr list * Unix.file_descr list
      val pipe : unit -> Unix.file_descr * Unix.file_descr
      val open_process_in: string -> in_channel
      val open_process_out: string -> out_channel
      val open_process: string -> in_channel * out_channel
      val sleep : int -> unit
      val socket : Unix.socket_domain -> Unix.socket_type -> int -> Unix.file_descr
      val socketpair : Unix.socket_domain -> Unix.socket_type -> int ->
	Unix.file_descr * Unix.file_descr
      val accept : Unix.file_descr -> Unix.file_descr * Unix.sockaddr
      val connect : Unix.file_descr -> Unix.sockaddr -> unit
      val recv : Unix.file_descr -> string -> int -> int -> Unix.msg_flag list -> int
      val recvfrom : Unix.file_descr -> string -> int -> int ->
	Unix.msg_flag list -> int * Unix.sockaddr
      val send : Unix.file_descr -> string -> int -> int ->
	Unix.msg_flag list -> int
      val sendto : Unix.file_descr -> string -> int -> int ->
	Unix.msg_flag list -> Unix.sockaddr -> int
      val open_connection : Unix.sockaddr -> in_channel * out_channel
      val establish_server :
	  (in_channel -> out_channel -> unit) -> Unix.sockaddr -> unit
    end

(* Mutexes: *)

module Mtx :
    sig
      type t
      val create: unit -> t
      val lock: t -> unit
      val try_lock: t -> bool
      val unlock: t -> unit
    end


(* ======================================================================
 * History:
 * 
 * $Log: http_client_aux.mli,v $
 * Revision 1.1.2.2  2001/12/15 16:15:48  gerd
 * 	Updates for O'Caml 3.04
 *
 * Revision 1.1.2.1  2000/04/26 17:36:35  gerd
 * 	Upgrade for O'Caml 3.
 *
 * Revision 1.1  1999/07/08 03:00:44  gerd
 * 	Initial revision.
 *
 * 
 *)
