/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2015 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2015 Sun Microsystems, Inc.
 */
package org.netbeans.modules.php.composer.util;

import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.composer.commands.Composer;
import org.netbeans.modules.web.common.api.UsageLogger;
import org.openide.filesystems.FileObject;

public final class ComposerUtils {

    private static final String USAGE_LOGGER_NAME = "org.netbeans.ui.metrics.php.composer"; // NOI18N
    private static final UsageLogger COMPOSER_REQUIRE_USAGE_LOGGER = new UsageLogger.Builder(USAGE_LOGGER_NAME)
            .message(ComposerUtils.class, "USG_COMPOSER_EDIT") // NOI18N
            .create();
    private static final UsageLogger COMPOSER_LIBRARY_USAGE_LOGGER = new UsageLogger.Builder(USAGE_LOGGER_NAME)
            .message(ComposerUtils.class, "USG_COMPOSER_LIBRARY") // NOI18N
            .firstMessageOnly(false)
            .create();


    private ComposerUtils() {
        throw new IllegalStateException("no instances allowed");
    }

    public static void logUsageComposerRequire() {
        COMPOSER_REQUIRE_USAGE_LOGGER.log();
    }

    public static void logUsageComposerLibrary(String type, String name, String version) {
        COMPOSER_LIBRARY_USAGE_LOGGER.log(type, name, version);
    }

    /**
     * Gets Composer working directory. Prefers project directory but can return
     * source directory if <tt>composer.json</tt> already exists there.
     * @param phpModule PHP module to be used for detection
     * @return Composer working directory
     */
    @NonNull
    public static FileObject getComposerWorkDir(@NonNull PhpModule phpModule) {
        assert phpModule != null;
        // first project dir
        FileObject projectDirectory = phpModule.getProjectDirectory();
        if (projectDirectory.getFileObject(Composer.COMPOSER_FILENAME) != null) {
            return projectDirectory;
        }
        // now source dir
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory != null
                && sourceDirectory.getFileObject(Composer.COMPOSER_FILENAME) != null) {
            return sourceDirectory;
        }
        return projectDirectory;
    }

}
