/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2009 Sun Microsystems, Inc.
 */

/*
 * ContactListCellRenderer.java
 *
 * Created on Aug 3, 2009, 11:23:06 AM
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;

/**
 *
 * @author Jan Becicka
 */
public class FilterRenderer extends javax.swing.JPanel implements ListCellRenderer {

    /** Creates new form ContactListCellRenderer */
    public FilterRenderer() {
        initComponents();
        setOpaque(true);
        groupLabel.setOpaque(true);
        groupLabel.setFont(groupLabel.getFont().deriveFont(Font.BOLD));
        kenaiName.setOpaque(true);
        setBorder(new EmptyBorder(1,1,1,1));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        groupLabel = new javax.swing.JLabel();
        kenaiName = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        groupLabel.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(groupLabel, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        add(kenaiName, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    public Component getListCellRendererComponent(
            JList list,
            Object value,
            int index,
            boolean isSelected,
            boolean cellHasFocus) {
        if (value!=null) {
            groupLabel.setText(value.toString());
            FilterItem item = (FilterItem) value;
            groupLabel.setBorder(new EmptyBorder(0, item.getIcon() == null ? 22 : 3, 0, 0));
            groupLabel.setIcon(item.getIcon());
            if (KenaiManager.getDefault().getKenais().size() > 1) {
                if (item.getKenaiProject()!=null)  {
                    kenaiName.setText(item.getKenaiProject().getKenai().getName());
                } else {
                    kenaiName.setText("");
                }
            } else {
                kenaiName.setText("");
            }
        }
        groupLabel.setOpaque(isSelected);

        if (isSelected) {
            groupLabel.setBackground(list.getSelectionBackground()); // NOI18N
            groupLabel.setForeground(list.getSelectionForeground()); // NOI18N
            this.setBackground(list.getSelectionBackground());
            kenaiName.setBackground(list.getSelectionBackground());
            kenaiName.setForeground(list.getSelectionForeground());
        } else {
            groupLabel.setBackground(ColorManager.getDefault().getDefaultBackground()); // NOI18N
            groupLabel.setForeground(list.getForeground()); // NOI18N
            this.setBackground(ColorManager.getDefault().getDefaultBackground());
            kenaiName.setBackground(ColorManager.getDefault().getDefaultBackground());
            kenaiName.setForeground(Color.gray);
        }
        this.setPreferredSize(new Dimension(10, getPreferredSize().height));
        return this;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel groupLabel;
    private javax.swing.JLabel kenaiName;
    // End of variables declaration//GEN-END:variables
}
