/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2009 Sun Microsystems, Inc.
 */

/*
 * SelectReactorDirectoryPanel.java
 *
 * Created on Jan 28, 2009, 4:01:00 PM
 */

package org.netbeans.modules.maven.execute;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/**
 *
 * @author mkleint
 */
public class SelectReactorDirectoryPanel extends javax.swing.JPanel {
    private File basedir;
    private Project project;

    /** Creates new form SelectReactorDirectoryPanel */
    public SelectReactorDirectoryPanel(File basedir, Project prj) {
        initComponents();
        btnReactor.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        btnReactor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                try {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://maven.apache.org/plugins/maven-reactor-plugin/index.html")); //NOI18N
                } catch (MalformedURLException ex) {
                    Exceptions.printStackTrace(ex);
                }
            }
        });
        this.basedir = basedir;
        project = prj;
        String relative = FileUtilities.relativizeFile(FileUtil.toFile(project.getProjectDirectory()), basedir);
        txtDirectory.setText(relative);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblText = new javax.swing.JLabel();
        btnReactor = new javax.swing.JButton();
        lblDirectory = new javax.swing.JLabel();
        txtDirectory = new javax.swing.JTextField();
        btnDirectory = new javax.swing.JButton();

        lblText.setText(org.openide.util.NbBundle.getMessage(SelectReactorDirectoryPanel.class, "SelectReactorDirectoryPanel.lblText.text")); // NOI18N
        lblText.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        btnReactor.setText(org.openide.util.NbBundle.getMessage(SelectReactorDirectoryPanel.class, "SelectReactorDirectoryPanel.btnReactor.text")); // NOI18N
        btnReactor.setBorderPainted(false);
        btnReactor.setContentAreaFilled(false);
        btnReactor.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);

        lblDirectory.setText(org.openide.util.NbBundle.getMessage(SelectReactorDirectoryPanel.class, "SelectReactorDirectoryPanel.lblDirectory.text")); // NOI18N

        txtDirectory.setEditable(false);

        btnDirectory.setText(org.openide.util.NbBundle.getMessage(SelectReactorDirectoryPanel.class, "SelectReactorDirectoryPanel.btnDirectory.text")); // NOI18N
        btnDirectory.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnDirectoryActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, lblText, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 488, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, layout.createSequentialGroup()
                        .add(lblDirectory)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(txtDirectory, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 143, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(btnDirectory))
                    .add(btnReactor))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(20, 20, 20)
                .add(lblText, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 118, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(btnReactor)
                .add(9, 9, 9)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblDirectory)
                    .add(txtDirectory, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(btnDirectory))
                .add(24, 24, 24))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void btnDirectoryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDirectoryActionPerformed
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(NbBundle.getMessage(SelectReactorDirectoryPanel.class, "TIT_ReactorDir"));
        FileObject current = project.getProjectDirectory();
        String rel = txtDirectory.getText().trim();
        if (rel.length() == 0) {
            rel = "../";
        }
        File selected = FileUtilities.resolveFilePath(FileUtil.toFile(current), rel);
        chooser.setSelectedFile(selected);
        int ret = chooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(SelectReactorDirectoryPanel.class, "BTN_ReactorDir"));
        if (ret == JFileChooser.APPROVE_OPTION) {
            selected = chooser.getSelectedFile();
            String relative = FileUtilities.relativizeFile(FileUtil.toFile(current), selected);
            txtDirectory.setText(relative);

        }
    }//GEN-LAST:event_btnDirectoryActionPerformed

    public String getRelativePath() {
        return txtDirectory.getText();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnDirectory;
    private javax.swing.JButton btnReactor;
    private javax.swing.JLabel lblDirectory;
    private javax.swing.JLabel lblText;
    private javax.swing.JTextField txtDirectory;
    // End of variables declaration//GEN-END:variables

}
